/*
 * mesham.h
 *
 *  Created on: 17 July 2012
 *      Author: Nick Brown
 */

#include <inttypes.h>
#include <stdio.h>
#include <setjmp.h>

#ifndef MESHAM_H_
#define MESHAM_H_

// Communication layer
typedef int MESHAM_c_processgroup_container;

typedef int MESHAM_c_processgroup_communicator;
#define MESHAM_c_COMM_WORLD ((MESHAM_c_processgroup_communicator)0x44000000)
#define MESHAM_c_COMM_SELF  ((MESHAM_c_processgroup_communicator)0x44000001)

typedef int MESHAM_c_datatype;
#define MESHAM_c_CHAR		((MESHAM_c_datatype)0x4c000101)
#define MESHAM_c_BYTE		((MESHAM_c_datatype)0x4c00010d)
#define MESHAM_c_SHORT		((MESHAM_c_datatype)0x4c000203)
#define MESHAM_c_INT		((MESHAM_c_datatype)0x4c000405)
#define MESHAM_c_UNSIGNED	((MESHAM_c_datatype)0x4c000406)
#define MESHAM_c_LONG		((MESHAM_c_datatype)0x4c000807)
#define MESHAM_c_FLOAT		((MESHAM_c_datatype)0x4c00040a)
#define MESHAM_c_DOUBLE		((MESHAM_c_datatype)0x4c00080b)

typedef int MESHAM_c_op;
#define MESHAM_c_MAX	((MESHAM_c_op)0x58000001)
#define MESHAM_c_MIN	((MESHAM_c_op)0x58000002)
#define MESHAM_c_SUM	((MESHAM_c_op)0x58000003)
#define MESHAM_c_PROD	((MESHAM_c_op)0x58000004)

typedef int MESHAM_c_epochlock;
#define MESHAM_c_EPOCH_LOCKSHARED 		((MESHAM_c_epochlock)0)
#define MESHAM_c_EPOCH_LOCKNONE			((MESHAM_c_epochlock)1)
#define MESHAM_c_EPOCH_LOCKEXCLUSIVE 	((MESHAM_c_epochlock)2)

typedef int MESHAM_c_request;
#define MESHAM_c_REQUEST_NULL   ((MESHAM_c_request)0x2c000000)

void MESHAM_c_init(int*, char***);
void MESHAM_c_finalize();
void MESHAM_c_getGroupRank(MESHAM_c_processgroup_communicator,int*);
void MESHAM_c_getGroupSize(MESHAM_c_processgroup_communicator,int*);
void MESHAM_c_getProcessGroupContainer(MESHAM_c_processgroup_communicator, MESHAM_c_processgroup_container*);
void MESHAM_c_createProcessGroupContainer(int, int*, MESHAM_c_processgroup_container*);
void MESHAM_c_getProcessGroupCommunicator(MESHAM_c_processgroup_container, MESHAM_c_processgroup_communicator*);
void MESHAM_c_createCommunicationBuffer(void*,int);
void MESHAM_c_freeCommunicationBuffer(void*,int);
void MESHAM_c_waitForRequest(MESHAM_c_request*);
void MESHAM_c_waitForMultipleRequests(int n, MESHAM_c_request*);
void MESHAM_c_testRequest(MESHAM_c_request*, int*);
void MESHAM_c_barrier(MESHAM_c_processgroup_communicator);
void MESHAM_c_send(void*, int, MESHAM_c_datatype, int, int, MESHAM_c_processgroup_communicator);
void MESHAM_c_isend(char*, void*, int, MESHAM_c_datatype, int, int, MESHAM_c_processgroup_communicator, MESHAM_c_request*);
void MESHAM_c_irecv(char*, void*, int, MESHAM_c_datatype, int, int, MESHAM_c_processgroup_communicator, MESHAM_c_request*);
void MESHAM_c_bsend(char*, int, void*, int, MESHAM_c_datatype, int, int, MESHAM_c_processgroup_communicator);
void MESHAM_c_rsend(void*, int, MESHAM_c_datatype, int, int, MESHAM_c_processgroup_communicator);
void MESHAM_c_ssend(void*, int, MESHAM_c_datatype, int, int, MESHAM_c_processgroup_communicator);
void MESHAM_c_recv(void*, int, MESHAM_c_datatype, int, int, MESHAM_c_processgroup_communicator);
void MESHAM_c_reduce(void*, void*, int, MESHAM_c_datatype, MESHAM_c_op, int, MESHAM_c_processgroup_communicator);
void MESHAM_c_scatter(void*, int, MESHAM_c_datatype, void*, int, MESHAM_c_datatype, int, MESHAM_c_processgroup_communicator);
void MESHAM_c_scatterv(void*, int*, int*, MESHAM_c_datatype, void*, int, MESHAM_c_datatype, int, MESHAM_c_processgroup_communicator);
void MESHAM_c_gather(void*, int, MESHAM_c_datatype, void*, int, MESHAM_c_datatype, int, MESHAM_c_processgroup_communicator);
void MESHAM_c_gatherv(void*, int, MESHAM_c_datatype, void*, int*, int*, MESHAM_c_datatype, int, MESHAM_c_processgroup_communicator);
void MESHAM_c_bcast(void*, int, MESHAM_c_datatype, int, MESHAM_c_processgroup_communicator);
void MESHAM_c_allreduce (void*, void*, int, MESHAM_c_datatype, MESHAM_c_op, MESHAM_c_processgroup_communicator);
void MESHAM_c_alltoall(void*, int, MESHAM_c_datatype, void*, int, MESHAM_c_datatype, MESHAM_c_processgroup_communicator);
void MESHAM_c_alltoallv(void*, int*, int*, MESHAM_c_datatype, void*, int*, int*, MESHAM_c_datatype, MESHAM_c_processgroup_communicator);
void MESHAM_c_registerRMAEpochLocalData(void*, int, int, int, char*, MESHAM_c_processgroup_communicator);
void MESHAM_c_registerRMAEpochNoLocalData(int, int, char*, MESHAM_c_processgroup_communicator);
void MESHAM_c_closeRMAEpoch(int);
void MESHAM_c_synchroniseRMAEpoch(int);
void MESHAM_c_remoteRMAWrite(void*, int, MESHAM_c_datatype, int, int, int, MESHAM_c_datatype, int);
void MESHAM_c_remoteRMARead(void*, int, MESHAM_c_datatype, int, int, int, MESHAM_c_datatype, int);
void MESHAM_c_lockEpoch(MESHAM_c_epochlock, int, int);
void MESHAM_c_unlockEpoch(int, int);
double MESHAM_c_wtime();
void MESHAM_c_setProcessGroupErrorHandler(MESHAM_c_processgroup_communicator, void(*)(MESHAM_c_processgroup_communicator*,int*));
char * MESHAM_c_getErrorString(int);
void MESHAM_c_spawnProcessors(int, int, char**, void(*)(int, char**, void(*)(int, char**)), void(*)(int, char**));
void MESHAM_c_displayCommLayerSummary();

// IO
void MESHAM_rtl_close(FILE *);
char * MESHAM_rtl_input();
FILE* MESHAM_rtl_open(char *, char *);
void MESHAM_rtl_print(char *);
char MESHAM_rtl_readchar(FILE *);
char * MESHAM_rtl_readline(FILE *);
void MESHAM_rtl_writestring(FILE *, char *);
void MESHAM_rtl_writebinary(FILE *, int);

// Maths
double MESHAM_rtl_cos(double);
double MESHAM_rtl_sin(double);
double MESHAM_rtl_tan(double);
double MESHAM_rtl_acos(double);
double MESHAM_rtl_asin(double);
double MESHAM_rtl_atan(double);
double MESHAM_rtl_cosh(double);
double MESHAM_rtl_sinh(double);
double MESHAM_rtl_tanh(double);
double MESHAM_rtl_floor(double);
double MESHAM_rtl_ceil(double);
int32_t MESHAM_rtl_getprime(int32_t);
double MESHAM_rtl_log(double);
double MESHAM_rtl_log10(double);
int32_t MESHAM_rtl_mod(int32_t, int32_t);
double MESHAM_rtl_pi();
double MESHAM_rtl_randomnumber(double, double);
double MESHAM_rtl_sqrt(double);
double MESHAM_rtl_pow(double, double);
double MESHAM_rtl_exp(double);

// String
char* MESHAM_rtl_itostring(int32_t);
char* MESHAM_rtl_dtostring(double, char*);
int32_t MESHAM_rtl_toint(char *);
int32_t MESHAM_rtl_strlen(char *);
char * MESHAM_rtl_substring(char *, int32_t, int32_t);
char * MESHAM_rtl_lowercase(char *);
char * MESHAM_rtl_uppercase(char *);
char MESHAM_rtl_charat(char *, int32_t);
char * MESHAM_rtl_createString(char *);
char * MESHAM_rtl_stringAppend(char *, char *);
int32_t MESHAM_rtl_findchar(char *, char);
int32_t MESHAM_rtl_findrchar(char *, char);
int32_t MESHAM_rtl_findstr(char *, char *);
char * MESHAM_rtl_trim(char *);

// System standard functions
int64_t MESHAM_rtl_getepoch();
void MESHAM_rtl_displaytime();
void MESHAM_rtl_recordtime();
void MESHAM_rtl_gc();
void MESHAM_rtl_exit();
void MESHAM_rtl_sleep(long);
void MESHAM_rtl_oscli(char *);

// System misc
void MESHAM_rtl_InitRTL(int,int,int,char*, char**, int, char*, int, void(*)(int, char**));
void MESHAM_rtl_finalize();
void* MESHAM_rtl_malloc(int);
void MESHAM_rtl_free(void *);
void MESHAM_rtl_memcpy(void*, void*, int);
int* MESHAM_rtl_createTempInteger(int);
double* MESHAM_rtl_createTempDouble(double);
char* MESHAM_rtl_createTempChar(char);
char* MESHAM_rtl_createTempString(char*);
int * MESHAM_rtl_createPIDArray(int, ...);
int MESHAM_rtl_getNthMember(int, ...);
int MESHAM_rtl_getFirstMemberNotProvided(int, ...);
MESHAM_c_op MESHAM_rtl_convertToCommReductionOperation(char*);
void * MESHAM_rtl_createMemoryData(size_t, void*);
void MESHAM_rtl_createProcessSubContainer(int, int, ...);
MESHAM_c_processgroup_container* MESHAM_rtl_getProcessSubGroup(int);
MESHAM_c_processgroup_communicator* MESHAM_rtl_getProcessSubCommunicator(int);
void MESHAM_rtl_allocateDataPerProcess(size_t,void**);
int MESHAM_rtl_getMyProcessDataId();

// Parallel
int32_t MESHAM_rtl_pid();
int32_t MESHAM_rtl_processes();

// Async communication
double MESHAM_rtl_asynccomm_allreduce(char *, double*, MESHAM_c_op);

// Partition
void * MESHAM_rtl_evendistribute_partitions(int, int, int*, int*, int, char*, char*);
void * MESHAM_rtl_arraydistribute_partitions(int, int, int*, int*, int, char*, char*, int32_t*);
void * MESHAM_rtl_distribution_getdataref_fromglobalindex(char*, int, ...);
void * MESHAM_rtl_distribution_getdataref_fromlocalindex(char*, int, ...);
void MESHAM_rtl_distribution_cacheBlockDimensions(char *, int*);
void MESHAM_rtl_distribution_setdata_fromglobalindex(char*, void*, int, ...);
void MESHAM_rtl_distribution_setdata_fromlocalindex(char*, void *, int, ...);
int MESHAM_rtl_getmypartitiondatasize(char*);
int MESHAM_rtl_getmypartitiondatasizewithhalo(char*);
int MESHAM_rtl_getint_dotaccess(char *, char *, int, int);
int MESHAM_rtl_getlocalblock_start(char*, int);
void * MESHAM_rtl_onedimpartition_scatter(char*, void*, int, int);
void * MESHAM_rtl_onedimpartition_gather(char*, void*, int, int);
void * MESHAM_rtl_onedimpartition_transpose(char*, char*);
void MESHAM_rtl_distribution_copylocal_partitiondata(char*, char*);

// RMA support
void MESHAM_rtl_registerOneSidedRMAWindow(int, char *);

// Non blocking support
void MESHAM_rtl_registerNonBlocking(MESHAM_c_request*, char *);

// Buffer support
void MESHAM_rtl_registerBuffer(void *, int, char *);

// Async support
void MESHAM_rtl_synchroniseSpecificAsyncComm(char *);
void MESHAM_rtl_synchroniseAllAsyncComms();

// Exception handling support
jmp_buf * MESHAM_rtl_registerExceptionHandler(char *);
void MESHAM_rtl_deregisterExceptionHandler(char *);
void MESHAM_rtl_handleException(char *);
void MESHAM_rtl_setUpErrorHandlingForProcessGroup(MESHAM_c_processgroup_communicator);

#endif /* MESHAM_H_ */
