#include "mpi.h"
#include "buildmesham.h"
#include <stdlib.h>
#include "system.h"
int mypid=-1;

int MESHgetPID()
{
	if (mypid == -1)
	{
		MPI_Comm_rank(MPI_COMM_WORLD,&mypid);
	}
	return mypid;
}

DLLIMPORT void MESH_Init(int cv,int vr)
{
	/*
		This fn checks the versions are both compatible - cv is the compiler version used to compile the source code with, vr is the runtime library version required by the compiler for the code to execute properly
	*/
	if (vr > LIBRARYVERSION)
	{
		// library needs updating!
		fprintf(stderr,"Error Initalizing Runtime Library - the runtime library you have is too old for this Mesham code, please update the RTL from www.mesham.net\n");
		exit(EXIT_FAILURE);
	}
	
	// dont check cv at the moment as all versions of compiler work this THIS RTL
}

DLLIMPORT void MESHoscli(char * c)
{
	system(c);
}

DLLIMPORT void MESHregistergarbage(void * pt,int protect)
{
	addgarbage(pt,protect);
}

DLLIMPORT void MESHgarbagecollect()
{
	cleargarbage(0);
}

DLLIMPORT void MESHkillgarbage()
{
	cleargarbage(1000);
}
