#include "mpi.h"
#include "buildmesham.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

typedef struct referencelist{char * keyword; void * dataptr;struct referencelist * next;} reflistnode;
typedef struct referencevarmap{char * varname; reflistnode * refhead; struct referencevarmap * next;} refmap; 

refmap * refmaphead=NULL;

refmap * getVariableMapHead(char *);
void setVariableMapHead(char *, reflistnode *);

void MESHremovevariablefromreference(char * varname)
{
	refmap * varhead=getVariableMapHead(varname);
	if (varhead==NULL) return;
	reflistnode * currnode=varhead->refhead;	
	while (currnode !=NULL)
	{		
		free(currnode->keyword);
		reflistnode * oldnode=currnode;
		currnode=currnode->next;
		free(oldnode);
	}
	free(varhead->varname);
	free(varhead);
}

void MESHtransferreferencelist(char * varfrom,char * varto)
{
	refmap * varhead=getVariableMapHead(varfrom);	// get record	
	if (varhead != NULL) 
	{
		varhead->varname=realloc(varhead->varname,sizeof(char) * strlen(varto) + 1);	// resize variable name
		strcpy(varhead->varname,varto);	// set variable name to be new one
	}
}

void * MESHgetreference(char * varname, char * keyword)
{
	refmap * varhead=getVariableMapHead(varname);
	if (varhead==NULL) return NULL;
	reflistnode * currnode=varhead->refhead;	
	while (currnode !=NULL)
	{
		if (strcmp(keyword,currnode->keyword)==0) return currnode->dataptr;
		currnode=currnode->next;
	}
	return NULL;
}


void MESHregisterreference(char * varname,char * keyword,void * dataptr)
{
	// first check if entry already exists
	if (MESHgetreference(varname,keyword)!=NULL)
	{
		// yes - so just modify old entry rather than create new one
		refmap * varhead=getVariableMapHead(varname);
		reflistnode * currnode=varhead->refhead;	
		while (currnode !=NULL)
		{
			if (strcmp(keyword,currnode->keyword)==0) 
			{
				currnode->dataptr=dataptr;
				return;
			}
			currnode=currnode->next;
		}
	}
	// is a new entry
	reflistnode * newnode=malloc(sizeof(reflistnode));
	char * toaddkwd=malloc(sizeof(char) * strlen(keyword) + 1);
	strcpy(toaddkwd,keyword);
	newnode->keyword=toaddkwd;
	newnode->dataptr=dataptr;

	refmap * varhead=getVariableMapHead(varname);
	if (varhead != NULL)
		newnode->next=varhead->refhead;
 	else 
		newnode->next=NULL;
	setVariableMapHead(varname,newnode);	
}

void setVariableMapHead(char * varname, reflistnode * refnode)
{
	refmap * varhead=getVariableMapHead(varname);
	if (varhead==NULL)
	{
		refmap * newmap=malloc(sizeof(refmap));
		char * toaddvar=malloc(sizeof(char) * strlen(varname) + 1);
		strcpy(toaddvar,varname);
		newmap->varname=toaddvar;
		newmap->refhead=refnode;
		newmap->next=refmaphead;
		refmaphead=newmap;		
	} else {
		varhead->refhead=refnode;
	}
}

refmap * getVariableMapHead(char * varname)
{
	refmap * curr=refmaphead;
	while (curr != NULL)
	{
		if (strcmp(curr->varname,varname)==0) return curr;
		curr=curr->next;
	}
	return NULL;
}
