#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <mesham.h>
#include "mpi.h"
typedef struct {char * member;void * addr;int tableaddr;} nodeentry;

typedef struct tabnode{int size; void * absoluteaddress;nodeentry * pointers;} tablerow;
typedef struct {char member[20];int tableaddr;} absnodeentry;
typedef struct {int size;absnodeentry * info;} abstablerow;

typedef struct {nodeentry * nodeentries;void * rootdata; int numnodeentries;int toptableitem;tablerow * table[500];} tables;
tables * getthetable(void *);
int gettablevalue(void *,void *);
int tottables=0;
tables * tablelist[200];

int MESHrefrecordneedtolinkfurther(int rownum,char * member,void * base)
{
	int toptableitem=getthetable(base)->toptableitem;
	int numnodeentries=getthetable(base)->numnodeentries;
	int i;
	void * pointervalue=NULL;
	for (i=0;i<numnodeentries;i++)
	{				
		if (strcmp(getthetable(base)->table[rownum]->pointers[i].member,member)==0)
		{
			if (getthetable(base)->table[rownum]->pointers[i].addr == NULL) return 0;
			pointervalue=getthetable(base)->table[rownum]->pointers[i].addr;
			break;
		}
	}
	for (i=0;i<=toptableitem;i++)
	{
		if (getthetable(base)->table[i]->absoluteaddress==pointervalue) return 1;
	}
	return 0;
}


void MESHrefrecordremoverow(void * data,void * base)
{
	getthetable(base)->table[MESHrefrecordgetrownumber(data,base)]->absoluteaddress=NULL;
}	

void * MESHrefrecordgetrowentry(int rownum,char * member,void * base)
{
	int toptableitem=getthetable(base)->toptableitem;
	int numnodeentries=getthetable(base)->numnodeentries;
	int i;
	for (i=0;i<numnodeentries;i++)
	{				
		if (strcmp(getthetable(base)->table[rownum]->pointers[i].member,member)==0)
		{					
			return getthetable(base)->table[rownum]->pointers[i].addr;
		}
	}
}

int MESHrefrecordneedtoanalysefurther(int rownum,char * member,void * base)
{
	int toptableitem=getthetable(base)->toptableitem;
	int numnodeentries=getthetable(base)->numnodeentries;
	int i;
	void * pointervalue=NULL;
	for (i=0;i<numnodeentries;i++)
	{				
		if (strcmp(getthetable(base)->table[rownum]->pointers[i].member,member)==0)
		{
			if (getthetable(base)->table[rownum]->pointers[i].addr == NULL) return 0;
			pointervalue=getthetable(base)->table[rownum]->pointers[i].addr;
			break;
		}
	}
	for (i=0;i<=toptableitem;i++)
	{
		if (getthetable(base)->table[i]->absoluteaddress==pointervalue) return 0;
	}
	return 1;
}

int MESHrefrecordgetrownumber(void * absaddr,void * base)
{
	int toptableitem=getthetable(base)->toptableitem;
	int numnodeentries=getthetable(base)->numnodeentries;
	int i;
	for (i=0;i<=toptableitem;i++)
	{
		if (getthetable(base)->table[i]->absoluteaddress==absaddr) return i;
	}
	return -1;
}

void MESHrefrecordaddrowentry(int rownum,char * member,void * ptr,void * base)
{
	int toptableitem=getthetable(base)->toptableitem;
	int numnodeentries=getthetable(base)->numnodeentries;
	int i;
	for (i=0;i<numnodeentries;i++)
	{				
		if (strcmp(getthetable(base)->table[rownum]->pointers[i].member,member)==0)
		{					
			getthetable(base)->table[rownum]->pointers[i].addr=ptr;
		}
	}
}

void MESHrefrecordtableaddrow(void * absaddr,int size,void * base)
{
	getthetable(base)->toptableitem ++;
	int toptableitem=getthetable(base)->toptableitem;
	int numnodeentries=getthetable(base)->numnodeentries;	
	tablerow * newrow=malloc(sizeof(tablerow));
	newrow->pointers=malloc(sizeof(nodeentry) * numnodeentries);
	memcpy(newrow->pointers,getthetable(base)->nodeentries,sizeof(nodeentry) * numnodeentries);
	newrow->absoluteaddress=absaddr;
	newrow->size=size;	
	getthetable(base)->table[toptableitem]=newrow;
	
}

void MESHrefrecorddisplay(void * base)
{
int toptableitem=getthetable(base)->toptableitem;
	int numnodeentries=getthetable(base)->numnodeentries;
	int i;
	for (i=0;i<=toptableitem;i++)
	{
		printf("Entry(%d) - %p (size %d b)",i,getthetable(base)->table[i]->absoluteaddress,getthetable(base)->table[i]->size);
		int j;
		for (j=0;j<numnodeentries;j++)
		{
			printf(" , %s = %p or %d",getthetable(base)->table[i]->pointers[j].member,getthetable(base)->table[i]->pointers[j].addr,getthetable(base)->table[i]->pointers[j].tableaddr);
		}	
		printf("\n");
	}
}

tables * getthetable(void * base)
{
	int i;
	for (i=0;i<tottables;i++)
	{
		if (tablelist[i] != NULL) if (tablelist[i]->rootdata==base) return tablelist[i];
	}
}

void displayabstable(void * data)
{
	abstablerow * abstable=(abstablerow *) data;
	int rows=((int *) abstable)[0];
	int cols=((int *) abstable)[1];
	int i;
	for (i=0;i<rows;i++)
	{
		int thesize=(int) ((char *) abstable)[i * (sizeof(abstablerow) + (sizeof(absnodeentry) * cols)) + (sizeof(int) * 2)];
		printf("Entry %d of size %d",i,thesize);
		int j;
		absnodeentry * entries=(absnodeentry *) &((char *) abstable)[i * (sizeof(abstablerow) + (sizeof(absnodeentry) * cols)) + sizeof(int) + (sizeof(int) * 2)];
		for (j=0;j<cols;j++)
		{			
			printf(",%s = %d",entries[j].member,entries[j].tableaddr);
		}
		printf("\n");
	}
}


void MESHrefrecordconstructtablefromabstable(void * dstartpoint,void * dtable)
{
	abstablerow * abstable=(abstablerow *) dtable;
	int toptableitem=((int *) abstable)[0] - 1;	
	int numnodeentries=getthetable(dstartpoint)->numnodeentries=((int *) abstable)[1];
		//printf("%d\n",toptableitem);
	int i;
	int totsizesofar=0;
	for (i=0;i<=toptableitem;i++)
	{
		int thesize=(int) ((char *) abstable)[i * (sizeof(abstablerow) + (sizeof(absnodeentry) * numnodeentries)) + (sizeof(int) * 2)];
		MESHrefrecordtableaddrow(dstartpoint + totsizesofar,thesize,dstartpoint);
		totsizesofar += thesize;
	}
	
	for (i=0;i<=toptableitem;i++)
	{
		int j;
		absnodeentry * entries=(absnodeentry *) &((char *) abstable)[i * (sizeof(abstablerow) + (sizeof(absnodeentry) * numnodeentries)) + sizeof(int) + (sizeof(int) * 2)];
		for (j=0;j<numnodeentries;j++)
		{			
			if (entries[j].tableaddr >= 0)
			{ 			 
				MESHrefrecordaddrowentry(i,entries[j].member,getthetable(dstartpoint)->table[entries[j].tableaddr]->absoluteaddress,dstartpoint);
			} else {
				MESHrefrecordaddrowentry(i,entries[j].member,NULL,dstartpoint);
			}
		}		
	}
}


void MESHrefrecorddisposetable(void * base)
{
	tables * record=getthetable(base);
	free(record->nodeentries);
	int i;
	for (i=0;i<=record->toptableitem;i++)
	{
		free (record->table[i]->pointers);		
	}
	free(record);
	for (i=0;i<tottables;i++)
	{
		if (tablelist[i] != NULL) if (tablelist[i]->rootdata==base) 
		{
			free (record->table[i]);
			tablelist[i]=NULL;
			break;
		}
	}
}


int MESHrefrecordgettotmemsize(void * base)
{
	int toptableitem=getthetable(base)->toptableitem;
	int numnodeentries=getthetable(base)->numnodeentries;
	int size=0;
	int i;
	for (i=0;i<=toptableitem;i++)
		size +=getthetable(base)->table[i]->size;
	return size;
}

int MESHrefrecordgetabstablesize(void * base)
{
	int toptableitem=getthetable(base)->toptableitem;
	int numnodeentries=getthetable(base)->numnodeentries;
	return (sizeof(abstablerow) + (sizeof(absnodeentry) * numnodeentries)) * (toptableitem + 1) + sizeof(int)+sizeof(int);
}

void * MESHrefrecordgetabstracttable(void * base)
{
	int toptableitem=getthetable(base)->toptableitem;
	int numnodeentries=getthetable(base)->numnodeentries;
	abstablerow * abstable=malloc((sizeof(abstablerow) + (sizeof(absnodeentry) * numnodeentries)) * (toptableitem + 1) + sizeof(int)+sizeof(int));
	(((int *) abstable)[0]) = toptableitem + 1;
	(((int *) abstable)[1]) = numnodeentries;
	int i;
	for (i=0;i<=toptableitem;i++)
	{
		abstablerow * newr=malloc(sizeof(abstablerow));
		newr->size=getthetable(base)->table[i]->size;
		
		absnodeentry entr[numnodeentries];
		int j;
		for (j=0;j<numnodeentries;j++)
		{
			entr[j].tableaddr=getthetable(base)->table[i]->pointers[j].tableaddr;
			strcpy(entr[j].member,getthetable(base)->table[i]->pointers[j].member);
		}
		memcpy(& ((char *) abstable)[i * (sizeof(abstablerow) + (sizeof(absnodeentry) * numnodeentries)) + (sizeof(int) * 2)],newr,sizeof(abstablerow));
		memcpy( &((char *) abstable)[i * (sizeof(abstablerow) + (sizeof(absnodeentry) * numnodeentries)) + sizeof(int) + (sizeof(int) * 2)],entr,(sizeof(absnodeentry) * numnodeentries));
	}
	return abstable;
}

void * MESHrefrecordallignmemory(void * base)
{
	int toptableitem=getthetable(base)->toptableitem;
	int numnodeentries=getthetable(base)->numnodeentries;
	char * data=malloc(MESHrefrecordgettotmemsize(base));
	int ptr=0;
	int i;
	for (i=0;i<=toptableitem;i++)
	{
		memcpy(&data[ptr],(char *) getthetable(base)->table[i]->absoluteaddress,getthetable(base)->table[i]->size);
		ptr +=getthetable(base)->table[i]->size ;
	}
	return data;
}

int gettablevalue(void * addr,void * base)
{
	int toptableitem=getthetable(base)->toptableitem;
	int numnodeentries=getthetable(base)->numnodeentries;
	int i;
	for (i=0;i<=toptableitem;i++)
		if (getthetable(base)->table[i]->absoluteaddress==addr) return i;
	return -1;
}

void MESHrefrecordlinkrelativeaddresses(void * base)
{
	int toptableitem=getthetable(base)->toptableitem;
	int numnodeentries=getthetable(base)->numnodeentries;
	int i;
	for (i=0;i<=toptableitem;i++)
	{
		int j;
		for (j=0;j<numnodeentries;j++)
		{
			getthetable(base)->table[i]->pointers[j].tableaddr=gettablevalue(getthetable(base)->table[i]->pointers[j].addr,base);
		}
	}
}


void MESHrefrecordcreate(int entries,char * members,void * d)
{
	tables * newtable=malloc(sizeof(tables));
	newtable->numnodeentries=entries;
	newtable->rootdata=d;
	newtable->toptableitem=-1;
	newtable->nodeentries=malloc(sizeof(nodeentry) * entries);		
	int i;
	int strc=0;
	for (i=0;i<entries;i++)
	{		
		newtable->nodeentries[i].addr=NULL;
		newtable->nodeentries[i].tableaddr=-1;
		newtable->nodeentries[i].member=malloc(sizeof(char) * strlen(&members[strc]) + 2);
		strcpy(newtable->nodeentries[i].member,&members[strc]);
	//	printf("ADDED %s to %d\n",nodeentries[i].member,i);
		strc += strlen(&members[strc]) + 1;
	}
	tablelist[tottables]=newtable;
	tottables++;
}
