#include <stdlib.h>
#include "mpi.h"
#include <mesham.h>
#include <stddef.h>
int reladdr;
int sortascending(const void *a,const void *b);
int sortdescending(const void *a,const void *b);
int getrecordlength(void *,size_t);
void addtoarray(void *,void **, size_t);
int countnodes(void *,int);
void addtoarray(void * data,void * sorteddata[],size_t relativeaddressoflinker)	// sets up referenced array to reference nodes
{
	int i=0;	
	void *cptr=data;
	while (1)
	{
		sorteddata[i]=cptr;
	//	if (*(long long *) ((char *) ((sorteddata[i])) + reladdr) < 0) printf("%d OE\n",i);
		if (*(void **)((char *)cptr + relativeaddressoflinker) ==NULL) break;
		cptr=*(void **)((char *)cptr + relativeaddressoflinker);		
		i++;
	}	
} 

int countnodes(void * data,int relativeaddressoflinker)
{
	int i=0;
	void * cptr=data;	
	while (1)
	{
		if (*(void **)((char *)cptr + relativeaddressoflinker) ==NULL) break;		
		cptr=*(void **)((char *)cptr + relativeaddressoflinker);
		i++;
	}
	return i;
}

int getrecordlength(void * data,size_t relativeaddressoflinker)	// gets number of nodes
{
	int i=0;
	void * cptr=data;	
	while (1)
	{
		if (*(void **)((char *)cptr + relativeaddressoflinker) ==NULL) break;		
		cptr=*(void **)((char *)cptr + relativeaddressoflinker);
		i++;
	}
	return i;
} 

void relinkdata(void ** data,void * sorteddata[], size_t relativeaddressoflinker,int rlength)	// will relink the records after quicksorted the array
{
	int i;
//	long long oldval;
	for (i=0;i<rlength;i++)
	{
		if (i < rlength - 1)
		{
			*(void **)((char *) sorteddata[i] + relativeaddressoflinker) = sorteddata[i + 1] ; 		
		} else {
			*(void **)((char *) sorteddata[i] + relativeaddressoflinker) = NULL;
		}
/*		
		if (i > 0 )
		{
			if (*(long long *) ((char *) (((void *) sorteddata[i])) + reladdr) < oldval)
			{
				printf("SORT ERROR\n");
			}
		}
		oldval=*(long long *) ((char *) (((void *) sorteddata[i])) + reladdr);
*/	
	}
	*data=sorteddata[0];
}

void MESHreferencerecordquicksortascending(void ** data,size_t relativeaddressofcomparisonptr,size_t relativeaddressoflinker,size_t recordsize)
{
	reladdr=relativeaddressofcomparisonptr;
	int rlength=getrecordlength(*data,relativeaddressoflinker);
	//printf("THERE ARE %d nodes\n",rlength);
	void * sorteddata[rlength + 1];
	//printf("A %d\n",countnodes(data,relativeaddressoflinker));
	addtoarray(*data,sorteddata,relativeaddressoflinker);
//	printf("B %d\n",countnodes(data,relativeaddressoflinker));
	qsort(sorteddata,rlength + 1,recordsize,sortascending);
//	printf("C %d\n",countnodes(data,relativeaddressoflinker));
	relinkdata(data,sorteddata,relativeaddressoflinker,rlength + 1);
//	printf("D %d\n",countnodes(data,relativeaddressoflinker));
}

void MESHreferencerecordquicksortdescending(void * data,size_t relativeaddressofcomparisonptr,size_t relativeaddressoflinker,size_t recordsize)
{
	reladdr=relativeaddressofcomparisonptr;
	int rlength=getrecordlength(data,relativeaddressoflinker);
	//printf("THERE ARE %d nodes\n",rlength);
	void * sorteddata[rlength + 1];
	addtoarray(data,sorteddata,relativeaddressoflinker);
	qsort(sorteddata,rlength + 1,recordsize,sortdescending);
	relinkdata(data,sorteddata,relativeaddressoflinker,rlength + 1);
}


int sortascending(const void *a,const void *b)
{	
	long long keyofa=*(long long *) ((char *) (*((void **) a)) + reladdr);
	long long keyofb=*(long long *) ((char *) (*((void **) b)) + reladdr);	
//	if (keyofa < 0 || keyofb <0) printf("ERROR\n");
	if (keyofa < keyofb) return -1;
	if (keyofa > keyofb) return 1;
	return 0;
}

int sortdescending(const void *a,const void *b)
{	
	long long keyofa=*(long long *) ((char *) (*((void **) a)) + reladdr);
	long long keyofb=*(long long *) ((char *) (*((void **) b)) + reladdr);	
	if (keyofa < keyofb) return 1;
	if (keyofa > keyofb) return -1;
	return 0;
}
