#include "mpi.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "SpaceShape.h"
#include <mesham.h>

MESHShapeSpaceHandle addshape(char *,int, double *);

MESHShapeSpaceHandle shapespacehandle=0;

ObjectItem * getObjectItem(ShapeSpace *, double *);
ShapeSpace* shapehead=NULL;

MESHShapeSpaceHandle  MESHregisterShapeSpace(char * varname,int dimensions,double * dimsdetails)
{
	addshape(varname,dimensions,dimsdetails);
}

MESHShapeSpaceHandle addshape(char * varname,int dims, double * dimsdetails)
{
	ShapeSpace * newcrv=malloc(sizeof(ShapeSpace));
	newcrv->variablename=malloc(sizeof(char) * strlen(varname) + 2);
	strcpy(newcrv->variablename,varname);	
	newcrv->dimensions=dims;
	newcrv->currenttotal=0;
	newcrv->myshapespacehandle=shapespacehandle;
	shapespacehandle++;
	newcrv->dimcentre=malloc(sizeof(double) * dims);
	newcrv->mind=malloc(sizeof(double) * dims);
	newcrv->maxd=malloc(sizeof(double) * dims);
	newcrv->masterupdatecode=0;
	newcrv->dimcorner=malloc(sizeof(double) * dims);
	double maxlen=0;
	int i;
	for (i=0;i<dims;i++)
	{
		newcrv->mind[i]=dimsdetails[i * 2];
		newcrv->maxd[i]=dimsdetails[i * 2 + 1];
		newcrv->dimcentre[i]= 0.5 * (dimsdetails[i * 2] + dimsdetails[i * 2 + 1]);
		maxlen = (dimsdetails[i * 2 + 1] - dimsdetails[i * 2] > maxlen) ? dimsdetails[i * 2 + 1] - dimsdetails[i * 2] : maxlen; 
	}
	maxlen *= 1.001;
	for (i=0;i<dims;i++)
	{
		newcrv->dimcorner[i]=newcrv->dimcentre[i] - 0.5 * maxlen;
	}
	newcrv->contents=NULL;
	newcrv->len=maxlen;	
	newcrv->next=shapehead;	
	newcrv->prev=NULL;
	if (shapehead!=NULL)
	{
		shapehead->prev=newcrv;
	}
	shapehead=newcrv;	
	return newcrv->myshapespacehandle;
}

char * getShapeVarname(MESHShapeSpaceHandle shandle)
{
	ShapeSpace * ch=shapehead;
	//printf("%p\n",ch->next);
	while (ch != NULL)
	{		
		if (ch->myshapespacehandle == shandle) return ch->variablename;		
		ch=ch -> next;		
	}	
	return NULL;
}

void * MESHgetdatafromShapeSpace(MESHShapeSpaceHandle shandle, double * coords)
{
	char * varname=getShapeVarname(shandle);
	ShapeSpace * ch=getSpaceShapenode(varname);
	ObjectItem * dataitem=getObjectItem(ch,coords);
	if (dataitem==NULL)
	{
		return NULL;
	} else {
		return dataitem->data;
	}
}

ObjectItem * getObjectItem(ShapeSpace * a, double * coords)
{
	ObjectItem * newh=a->contents;
	while (newh != NULL)
	{
		int i;
		int issame=1;
		for (i=0;i<a->dimensions;i++)
			if (coords[i]!=newh->coords[i]){issame=0;break;}
		if (issame) return newh;
		newh=newh->next;
	}
	return NULL;
}

void MESHaddtoShapeSpace(MESHShapeSpaceHandle shandle,void * data ,double * coords)
{
	char * varname=getShapeVarname(shandle);
	ShapeSpace * ch=getSpaceShapenode(varname);
	ObjectItem * newitem=malloc(sizeof(ObjectItem));
	newitem->data=data;
	ch->masterupdatecode++;
	newitem->coords=malloc(sizeof(double) * ch->dimensions);
	newitem->lastupdated=ch->masterupdatecode;
	newitem->orderadded=ch->currenttotal;
	ch->currenttotal++;
	int i;
	for (i=0;i < ch->dimensions;i++)
	{
		newitem->coords[i]=coords[i];
	}
	newitem->next=ch->contents;
	newitem->prev=NULL;
	if (ch->contents != NULL)
	{
		ch->contents->prev=newitem;
	}
	ch->contents=newitem;
}

void MESHfreeShapeSpace(MESHShapeSpaceHandle shandle)
{
	char * varname=getShapeVarname(shandle);
	ShapeSpace * ch=getSpaceShapenode(varname);
	if (ch==NULL) return;
	if ((ch->prev) != NULL)
	{
		(ch->prev)->next=ch->next;		
	} else {		
		shapehead=ch->next;
	}
	if (ch->next !=NULL) {(ch->next)->prev=ch->prev;}
	if (ch->variablename != NULL) {free(ch->variablename);}	
	if (ch->dimcentre != NULL) {free(ch->dimcentre);}
	if (ch->dimcorner != NULL) {free(ch->dimcorner);}		
	free(ch);
}

ShapeSpace * getSpaceShapenode(char * varname)
{
	ShapeSpace * ch=shapehead;
	//printf("%p\n",ch->next);
	while (ch != NULL)
	{		
		if (strcmp(ch->variablename,varname) == 0) return ch;		
		ch=ch -> next;		
	}	
	return NULL;
}
