#include <stdio.h>
#include <stdlib.h>
#include "mpi.h"
#include <mesham.h>
#include <meshamgadget.h>
#include <hdf5.h>
#include "snapshotbase.h"
#include "snapshotHDF.h"

void MESHGADregistersnapshotfmtHDF5(char * filename, char * variablename, int rootp)
{
	MPI_Comm_rank(MPI_COMM_WORLD,&myprocessid);
	MPI_Comm_size(MPI_COMM_WORLD,&totalprocesses);
	// int num_files=find_files(filename); /*depreciated for now */
	addsnapshotfile(filename,variablename,3,rootp);		
}

void readHDFheader(char * fname,snapshotheader * header)
{
	 hid_t hdf5_file, hdf5_headergrp, hdf5_attribute;

  	hdf5_file = H5Fopen(fname, H5F_ACC_RDONLY, H5P_DEFAULT);
  	hdf5_headergrp = H5Gopen(hdf5_file, "/Header");

  	hdf5_attribute = H5Aopen_name(hdf5_headergrp, "NumPart_ThisFile");
  	H5Aread(hdf5_attribute, H5T_NATIVE_INT, header->npart);
  	H5Aclose(hdf5_attribute);

  	hdf5_attribute = H5Aopen_name(hdf5_headergrp, "NumPart_Total");
  	H5Aread(hdf5_attribute, H5T_NATIVE_UINT, header->npartTotal);
  	H5Aclose(hdf5_attribute);

  	hdf5_attribute = H5Aopen_name(hdf5_headergrp, "NumPart_Total_HW");	// disparity between HW and HighWords
  	H5Aread(hdf5_attribute, H5T_NATIVE_UINT, header->npartTotalHighWord);
  	H5Aclose(hdf5_attribute);

  	hdf5_attribute = H5Aopen_name(hdf5_headergrp, "MassTable");
  	H5Aread(hdf5_attribute, H5T_NATIVE_DOUBLE, header->mass);
  	H5Aclose(hdf5_attribute);

  	hdf5_attribute = H5Aopen_name(hdf5_headergrp, "Time");
  	H5Aread(hdf5_attribute, H5T_NATIVE_DOUBLE, &header->time);
  	H5Aclose(hdf5_attribute);

  	hdf5_attribute = H5Aopen_name(hdf5_headergrp, "NumFilesPerSnapshot");
  	H5Aread(hdf5_attribute, H5T_NATIVE_INT, &header->num_files);
  	H5Aclose(hdf5_attribute);

  	hdf5_attribute = H5Aopen_name(hdf5_headergrp, "Flag_Entropy_ICs");
  	H5Aread(hdf5_attribute, H5T_NATIVE_INT, &header->flag_entropy_instead_u);
  	H5Aclose(hdf5_attribute);

  	H5Gclose(hdf5_headergrp);
  	H5Fclose(hdf5_file);
}
void writeHDFheader(hid_t handle,snapshotheader * header)
{
	hsize_t adim[1]={6};
	hid_t hdf5_dataspace, hdf5_attribute;
	
	 hdf5_dataspace = H5Screate(H5S_SIMPLE);
  	H5Sset_extent_simple(hdf5_dataspace, 1, adim, NULL);
  	hdf5_attribute = H5Acreate(handle, "NumPart_ThisFile", H5T_NATIVE_INT, hdf5_dataspace, H5P_DEFAULT);
  	H5Awrite(hdf5_attribute, H5T_NATIVE_UINT, header->npart);
  	H5Aclose(hdf5_attribute);
  	H5Sclose(hdf5_dataspace);

  	hdf5_dataspace = H5Screate(H5S_SIMPLE);
  	H5Sset_extent_simple(hdf5_dataspace, 1, adim, NULL);
  	hdf5_attribute = H5Acreate(handle, "NumPart_Total", H5T_NATIVE_UINT, hdf5_dataspace, H5P_DEFAULT);
  	H5Awrite(hdf5_attribute, H5T_NATIVE_UINT, header->npartTotal);
  	H5Aclose(hdf5_attribute);
  	H5Sclose(hdf5_dataspace);

  	hdf5_dataspace = H5Screate(H5S_SIMPLE);
  	H5Sset_extent_simple(hdf5_dataspace, 1, adim, NULL);
  	hdf5_attribute = H5Acreate(handle, "NumPart_Total_HW", H5T_NATIVE_UINT, hdf5_dataspace, H5P_DEFAULT);
  	H5Awrite(hdf5_attribute, H5T_NATIVE_UINT, header->npartTotalHighWord);
  	H5Aclose(hdf5_attribute);
  	H5Sclose(hdf5_dataspace);


  	hdf5_dataspace = H5Screate(H5S_SIMPLE);
  	H5Sset_extent_simple(hdf5_dataspace, 1, adim, NULL);
  	hdf5_attribute = H5Acreate(handle, "MassTable", H5T_NATIVE_DOUBLE, hdf5_dataspace, H5P_DEFAULT);
  	H5Awrite(hdf5_attribute, H5T_NATIVE_DOUBLE, header->mass);
  	H5Aclose(hdf5_attribute);
  	H5Sclose(hdf5_dataspace);

  	hdf5_dataspace = H5Screate(H5S_SCALAR);
  	hdf5_attribute = H5Acreate(handle, "Time", H5T_NATIVE_DOUBLE, hdf5_dataspace, H5P_DEFAULT);
  	H5Awrite(hdf5_attribute, H5T_NATIVE_DOUBLE, &header->time);
  	H5Aclose(hdf5_attribute);
  	H5Sclose(hdf5_dataspace);

  	hdf5_dataspace = H5Screate(H5S_SCALAR);
  	hdf5_attribute = H5Acreate(handle, "Redshift", H5T_NATIVE_DOUBLE, hdf5_dataspace, H5P_DEFAULT);
  	H5Awrite(hdf5_attribute, H5T_NATIVE_DOUBLE, &header->redshift);
  	H5Aclose(hdf5_attribute);
  	H5Sclose(hdf5_dataspace);

  	hdf5_dataspace = H5Screate(H5S_SCALAR);
  	hdf5_attribute = H5Acreate(handle, "BoxSize", H5T_NATIVE_DOUBLE, hdf5_dataspace, H5P_DEFAULT);
  	H5Awrite(hdf5_attribute, H5T_NATIVE_DOUBLE, &header->BoxSize);
  	H5Aclose(hdf5_attribute);
  	H5Sclose(hdf5_dataspace);

  	hdf5_dataspace = H5Screate(H5S_SCALAR);
  	hdf5_attribute = H5Acreate(handle, "NumFilesPerSnapshot", H5T_NATIVE_INT, hdf5_dataspace, H5P_DEFAULT);
  	H5Awrite(hdf5_attribute, H5T_NATIVE_INT, &header->num_files);
  	H5Aclose(hdf5_attribute);
  	H5Sclose(hdf5_dataspace);

  	hdf5_dataspace = H5Screate(H5S_SCALAR);
  	hdf5_attribute = H5Acreate(handle, "Omega0", H5T_NATIVE_DOUBLE, hdf5_dataspace, H5P_DEFAULT);
  	H5Awrite(hdf5_attribute, H5T_NATIVE_DOUBLE, &header->Omega0);
  	H5Aclose(hdf5_attribute);
  	H5Sclose(hdf5_dataspace);

  	hdf5_dataspace = H5Screate(H5S_SCALAR);
  	hdf5_attribute = H5Acreate(handle, "OmegaLambda", H5T_NATIVE_DOUBLE, hdf5_dataspace, H5P_DEFAULT);
  	H5Awrite(hdf5_attribute, H5T_NATIVE_DOUBLE, &header->OmegaLambda);
  	H5Aclose(hdf5_attribute);
  	H5Sclose(hdf5_dataspace);

  	hdf5_dataspace = H5Screate(H5S_SCALAR);
  	hdf5_attribute = H5Acreate(handle, "HubbleParam", H5T_NATIVE_DOUBLE, hdf5_dataspace, H5P_DEFAULT);
  	H5Awrite(hdf5_attribute, H5T_NATIVE_DOUBLE, &header->HubbleParam);
  	H5Aclose(hdf5_attribute);
  	H5Sclose(hdf5_dataspace);

  	hdf5_dataspace = H5Screate(H5S_SCALAR);
  	hdf5_attribute = H5Acreate(handle, "Flag_Sfr", H5T_NATIVE_INT, hdf5_dataspace, H5P_DEFAULT);
  	H5Awrite(hdf5_attribute, H5T_NATIVE_INT, &header->flag_sfr);
  	H5Aclose(hdf5_attribute);
  	H5Sclose(hdf5_dataspace);

  	hdf5_dataspace = H5Screate(H5S_SCALAR);
  	hdf5_attribute = H5Acreate(handle, "Flag_Cooling", H5T_NATIVE_INT, hdf5_dataspace, H5P_DEFAULT);
  	H5Awrite(hdf5_attribute, H5T_NATIVE_INT, &header->flag_cooling);
  	H5Aclose(hdf5_attribute);
  	H5Sclose(hdf5_dataspace);

  	hdf5_dataspace = H5Screate(H5S_SCALAR);
  	hdf5_attribute = H5Acreate(handle, "Flag_StellarAge", H5T_NATIVE_INT, hdf5_dataspace, H5P_DEFAULT);
  	H5Awrite(hdf5_attribute, H5T_NATIVE_INT, &header->flag_stellarage);
  	H5Aclose(hdf5_attribute);
  	H5Sclose(hdf5_dataspace);

  	hdf5_dataspace = H5Screate(H5S_SCALAR);
  	hdf5_attribute = H5Acreate(handle, "Flag_Metals", H5T_NATIVE_INT, hdf5_dataspace, H5P_DEFAULT);
  	H5Awrite(hdf5_attribute, H5T_NATIVE_INT, &header->flag_metals);
  	H5Aclose(hdf5_attribute);
  	H5Sclose(hdf5_dataspace);

  	hdf5_dataspace = H5Screate(H5S_SCALAR);
  	hdf5_attribute = H5Acreate(handle, "Flag_Feedback", H5T_NATIVE_INT, hdf5_dataspace, H5P_DEFAULT);
  	H5Awrite(hdf5_attribute, H5T_NATIVE_INT, &header->flag_feedback);
  	H5Aclose(hdf5_attribute);
  	H5Sclose(hdf5_dataspace);

  	header->flag_entropy_instead_u = 0;

  	hdf5_dataspace = H5Screate(H5S_SIMPLE);
  	H5Sset_extent_simple(hdf5_dataspace, 1, adim, NULL);
  	hdf5_attribute = H5Acreate(handle, "Flag_Entropy_ICs", H5T_NATIVE_UINT, hdf5_dataspace, H5P_DEFAULT);
  	H5Awrite(hdf5_attribute, H5T_NATIVE_UINT, &header->flag_entropy_instead_u);
  	H5Aclose(hdf5_attribute);
  	H5Sclose(hdf5_dataspace);
}

void MESHGADsnapfmtHDF5saveparticles(MESHGADparticle * particledump,char * varname,int particlenumber)
{
	hid_t hdf5_file=0, hdf5_grp[6], hdf5_headergrp=0, hdf5_dataspace_memory;
	hid_t hdf5_datatype=0, hdf5_dataspace_in_file=0, hdf5_dataset=0;
	herr_t hdf5_status;
	hsize_t dims[2], count[2],start[2];
	int rank=2;
	int type;
	int processbytype[]={0,0,0,0,0,0};
	int q;
	snapshotfile * mysnapfile=getsnapshotnode(varname);	
	if (mysnapfile->header==NULL) {MAKEHEADER}
	for (q=0;q<particlenumber;q++)
		processbytype[particledump[q].Type]++;	
	int processparts[totalprocesses - 1][6];
	if (myprocessid==mysnapfile->rootprocess)
	{
		memcpy(processparts[0],processbytype,sizeof(int) * 6);
		int ij;
		for (ij=1;ij<totalprocesses;ij++)
		{
			MPI_Status stat;
			MPI_Recv(processparts[ij],6,MPI_INT,ij,3,MPI_COMM_WORLD,&stat);
		}
	} else {
		MPI_Send(processbytype,6,MPI_INT,mysnapfile->rootprocess,3,MPI_COMM_WORLD);
	}
	
	char * CommBuffer=malloc(sizeof(char) * 1024 * 1024 * 20);	// 20 MB buffer
	FILE * fd;
	if (myprocessid==mysnapfile->rootprocess)
	{
		hdf5_file=H5Fcreate(mysnapfile->filename,H5F_ACC_TRUNC,H5P_DEFAULT,H5P_DEFAULT);
		hdf5_headergrp=H5Gcreate(hdf5_file,"/Header",0);
		for (type=0;type < 6;type++)
		{
			if (mysnapfile->header->npart[type] > 0)
			{
				char buffer[200];
				sprintf(buffer,"/PartType%d",type);
				hdf5_grp[type]  = H5Gcreate(hdf5_file,buffer,0);
			}
		}
		writeHDFheader(hdf5_headergrp,mysnapfile->header);			
	}
	int typelist[]={0,0,0,0,0,0};
	int blocknumber;
	for (blocknumber=0;blocknumber < 5;blocknumber++)
	{		
		int elsize=getblockselementsize(blocknumber);
		int totalparticlesinblock=getparticlesinthisblock(blocknumber,mysnapfile,typelist);
		//printf("%d\n",totalparticlesinblock);
	//	if (myprocessid==0) writeblocksize(fd,elsize * totalparticlesinblock);
		if (totalparticlesinblock > 0)
		{								
			for (type=0;type < 6;type++)
			{
				if (typelist[type])
				{
					if (myprocessid==mysnapfile->rootprocess && mysnapfile->header->npart[type] > 0)
					{
						if (blocknumber==BLOCKID)
						{
							hdf5_datatype=H5Tcopy(H5T_NATIVE_UINT);
						} else {
							hdf5_datatype=H5Tcopy(H5T_NATIVE_FLOAT);
						}
						int valuesperel=1;
						if (blocknumber==BLOCKPOS || blocknumber==BLOCKVEL) valuesperel=3;
						dims[0]=mysnapfile->header->npart[type] ;
						dims[1]=valuesperel;						
						if (dims[1] == 1) rank=1;
						char buffer[200];
						getdatasetname(blocknumber,buffer);
						hdf5_dataspace_in_file=H5Screate_simple(rank,dims,NULL);
						hdf5_dataset=H5Dcreate(hdf5_grp[type],buffer,hdf5_datatype,hdf5_dataspace_in_file,H5P_DEFAULT);
					}
					int pid;
					int memstart=0;
					int theoffset=0;	// only used when buffersize < particle size and need to do this in multiple passes (NOT YET IMPLEMENTED)
					for (pid=0;pid<totalprocesses;pid++)
					{					
						int numberofparticles=processbytype[type]; //computeparticlesforme(0,mysnapfile->header->npart[type]);						
						if (pid==myprocessid && numberofparticles > 0)
						{						
							fillupbufferfrommemory(CommBuffer,blocknumber,theoffset,particlenumber,type,particledump);
							theoffset=theoffset + numberofparticles ;
							if (myprocessid != mysnapfile->rootprocess)
							{								
								MPI_Send(CommBuffer,elsize * numberofparticles,MPI_BYTE,mysnapfile->rootprocess,2,MPI_COMM_WORLD);
							}
						}																		
						if (myprocessid==mysnapfile->rootprocess && processparts[pid][type] > 0)
						{
							if (pid != mysnapfile->rootprocess)
							{
								MPI_Status stat;
								MPI_Recv(CommBuffer,elsize * processparts[pid][type],MPI_BYTE,pid,2,MPI_COMM_WORLD,&stat);								
							}							
							start[0]=memstart;
							start[1]=0;
							count[0]= numberofparticles;
							count[1]=1;
							memstart+=numberofparticles;
							if (blocknumber==BLOCKPOS || blocknumber==BLOCKVEL) count[1]=3;
							H5Sselect_hyperslab(hdf5_dataspace_in_file,H5S_SELECT_SET, start,NULL,count,NULL);
							dims[0]=numberofparticles;
							dims[1]=count[1];							
							hdf5_dataspace_memory=H5Screate_simple(rank,dims,NULL);
							hdf5_status=H5Dwrite(hdf5_dataset,hdf5_datatype,hdf5_dataspace_memory,hdf5_dataspace_in_file,H5P_DEFAULT,CommBuffer);							
							H5Sclose(hdf5_dataspace_memory);
							H5Dclose(hdf5_dataset);
							H5Sclose(hdf5_dataspace_in_file);
							H5Tclose(hdf5_datatype);
						} 
					}
				} else {
					//theoffset += processbytype[type]; //computeparticlesforme(0,mysnapfile->header->npart[type]);
				}
			}
		}
	//	if (myprocessid==0) writeblocksize(fd,elsize * totalparticlesinblock);
	}
	if (myprocessid==mysnapfile->rootprocess)
	{
		for (type=5;type >=0;type--)
			if (mysnapfile->header->npart[type] > 0)
				H5Gclose(hdf5_grp[type]);
		H5Gclose(hdf5_headergrp);
		H5Fclose(hdf5_file);
	}
	free(CommBuffer);
}

void MESHGADsnapfmtHDF5parseparticles(MESHGADparticle * particledump,char * varname,int totalparticlenumber)
{
	char buffer[200];
	int parttype;
	int rank;
	hid_t hdf5_file=0, hdf5_grp[6], hdf5_headergrp=0, hdf5_dataspace_in_memory;
	hid_t hdf5_datatype=0, hdf5_dataspace_in_file=0, hdf5_dataset=0;
	hsize_t dims[2], count[2],start[2];
	snapshotfile * mysnapfile=getsnapshotnode(varname);
	if (mysnapfile->header==NULL) {READHEADER(varname,mysnapfile->rootprocess)}
	FILE *fd;	
	char * CommBuffer=malloc(sizeof(char) * 1024 * 1024 * 20);	//20 MB buffer space
	if (myprocessid==mysnapfile->rootprocess)
	{		
		//readHDFheader(mysnapfile->filename,mysnapfile->header);		
		hdf5_file=H5Fopen(mysnapfile->filename,H5F_ACC_RDONLY,H5P_DEFAULT);
		for (parttype=0;parttype < 6; parttype++)
		{
			if (mysnapfile->header->npart[parttype] > 0)
			{
				//printf("Type %d = %d particles\n",parttype,mysnapfile->header->npart[parttype]);
				sprintf(buffer,"/PartType%d",parttype);
				hdf5_grp[parttype]=H5Gopen(hdf5_file,buffer);
			}
		}
	}
	int blocknumber;	
	for (blocknumber = 0; blocknumber < 5;blocknumber++)
	{
		int memoffset=0;
		int elsize=getblockselementsize(blocknumber);
		int typelist[]={0,0,0,0,0,0};
		int totalparticlesinblock=getparticlesinthisblock(blocknumber,mysnapfile,typelist);
		int blocksize;		
		if (totalparticlesinblock > 0)
		{				
		for (parttype=0;parttype < 6;parttype ++)
		{			
			if (typelist[parttype] ==1)
			{
				int pid;
				int startpoint=0;
				for (pid=0;pid<totalprocesses;pid++)
				{
					int numberofparticles=computeparticlesforme(mysnapfile->rootprocess,mysnapfile->header->npart[parttype]);
					//printf("%d by pid %d\n",mysnapfile->header->npart[parttype],myprocessid);
					if (numberofparticles > totalparticlenumber) {numberofparticles=totalparticlenumber;}	// so we dont overrun allocated memory
					if (myprocessid==mysnapfile->rootprocess)
					{						
						getdatasetname(blocknumber,buffer);
						hdf5_dataset=H5Dopen(hdf5_grp[parttype],buffer);
						dims[0]=mysnapfile->header->npart[parttype];
						int valuesperel=1;
						if (blocknumber==BLOCKPOS || blocknumber==BLOCKVEL) valuesperel=3;
						dims[1]=valuesperel;
						rank=2;
						if (dims[1]==1) rank=1;
						hdf5_dataspace_in_file=H5Screate_simple(rank,dims,NULL);
						dims[0]=numberofparticles;
						hdf5_dataspace_in_memory=H5Screate_simple(rank,dims,NULL);
						start[0]=startpoint;
						start[1]=0;
						count[0]=numberofparticles;
						count[1]=dims[1];
						startpoint+=numberofparticles;
						H5Sselect_hyperslab(hdf5_dataspace_in_file,H5S_SELECT_SET,start,NULL,count,NULL);
						
						if (blocknumber==BLOCKID)
						{
							hdf5_datatype=H5Tcopy(H5T_NATIVE_UINT);
						} else {
							hdf5_datatype=H5Tcopy(H5T_NATIVE_FLOAT);
						}
						
						H5Dread(hdf5_dataset,hdf5_datatype,hdf5_dataspace_in_memory,hdf5_dataspace_in_file,H5P_DEFAULT,CommBuffer);
						H5Tclose(hdf5_datatype);
						H5Sclose(hdf5_dataspace_in_memory);
						H5Sclose(hdf5_dataspace_in_file);
						H5Dclose(hdf5_dataset);
						if (myprocessid != pid)
						{
							MPI_Send(CommBuffer,elsize * numberofparticles,MPI_BYTE,pid,2,MPI_COMM_WORLD);
						}						
					}
					if (myprocessid==pid && myprocessid != mysnapfile->rootprocess)
					{
						MPI_Status stat;
						MPI_Recv(CommBuffer,elsize * numberofparticles,MPI_BYTE,mysnapfile->rootprocess,2,MPI_COMM_WORLD,&stat);
					}
					if (myprocessid==pid)
					{						
						emptybuffertomemory(CommBuffer,blocknumber,memoffset, numberofparticles,parttype,particledump);						
						memoffset=memoffset + numberofparticles;
					}
				}				
			} else {
				memoffset=memoffset + computeparticlesforme(mysnapfile->rootprocess,mysnapfile->header->npart[parttype]);
			}
		}
		}
	}
	if (myprocessid==mysnapfile->rootprocess) 
	{
		for (parttype=5;parttype >=0;parttype--)
			if (mysnapfile->header->npart[parttype] > 0)
				H5Gclose(hdf5_grp[parttype]);
		H5Fclose(hdf5_file);
	}
	free(CommBuffer);
}


