#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <meshamgadget.h>
#include "mpi.h"
#include "snapshotbase.h"

#ifdef SUPPORTHDF5
#include "snapshotHDF.h"
#endif

int myprocessid;
int totalprocesses=1;

snapshotfile * snapshotfilehead=NULL;
/* FUNCTION PROTOTYPES */

/* END OF FN PROTOTYPES */

void MESHGADregistersnapshotfmt1(char * filename, char * variablename,int rootp)
{
	MPI_Comm_rank(MPI_COMM_WORLD,&myprocessid);
	MPI_Comm_size(MPI_COMM_WORLD,&totalprocesses);
	// int num_files=find_files(filename); /*depreciated for now */
	addsnapshotfile(filename,variablename,1,rootp);		
}

void MESHGADregistersnapshotfmt2(char * filename, char * variablename,int rootp)
{
	MPI_Comm_rank(MPI_COMM_WORLD,&myprocessid);
	MPI_Comm_size(MPI_COMM_WORLD,&totalprocesses);
	// int num_files=find_files(filename); /*depreciated for now */
	addsnapshotfile(filename,variablename,2,rootp);		
}

int * MESHGADsnapshotgetnumparticles(char * varname)
{	
	snapshotfile * mysnapfile=getsnapshotnode(varname);
	if (mysnapfile->header==NULL) {READHEADER(varname,mysnapfile->rootprocess)}
	int * particlenumber=malloc(sizeof(int) * 6);	
	memcpy(particlenumber,((mysnapfile->header)->npart),sizeof(int) * 6);
	return particlenumber;
}

int MESHGADsnapshotgetparticlesum(char * varname)
{
	int * particlenumber=MESHGADsnapshotgetnumparticles(varname);
	int i;
	int total=0;
	for (i=0;i<6;i++)
	{
		total+=particlenumber[i];
	}
	free(particlenumber);
	return total;
}

void MESHGADsnapshotsetnumparticles(char * varname, int * particlenums)
{	
	snapshotfile * mysnapfile=getsnapshotnode(varname);
	if (mysnapfile->header==NULL) {MAKEHEADER}	
	memcpy(((mysnapfile->header)->npart),particlenums,sizeof(int) * 6);
}

int * MESHGADsnapshotgetmynumparticles(char * varname)
{	
	snapshotfile * mysnapfile=getsnapshotnode(varname);
	if (mysnapfile->header==NULL) {READHEADER(varname,mysnapfile->rootprocess)}
	int * particlenumber=malloc(sizeof(int) * 6);	
	int i;
	for (i=0;i<6;i++)
	{
		particlenumber[i]=computeparticlesforme(0,((mysnapfile->header)->npart)[i]);		
	}	
	return particlenumber;
}

double * MESHGADsnapshotgetparticlemass(char * varname)
{
	snapshotfile * mysnapfile=getsnapshotnode(varname);
	if (mysnapfile->header==NULL) {READHEADER(varname,mysnapfile->rootprocess)}	
	double * particlemass=malloc(sizeof(double) * 6);
	memcpy(particlemass,((mysnapfile->header)->mass),sizeof(double) * 6);
	return particlemass;
}

void MESHGADsnapshotsetparticlemass(char * varname, double * particlemass)
{
	snapshotfile * mysnapfile=getsnapshotnode(varname);
	if (mysnapfile->header==NULL) {MAKEHEADER}		
	memcpy(((mysnapfile->header)->mass),particlemass,sizeof(double) * 6);	
}

int * MESHGADsnapshotgettotalnumparticles(char * varname)
{
	/*
		Currently unimplemented is if tot number of particles > 2 power 32, if this occurs have the other field
		filled in too - need to consider this at some point
	*/
	snapshotfile * mysnapfile=getsnapshotnode(varname);
	if (mysnapfile->header==NULL) {READHEADER(varname,mysnapfile->rootprocess)}	
	 int * particlenumber=malloc(sizeof(int) * 6);
	memcpy(particlenumber,((mysnapfile->header)->npartTotal),sizeof(int) * 6);
	return particlenumber;
}

void MESHGADsnapshotsettotalnumparticles(char * varname, int * particlenumber)
{
	/*
		Currently unimplemented is if tot number of particles > 2 power 32, if this occurs have the other field
		filled in too - need to consider this at some point
	*/
	snapshotfile * mysnapfile=getsnapshotnode(varname);
	if (mysnapfile->header==NULL) {MAKEHEADER}		 
	memcpy(((mysnapfile->header)->npartTotal),particlenumber,sizeof(int) * 6);	
}

double MESHGADsnapshotgettime(char * varname)
{
	snapshotfile * mysnapfile=getsnapshotnode(varname);
	if (mysnapfile->header==NULL) {READHEADER(varname,mysnapfile->rootprocess)}	
	return ((mysnapfile->header)->time);
}

void MESHGADsnapshotsettime(char * varname,double TT)
{
	snapshotfile * mysnapfile=getsnapshotnode(varname);
	if (mysnapfile->header==NULL) {MAKEHEADER}	
	((mysnapfile->header)->time)=TT;
}

double MESHGADsnapshotgetredshift(char * varname)
{
	snapshotfile * mysnapfile=getsnapshotnode(varname);
	if (mysnapfile->header==NULL) {READHEADER(varname,mysnapfile->rootprocess)}	
	return ((mysnapfile->header)->redshift);
}

void MESHGADsnapshotsetredshift(char * varname, double RS)
{
	snapshotfile * mysnapfile=getsnapshotnode(varname);
	if (mysnapfile->header==NULL) {MAKEHEADER}	
	((mysnapfile->header)->redshift)=RS;
}

int MESHGADsnapshotgetfilespersnapshot(char * varname)
{
	snapshotfile * mysnapfile=getsnapshotnode(varname);
	if (mysnapfile->header==NULL) {READHEADER(varname,mysnapfile->rootprocess)}	
	return ((mysnapfile->header)->num_files);
}

void MESHGADsnapshotsetfilespersnapshot(char * varname, int FPS)
{
	snapshotfile * mysnapfile=getsnapshotnode(varname);
	if (mysnapfile->header==NULL) {MAKEHEADER}	
	((mysnapfile->header)->num_files)=FPS;
}

double MESHGADsnapshotgetboxsize(char * varname)
{
	snapshotfile * mysnapfile=getsnapshotnode(varname);
	if (mysnapfile->header==NULL) {READHEADER(varname,mysnapfile->rootprocess)}	
	return ((mysnapfile->header)->BoxSize);
}

void MESHGADsnapshotsetboxsize(char * varname, double BS)
{
	snapshotfile * mysnapfile=getsnapshotnode(varname);
	if (mysnapfile->header==NULL) {MAKEHEADER}	
	((mysnapfile->header)->BoxSize)=BS;
}

double MESHGADsnapshotgetomega0(char * varname)
{
	snapshotfile * mysnapfile=getsnapshotnode(varname);
	if (mysnapfile->header==NULL) {READHEADER(varname,mysnapfile->rootprocess)}	
	return ((mysnapfile->header)->Omega0);
}

void MESHGADsnapshotsetomega0(char * varname, double O0)
{
	snapshotfile * mysnapfile=getsnapshotnode(varname);
	if (mysnapfile->header==NULL) {MAKEHEADER}	
	((mysnapfile->header)->Omega0)=O0;
}

double MESHGADsnapshotgetomegalambda(char * varname)
{
	snapshotfile * mysnapfile=getsnapshotnode(varname);
	if (mysnapfile->header==NULL) {READHEADER(varname,mysnapfile->rootprocess)}	
	return ((mysnapfile->header)->OmegaLambda);
}

void MESHGADsnapshotsetomegalambda(char * varname,double OL)
{
	snapshotfile * mysnapfile=getsnapshotnode(varname);
	if (mysnapfile->header==NULL) {MAKEHEADER}	
	((mysnapfile->header)->OmegaLambda)=OL;
}

double MESHGADsnapshotgethubble(char * varname)
{
	snapshotfile * mysnapfile=getsnapshotnode(varname);
	if (mysnapfile->header==NULL) {READHEADER(varname,mysnapfile->rootprocess)}	
	return ((mysnapfile->header)->HubbleParam);
}

void MESHGADsnapshotsethubble(char * varname,double HUBBLE)
{
	snapshotfile * mysnapfile=getsnapshotnode(varname);
	if (mysnapfile->header==NULL) {MAKEHEADER}	
	((mysnapfile->header)->HubbleParam)=HUBBLE;
}


int MESHGADsnapshotgetentropy(char * varname)
{
	snapshotfile * mysnapfile=getsnapshotnode(varname);
	if (mysnapfile->header==NULL) {READHEADER(varname,mysnapfile->rootprocess)}	
	return ((mysnapfile->header)->flag_entropy_instead_u);
}

void MESHGADsnapshotsetentropy(char * varname,int ent)
{
	snapshotfile * mysnapfile=getsnapshotnode(varname);
	if (mysnapfile->header==NULL) {MAKEHEADER}	
	((mysnapfile->header)->flag_entropy_instead_u)=ent;
}

void readsnapshot_header(char * varname,int readingtask, int lasttask)
{		
	
	snapshotheader myheader;	
	snapshotfile * mysnapfile=getsnapshotnode(varname);	
	char * filename=mysnapfile->filename;	
	if (myprocessid==readingtask)
	{		
		#ifdef SUPPORTHDF5		
			if (mysnapfile->format==3)
			{			
				 readHDFheader(filename,&myheader);				
			}
		#endif
		if (mysnapfile->format==2 || mysnapfile->format==1)
		{
			FILE * fd;
			if (!(fd=fopen(filename,"r")))
			{
				printf("Error opening IC file %s\n",filename);
			}
			if (mysnapfile->format==2)
			{
				// just reads the title block if fmt==2
				readblocksize(fd);
				char label[4];
				fread(&label,sizeof(char),4,fd);
				int nextblock;
				fread(&nextblock,sizeof(int),1,fd);
				readblocksize(fd);
			}
			int headerbsizestart=readblocksize(fd);		
			fread(&myheader,sizeof(snapshotheader),1,fd);
			int headerbsizeend=readblocksize(fd);
			if (headerbsizestart != 256 || headerbsizeend != 256)
			{
				printf("Error - header block size must be 256 bytes in IC file %s\n",filename);
			}
		}
		int i;
		for (i=readingtask+1;i<=lasttask;i++)
		{
			MPI_Send(&myheader,sizeof(snapshotheader),MPI_BYTE,i,1,MPI_COMM_WORLD);			
		}
	} else {
		MPI_Status status;
		MPI_Recv(&myheader,sizeof(snapshotheader),MPI_BYTE,0,1,MPI_COMM_WORLD,&status);		
	}	
	mysnapfile->header=malloc(sizeof(snapshotheader));
	memcpy(mysnapfile->header,&myheader,sizeof(snapshotheader));
}

int readblocksize(FILE * rd)
{
	int bs=0;
	fread(&bs,sizeof(int),1,rd);
	return bs;
}

void writeblocksize(FILE * rd,int sz)
{	
	fwrite(&sz,sizeof(int),1,rd);	
}

void MESHGADsnapfmt1saveparticles(MESHGADparticle * particledump,char * varname,int particlenumber)
{
	int processbytype[]={0,0,0,0,0,0};
	int q;
	for (q=0;q<particlenumber;q++)
		processbytype[particledump[q].Type]++;	
	int processparts[totalprocesses - 1][6];
	snapshotfile * mysnapfile=getsnapshotnode(varname);	
	if (mysnapfile->header==NULL) {MAKEHEADER}
	if (myprocessid==mysnapfile->rootprocess)
	{
		memcpy(processparts[0],processbytype,sizeof(int) * 6);
		int ij;
		for (ij=1;ij<totalprocesses;ij++)
		{
			MPI_Status stat;
			MPI_Recv(processparts[ij],6,MPI_INT,ij,3,MPI_COMM_WORLD,&stat);
		}
	} else {
		MPI_Send(processbytype,6,MPI_INT,mysnapfile->rootprocess,3,MPI_COMM_WORLD);
	}

	char * CommBuffer=malloc(sizeof(char) * 1024 * 1024 * 20);	// 20 MB buffer
	FILE * fd;
	if (myprocessid==mysnapfile->rootprocess)
	{
		fd=fopen(mysnapfile->filename,"w");
		writeblocksize(fd,sizeof(snapshotheader));
		fwrite(mysnapfile->header,sizeof(snapshotheader),1,fd);
		writeblocksize(fd,sizeof(snapshotheader));
	}
	int typelist[]={0,0,0,0,0,0};
	int blocknumber;
	for (blocknumber=0;blocknumber < 5;blocknumber++)
	{		
		int elsize=getblockselementsize(blocknumber);
		int totalparticlesinblock=getparticlesinthisblock(blocknumber,mysnapfile,typelist);
		//printf("%d\n",totalparticlesinblock);
		if (myprocessid==mysnapfile->rootprocess) writeblocksize(fd,elsize * totalparticlesinblock);
		if (totalparticlesinblock > 0)
		{					
			int type;
			for (type=0;type < 6;type++)
			{
				if (typelist[type])
				{
					int pid;
					int theoffset=0;	// only used when buffersize < particle size and need to do this in multiple passes (NOT YET IMPLEMENTED)
					for (pid=0;pid<totalprocesses;pid++)
					{					
						int numberofparticles=processbytype[type]; //computeparticlesforme(0,mysnapfile->header->npart[type]);						
						if (pid==myprocessid && numberofparticles > 0)
						{						
							fillupbufferfrommemory(CommBuffer,blocknumber,theoffset,particlenumber,type,particledump);
							theoffset=theoffset + numberofparticles ;
							if (myprocessid != mysnapfile->rootprocess)
							{								
								MPI_Send(CommBuffer,elsize * numberofparticles,MPI_BYTE,0,2,MPI_COMM_WORLD);
							}
						}																		
						if (myprocessid==mysnapfile->rootprocess && processparts[pid][type] > 0)
						{
							if (pid != mysnapfile->rootprocess)
							{
								MPI_Status stat;
								MPI_Recv(CommBuffer,elsize * processparts[pid][type],MPI_BYTE,pid,2,MPI_COMM_WORLD,&stat);								
							}							
							fwrite(CommBuffer,elsize,processparts[pid][type],fd);							
						} 
					}
				} else {
					//theoffset += processbytype[type]; //computeparticlesforme(0,mysnapfile->header->npart[type]);
				}
			}
		}
		if (myprocessid==mysnapfile->rootprocess) writeblocksize(fd,elsize * totalparticlesinblock);
	}
	if (myprocessid==mysnapfile->rootprocess){fclose(fd);}
	free(CommBuffer);
}

void MESHGADsnapfmt2saveparticles(MESHGADparticle * particledump,char * varname,int particlenumber)
{
	int processbytype[]={0,0,0,0,0,0};
	int q;
	for (q=0;q<particlenumber;q++)
		processbytype[particledump[q].Type]++;	
	int processparts[totalprocesses - 1][6];
	snapshotfile * mysnapfile=getsnapshotnode(varname);	
	if (mysnapfile->header==NULL) {MAKEHEADER}
	if (myprocessid==mysnapfile->rootprocess)
	{
		memcpy(processparts[0],processbytype,sizeof(int) * 6);
		int ij;
		for (ij=1;ij<totalprocesses;ij++)
		{
			MPI_Status stat;
			MPI_Recv(processparts[ij],6,MPI_INT,ij,3,MPI_COMM_WORLD,&stat);
		}
	} else {
		MPI_Send(processbytype,6,MPI_INT,mysnapfile->rootprocess,3,MPI_COMM_WORLD);
	}
	
	char * CommBuffer=malloc(sizeof(char) * 1024 * 1024 * 20);	// 20 MB buffer
	FILE * fd;
	if (myprocessid==mysnapfile->rootprocess)
	{
		fd=fopen(mysnapfile->filename,"w");
		writeblocksize(fd,sizeof(int) + 4 * sizeof(char));
		fwrite("HEAD",sizeof(char),4,fd);
		int nb=sizeof(snapshotheader) + 2 * sizeof(int);
		fwrite(&nb,sizeof(int),1,fd);
		writeblocksize(fd,sizeof(int) + 4 * sizeof(char));
		writeblocksize(fd,sizeof(snapshotheader));
		fwrite(mysnapfile->header,sizeof(snapshotheader),1,fd);
		writeblocksize(fd,sizeof(snapshotheader));
	}
	int typelist[]={0,0,0,0,0,0};
	int blocknumber;
	for (blocknumber=0;blocknumber < 5;blocknumber++)
	{		
		int elsize=getblockselementsize(blocknumber);
		int totalparticlesinblock=getparticlesinthisblock(blocknumber,mysnapfile,typelist);
		if (myprocessid==mysnapfile->rootprocess)
		{
			int particleblocksize=totalparticlesinblock * elsize + 2 * sizeof(int);
			writeblocksize(fd,sizeof(int) + 4 * sizeof(char));
			switch (blocknumber)
			{
				case BLOCKPOS:
					fwrite("POS ",sizeof(char),4,fd);
					break;
				case BLOCKVEL:
					fwrite("VEL ",sizeof(char),4,fd);
					break;
				case BLOCKMASS:
					fwrite("MASS",sizeof(char),4,fd);
					break;
				case BLOCKID:
					fwrite("ID ",sizeof(char),4,fd);
					break;
				case BLOCKU:
					fwrite("U   ",sizeof(char),4,fd);
					break;					
			}
			fwrite(&particleblocksize,sizeof(int),1,fd);
			writeblocksize(fd,sizeof(int) + 4 * sizeof(char));
		}
		//printf("%d\n",totalparticlesinblock);
		if (myprocessid==mysnapfile->rootprocess) writeblocksize(fd,elsize * totalparticlesinblock);
		if (totalparticlesinblock > 0)
		{					
			int type;
			for (type=0;type < 6;type++)
			{
				if (typelist[type])
				{
					int pid;
					int theoffset=0;	// only used when buffersize < particle size and need to do this in multiple passes (NOT YET IMPLEMENTED)
					for (pid=0;pid<totalprocesses;pid++)
					{					
						int numberofparticles=processbytype[type]; //computeparticlesforme(0,mysnapfile->header->npart[type]);						
						if (pid==myprocessid && numberofparticles > 0)
						{						
							fillupbufferfrommemory(CommBuffer,blocknumber,theoffset,particlenumber,type,particledump);
							theoffset=theoffset + numberofparticles ;
							if (myprocessid != mysnapfile->rootprocess)
							{								
								MPI_Send(CommBuffer,elsize * numberofparticles,MPI_BYTE,0,2,MPI_COMM_WORLD);
							}
						}																		
						if (myprocessid==mysnapfile->rootprocess && processparts[pid][type] > 0)
						{
							if (pid != mysnapfile->rootprocess)
							{
								MPI_Status stat;
								MPI_Recv(CommBuffer,elsize * processparts[pid][type],MPI_BYTE,pid,2,MPI_COMM_WORLD,&stat);								
							}							
							fwrite(CommBuffer,elsize,processparts[pid][type],fd);							
						} 
					}
				} else {
					//theoffset += processbytype[type]; //computeparticlesforme(0,mysnapfile->header->npart[type]);
				}
			}
		}
		if (myprocessid==mysnapfile->rootprocess) writeblocksize(fd,elsize * totalparticlesinblock);
	}
	if (myprocessid==mysnapfile->rootprocess){fclose(fd);}
	free(CommBuffer);
}

void fillupbufferfrommemory(void * theCommBuffer,int blocknumber,int offset,int numberofparticles,int type, MESHGADparticle * particledump)
{
	float * fp=theCommBuffer;
	int * ip=theCommBuffer;
	int i,j;	
	switch(blocknumber)
	{				
		case BLOCKPOS:
			for (i=0;i<numberofparticles;i++)			
			{
				if (particledump[offset + i].Type==type)
				{
					for (j=0;j<3;j++)					
						fp[j]=particledump[offset + i].Pos[j];
					 fp += 3;
				}
			}					
			break;
		case BLOCKVEL:
			for (i=0;i<numberofparticles;i++)							
			{			
				if (particledump[offset + i].Type==type)
				{
					for (j=0;j<3;j++)					
						fp[j]=particledump[offset + i].Vel[j] + particledump[offset + i].GravAccel[j];
					fp += 3;
				}
			}
			break;
		case BLOCKMASS:			
			for (i=0;i<numberofparticles;i++)
			{
				if (particledump[offset + i].Type==type)															
					*fp++=particledump[offset + i].Mass;				
			}			
			break;
		case BLOCKID:							
			for (i=0;i<numberofparticles;i++)
			{		
				if (particledump[offset + i].Type==type)
				{															
					*ip++=particledump[offset + i].ID;								
				} 																
			}												
			break;				
	}
}

void MESHGADsnapfmt1parseparticles(MESHGADparticle * particledump,char * varname,int totalparticlenumber)
{
	snapshotfile * mysnapfile=getsnapshotnode(varname);
	if (mysnapfile->header==NULL) {READHEADER(varname,mysnapfile->rootprocess)}
	FILE *fd;	
	char * CommBuffer=malloc(sizeof(char) * 1024 * 1024 * 20);	//20 MB buffer space
	if (myprocessid==mysnapfile->rootprocess)
	{
		fd=fopen(mysnapfile->filename,"r");
		int headsize=readblocksize(fd);
		snapshotheader mhead;
		fread(&mhead,sizeof(snapshotheader),1,fd);
		headsize=readblocksize(fd);
	}
	int blocknumber;	
	for (blocknumber = 0; blocknumber < 5;blocknumber++)
	{
		int memoffset=0;
		int elsize=getblockselementsize(blocknumber);
		int typelist[]={0,0,0,0,0,0};
		int totalparticlesinblock=getparticlesinthisblock(blocknumber,mysnapfile,typelist);
		int blocksize;
		if (myprocessid==mysnapfile->rootprocess) {blocksize=readblocksize(fd);}		
		if (totalparticlesinblock > 0)
		{		
		int parttype;
		for (parttype=0;parttype < 6;parttype ++)
		{			
			if (typelist[parttype] ==1)
			{
				int pid;
				for (pid=0;pid<totalprocesses;pid++)
				{
					int numberofparticles=computeparticlesforme(mysnapfile->rootprocess,mysnapfile->header->npart[parttype]);					
					if (numberofparticles > totalparticlenumber) {numberofparticles=totalparticlenumber;}	// so we dont overrun allocated memory
					if (myprocessid==mysnapfile->rootprocess)
					{						
						fread(CommBuffer,elsize,numberofparticles,fd);						
						if (myprocessid != pid)
						{
							MPI_Send(CommBuffer,elsize * numberofparticles,MPI_BYTE,pid,2,MPI_COMM_WORLD);
						}						
					}
					if (myprocessid==pid && myprocessid != mysnapfile->rootprocess)
					{
						MPI_Status stat;
						MPI_Recv(CommBuffer,elsize * numberofparticles,MPI_BYTE,mysnapfile->rootprocess,2,MPI_COMM_WORLD,&stat);
					}
					if (myprocessid==pid)
					{						
						emptybuffertomemory(CommBuffer,blocknumber,memoffset, numberofparticles,parttype,particledump);						
						memoffset=memoffset + numberofparticles;
					}
				}				
			} else {
				memoffset=memoffset + computeparticlesforme(mysnapfile->rootprocess,mysnapfile->header->npart[parttype]);
			}
		}
		}
		if (myprocessid==mysnapfile->rootprocess) {readblocksize(fd);}	// reads block size at end of block
	}
	if (myprocessid==mysnapfile->rootprocess) {fclose(fd);}
	free(CommBuffer);
}

void MESHGADsnapfmt2parseparticles(MESHGADparticle * particledump,char * varname,int totalparticlenumber)
{
	char label[4];
	int nextblocksize;
	snapshotfile * mysnapfile=getsnapshotnode(varname);
	if (mysnapfile->header==NULL) {READHEADER(varname,mysnapfile->rootprocess)}
	FILE *fd;	
	char * CommBuffer=malloc(sizeof(char) * 1024 * 1024 * 20);	//20 MB buffer space
	if (myprocessid==mysnapfile->rootprocess)
	{
		fd=fopen(mysnapfile->filename,"r");
		readblocksize(fd);
		fread(&label,sizeof(char),4,fd);
		fread(&nextblocksize,sizeof(int),1,fd);
		readblocksize(fd);
		int headsize=readblocksize(fd);
		snapshotheader mhead;
		fread(&mhead,sizeof(snapshotheader),1,fd);
		headsize=readblocksize(fd);
	}
	int blocknumber;	
	for (blocknumber = 0; blocknumber < 5;blocknumber++)
	{
		int memoffset=0;
		int elsize=getblockselementsize(blocknumber);
		int typelist[]={0,0,0,0,0,0};
		int totalparticlesinblock=getparticlesinthisblock(blocknumber,mysnapfile,typelist);
		int blocksize;
		if (myprocessid==mysnapfile->rootprocess) 
		{
			readblocksize(fd);
			fread(&label,sizeof(char),4,fd);
			fread(&nextblocksize,sizeof(int),1,fd);
			readblocksize(fd);			
			blocksize=readblocksize(fd);
		}		
		if (totalparticlesinblock > 0)
		{		
		int parttype;
		for (parttype=0;parttype < 6;parttype ++)
		{			
			if (typelist[parttype] ==1)
			{
				int pid;
				for (pid=0;pid<totalprocesses;pid++)
				{
					int numberofparticles=computeparticlesforme(mysnapfile->rootprocess,mysnapfile->header->npart[parttype]);
					if (numberofparticles > totalparticlenumber) {numberofparticles=totalparticlenumber;}	// so we dont overrun allocated memory
					if (myprocessid==mysnapfile->rootprocess)
					{						
						fread(CommBuffer,elsize,numberofparticles,fd);						
						if (myprocessid != pid)
						{
							MPI_Send(CommBuffer,elsize * numberofparticles,MPI_BYTE,pid,2,MPI_COMM_WORLD);
						}						
					}
					if (myprocessid==pid && myprocessid != mysnapfile->rootprocess)
					{
						MPI_Status stat;
						MPI_Recv(CommBuffer,elsize * numberofparticles,MPI_BYTE,mysnapfile->rootprocess,2,MPI_COMM_WORLD,&stat);
					}
					if (myprocessid==pid)
					{						
						emptybuffertomemory(CommBuffer,blocknumber,memoffset, numberofparticles,parttype,particledump);						
						memoffset=memoffset + numberofparticles;
					}
				}				
			} else {
				memoffset=memoffset + computeparticlesforme(mysnapfile->rootprocess,mysnapfile->header->npart[parttype]);
			}
		}
		}
		if (myprocessid==mysnapfile->rootprocess) {readblocksize(fd);}	// reads block size at end of block
	}
	if (myprocessid==mysnapfile->rootprocess) {fclose(fd);}
	free(CommBuffer);
}

void emptybuffertomemory(void * theCommBuffer,int blocknumber,int offset,int numberofparticles,int type, MESHGADparticle * particledump)
{
	int i,j;
	float *fp= theCommBuffer;
	int *ip=theCommBuffer;	
	switch(blocknumber)
	{
		case BLOCKPOS:
			for (i=0;i<numberofparticles;i++)			
			{
				particledump[offset + i].Type=type;
				for (j=0;j<3;j++)					
					particledump[offset + i].Pos[j]=*fp++;
			}					
			break;
		case BLOCKVEL:
			for (i=0;i<numberofparticles;i++)							
				for (j=0;j<3;j++)					
					particledump[offset + i].Vel[j]=*fp++;
			break;
		case BLOCKMASS:			
			for (i=0;i<numberofparticles;i++)											
				particledump[offset + i].Mass=*fp++;			
			break;
		case BLOCKID:			
			for (i=0;i<numberofparticles;i++)											
				particledump[offset + i].ID=*ip++;			
			break;
		// NOTE HOW OTHER FIELDS (INCLUDING U) ARE NOT CONSIDERED AT THE MOMENT
	}	
}

int computeparticlesforme(int readtask,int totalparts)
{
	int forme=totalparts / totalprocesses;
	if ((myprocessid - readtask) < (totalparts % totalprocesses)) {forme++;}
	return forme;
}

int getparticlesinthisblock(int blocknumber,snapshotfile * snappy, int typelist[])
{
	int totalparticles=0;
	int totalwithmass=0;
	int partid=0;
	for (partid=0;partid<6;partid++) 
	{		
		if ((snappy->header)->npart[partid] > 0) {typelist[partid]=1;}		
		totalparticles=totalparticles + (snappy->header)->npart[partid] ;
		if ((snappy->header)->mass[partid]==0) {totalwithmass=totalwithmass + (snappy->header)->npart[partid] ;}
	}
	
	switch (blocknumber)
	{
		case BLOCKPOS:
		case BLOCKVEL:
		case BLOCKID:
			return totalparticles;
			break;
		case BLOCKU:
			return (snappy->header)->npart[0];
			break;
		case BLOCKMASS:
			for (partid=0;partid<6;partid++) 
			{
				typelist[partid]=0;
				if ((snappy->header)->mass[partid]==0) {typelist[partid]=1;} 
			}	
			return totalwithmass;
			break;
	}
}

void getdatasetname(int blocknum,char * buffer)
{
	strcpy(buffer,"default\0");
	switch(blocknum)
	{
		case BLOCKPOS:
			strcpy(buffer,"Coordinates\0");
			break;
		case BLOCKVEL:
			strcpy(buffer,"Velocities\0");
			break;
		case BLOCKID:
			strcpy(buffer,"ParticleIDs\0");
			break;
		case BLOCKMASS:
			strcpy(buffer,"Masses\0");
			break;
		case BLOCKU:
			strcpy(buffer,"InternalEnergy\0");
			break;
	}
}

int getblockselementsize(int blocknumber)
{
	switch(blocknumber)
	{
		case BLOCKPOS:
		case BLOCKVEL:
			return 3 * sizeof(float);
			break;
		case BLOCKMASS:
		case BLOCKU:
			return sizeof(float);
			break;
		case BLOCKID:
			return  sizeof(int);
			break;
	}
}

snapshotfile * getsnapshotnode(char * varname)
{
	snapshotfile * ch=snapshotfilehead;
	//printf("%p\n",ch->next);
	while (ch != NULL)
	{		
		if (strcmp(ch->variablename,varname) == 0) return ch;		
		ch=ch -> next;		
	}	
	return NULL;
}

void MESHGADfreesnapfile(char * varname)
{
	snapshotfile * ch=getsnapshotnode(varname);
	if (ch==NULL) return;
	if ((ch->prev) != NULL)
	{
		(ch->prev)->next=ch->next;		
	} else {		
		snapshotfilehead=ch->next;
	}
	if (ch->next !=NULL) {(ch->next)->prev=ch->prev;}
	if (ch->header != NULL) {free(ch->header);}	
	if (ch->variablename != NULL) {free(ch->variablename);}	
	if (ch->filename != NULL) {free(ch->filename);}	
	free(ch);
}

void addsnapshotfile(char * filename,char * variablename, int fmt,int root)
{
	snapshotfile * newfile=malloc(sizeof(snapshotfile));
	newfile->filename=malloc(sizeof(char) * strlen(filename) + 2);
	newfile->variablename=malloc(sizeof(char) * strlen(variablename) + 2);
	strcpy(newfile->filename,filename);	
	strcpy(newfile->variablename,variablename);	
	newfile->format=fmt;
	newfile->rootprocess=root;
	newfile->header=NULL;
	newfile->next=snapshotfilehead;	
	newfile->prev=NULL;
	if (snapshotfilehead!=NULL)
	{
		snapshotfilehead->prev=newfile;
	}
	snapshotfilehead=newfile;	
}

int find_files(char * filename)
{	
	FILE * fd;
	snapshotheader myheader;
	myheader.num_files=-1;
	if (myprocessid==0)
	{
		if ((fd=fopen(filename,"r")))
		{			
			int blocksize;
			fread(&blocksize,sizeof(int),1,fd);			
			fread(&myheader,sizeof(snapshotheader),1,fd);			
			fread(&blocksize,sizeof(int),1,fd);
			fclose(fd);			
		}
	}
	MPI_Bcast(&myheader,sizeof(snapshotheader),MPI_BYTE,0,MPI_COMM_WORLD);
	if (myheader.num_files > 0) { return myheader.num_files;}
	if (myheader.num_files == 0) { return 1;}
	char buf[200];
	sprintf(buf,"%s.%d",filename,0);
	if (myprocessid==0)
	{
		if ((fd=fopen(buf,"r")))
		{			
			int blocksize;
			fread(&blocksize,sizeof(int),1,fd);			
			fread(&myheader,sizeof(snapshotheader),1,fd);			
			fread(&blocksize,sizeof(int),1,fd);
			fclose(fd);			
		}
	}
	MPI_Bcast(&myheader,sizeof(snapshotheader),MPI_BYTE,0,MPI_COMM_WORLD);
	if (myheader.num_files > 0) { return myheader.num_files;}
	return -1;
}
