#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#define DOUBLE 1
#define STRING 2
#define INT 3

#define NOERROR 0
#define FILEACCESSERROR 1
#define UNIDENTIFIEDTAGERROR 2
#define CLONETAGERROR 3
#define MISSINGTAGERROR 4
#define DEFAULTSTRINGSIZE 200
typedef struct llist {struct llist * prev;void * ptr; struct llist * next; char * name; int datatype;int filled;} List;
typedef struct alist {struct alist * prev;List * listhead ; struct alist * next; char * variablename;int parsed;char * filename;int errors;int updated;} IndexList;
IndexList * indexhead=NULL;
void clearlist(char *);
List * newauxnode(char * ,void * ,int );
void displayList(char *);
int checkNoMissingData(char *,char *);
void parseparamfile(char * );
void fillDataList(char *,char *);
void addtolist(List *,char *);
List * getData(char *,char *);
List * newnode(char *,void *,int);
int read_outputlist(char *);
IndexList * findIndexItem(char * );
void addToIndex(char *,char *);
List * findtail(List *);
void writeparamfile(char *);

void * MESHGADgetparamvalue(char * searchstring, char * varname)
{
	IndexList * il=findIndexItem(varname);
	if (il->parsed==0) {parseparamfile(varname);} 
	
	List * di=getData(searchstring,varname);
	if (di !=NULL)
	{
		return di->ptr;
	}
}

void * MESHGADcopyparamvalues(char * varnameto, char * varnamefrom)
{
	IndexList * il=findIndexItem(varnamefrom);
	if (il->parsed==0) {parseparamfile(varnamefrom);}
	 IndexList * il2=findIndexItem(varnameto);
	 il2->parsed=1;
	 il2->updated=1;
	 List * fromhead=il->listhead;
	 List * tohead=il2->listhead;
	 while (fromhead !=NULL && tohead != NULL)
	 {
	 	tohead->filled=1;
	 	switch (fromhead->datatype)
		{
			case DOUBLE:
				*((double *) tohead->ptr)=*((double *) fromhead->ptr);
			case STRING:
				strcpy(tohead->ptr,fromhead->ptr);
			case INT:
				*((int *) tohead->ptr)=*((int *) fromhead->ptr);
		}
		fromhead=fromhead->next;
		tohead=tohead->next;
	 }
	 writeparamfile(varnameto);
}

List * findtail(List * head)
{
	List * thead=head;
	List * oldhead=head;
	while (thead != NULL)
	{
		oldhead=thead;
		thead=thead->next;
	}
	return oldhead;
}

void writeparamfile(char * varname)
{
	int errors;
	IndexList * il=findIndexItem(varname);
	FILE * usedvalues;	
	if (!(usedvalues=fopen(il->filename,"w")))
	{
		printf("Error opening file %s for writing\n\n",il->filename);
		errors=FILEACCESSERROR;
	}
	 List * lhead=findtail(il->listhead);	// required as its stored LL wise in reverse order
	 while (lhead !=NULL)
	 {
	 	switch (lhead->datatype)
		{
			case DOUBLE:
				fprintf(usedvalues,"%-35s%g\n",lhead->name,*((double *) lhead->ptr));
				break;				
			case STRING:
				fprintf(usedvalues,"%-35s%s\n",lhead->name, lhead->ptr);
				break;
			case INT:
				fprintf(usedvalues,"%-35s%d\n",lhead->name, *((int *) lhead->ptr));
				break;
		}
		lhead=lhead->prev;
	 }
	 fclose(usedvalues);
	 il->errors=errors;
	 il->updated=0;
}

void MESHGADputparamvalue(char * searchstring, void * val,char * varname)
{
	IndexList * il=findIndexItem(varname);
	il->parsed=1;
	il->updated=1;
	List * di=getData(searchstring,varname);
	if (di !=NULL)
	{
		switch (di->datatype)
		{
			case STRING:
				strcpy(di->ptr,val);
				break;
			case DOUBLE:
				*((double *) di->ptr)=*((double *) val);
				break;
			case INT:
				*((int *) di->ptr)=*((int *) val);
		}
	}
}

void MESHGADregisterparamfile(char * filename, char * varname)
{
	fillDataList(filename, varname);
}

void parseparamfile(char * varname)
{
	int errors=NOERROR;	
	IndexList * il=findIndexItem(varname);
	char * filename=il->filename;
	il->parsed=1;
	FILE * paramfile;
	if (!(paramfile=fopen(filename,"r")))
	{
		printf("Parameter File %s not found\n\n",filename);
		errors=FILEACCESSERROR;
	}
	
	char inputdata[200];
	char seg1[200];
	char seg2[200];
	char seg3[400];
	while (!(feof(paramfile)))
	{		
		fgets(inputdata,200,paramfile);
		if (sscanf(inputdata,"%s%s%s",seg1,seg2,seg3) < 2) {continue;}	// not enough data on this line
		if (seg1[0]=='%') {continue;}	// this line is a comment		
		List * listitem=getData(seg1,varname);
		//printf("%s\n",seg1);
		if (listitem == NULL) {fprintf(stdout,"Error in file %s:		Tag '%s' not found\n",filename,seg1);errors=UNIDENTIFIEDTAGERROR;}
		if (listitem->filled==1) {fprintf(stdout,"Error in file %s:		Tag '%s' defined multiple times\n",filename,seg1);errors=CLONETAGERROR;}
		listitem->filled=1;
		switch (listitem->datatype)
		{
			case DOUBLE:
				*((double *) listitem->ptr)=atof(seg2);		
				break;
			case STRING:
				strcpy(listitem->ptr,seg2);				
				break;
			case INT:
				*((int *) listitem->ptr)=atoi(seg2);				
				break;
		}		
	}	
	fclose(paramfile);		
	if (checkNoMissingData(filename,varname) > 0) errors=MISSINGTAGERROR;	
	List * OL=getData("OutputListOn\0",varname);	
	if (*((int *) OL->ptr)==1 && errors==NOERROR)
	{
		// call the read output list and check its error code!
		List * OLF=getData("OutputListFilename\0",varname);
		//errors=read_outputlist(OLF->ptr);	// REENABLE!!
	} else {	
		List * OLL=getData("OutputListLength\0",varname);
		*((int *) OLL->ptr)=atoi("0\0");		
	}	
	il->errors=errors;	// write errors to the parseerror variable which we can access later	
}

int read_outputlist(char *fname)
{
/*
	// copied straight from the gadget code
	FILE *fd;
 	if(!(fd = fopen(fname, "r")))
	{
		printf("can't read output list in file '%s'\n", fname);
		return FILEACCESSERROR;
 	}

	All.OutputListLength = 0;
	
	while(All.OutputListLength < MAXLEN_OUTPUTLIST)
   	{
   		if(fscanf(fd, " %lg ", &All.OutputListTimes[All.OutputListLength]) == 1)
   		{
  			All.OutputListLength++;
  		} else {
       		break;
       	}
    }
  	fclose(fd);
 	printf("\nfound %d times in output-list.\n", All.OutputListLength);
 	return NOERROR;
 	*/
}

int checkNoMissingData(char * fname,char * varname)
{
	int missingdata=0;
	List * ch=findIndexItem(varname)->listhead;
	while ( ch != NULL)
	{
		if (ch->filled==0)
		{
			printf("Error - You are missing tag '%s' in the parameter file %s\n",ch->name,fname);
			missingdata=1;
		}
		ch=ch->next;
	}
	return missingdata;
}

List * getData(char * searchstring,char * varname)
{	
	List * ch=(findIndexItem(varname)->listhead);		
	while ( ch != NULL)
	{
		//printf("%s ? %s\n",ch->name,searchstring);
		if (strcmp(ch->name,searchstring)==0) {return ch;}
		ch=ch->next;
	}
	return NULL;
}

List * newauxnode(char * datastring,void * dptr,int dt)
{
	List * nn=newnode(datastring,dptr,dt);
	nn->filled=1;
	return nn;
}

List * newnode(char * datastring,void * dptr,int dt)
{	
	List * newn=malloc(sizeof(List));	
	newn->datatype=dt;
	newn->ptr=dptr;
	// put in default values so that if its written out before filling then doesnt cause any problems
	switch (dt)
	{
		case STRING:
			strcpy(newn->ptr,"\0");
			break;
		case INT:
			*((int *) newn->ptr)=0;
			break;
		case DOUBLE:
			*((int *) newn->ptr)=0.0;
			break;
	}
	newn->filled=0;
	newn->next=NULL;
	newn->prev=NULL;
	char * thestring=malloc(sizeof(char) * strlen(datastring) + 2);
	strcpy(thestring,datastring);
	newn->name=thestring;
	return newn;
}

void addtolist(List * nnode, char * varname)
{		
	IndexList * toadd=findIndexItem(varname);	
	if (toadd !=NULL)
	{
		List * chead= toadd->listhead;
		if (chead != NULL)
		{				
			chead->prev=nnode;		
			nnode->next=chead;		
		}		
		toadd->listhead=nnode;
	}
}

void displayList(char * varname)
{	
	IndexList * toadd=findIndexItem(varname);
	List * chead= toadd->listhead;
	while (chead != NULL)
	{		
		printf("%s\n",chead->name);
		chead=chead->next;		
	}		
}

void MESHGADfreeparamfile(char * varname)
{
	IndexList * ll=findIndexItem(varname);
	if (ll->updated==1) {writeparamfile(varname);}
	clearlist(varname);
}

void clearlist(char * varname)
{
	IndexList * ll=findIndexItem(varname);
	List * listhead=ll->listhead;
	while (listhead!=NULL)
	{
		List * oldhead=listhead;
		listhead=listhead->next;		
		if (oldhead->ptr != NULL) {free(oldhead->ptr);}
		free(oldhead->name);		
		free(oldhead);
	}
	free(ll->variablename);
	free(ll->filename);
	if (ll->prev !=NULL)
	{
		ll->prev=ll->next;
	}
	if (ll->next !=NULL)
	{
		ll->next=ll->prev;
	}
	free(ll);
}

IndexList * findIndexItem(char * varname)
{
	IndexList * ch=indexhead;
	while ( ch != NULL)
	{
		if (strcmp(ch->variablename,varname)==0) {return ch;}
		ch=ch->next;
	}
	return NULL;
}

void addToIndex(char * filename, char * varname)
{
	IndexList * newn=malloc(sizeof(IndexList));
	newn->variablename=malloc(sizeof(char) * (strlen(varname) + 1));
	newn->filename=malloc(sizeof(char) * (strlen(filename) + 1));
	strcpy(newn->variablename,varname);
	newn->listhead=NULL;
	newn->errors=NOERROR;
	newn->updated=0;
	strcpy(newn->filename,filename);
	newn->parsed=0;
	if (indexhead != NULL)
	{
		indexhead->prev=newn;
		newn->next=indexhead;
	}
	indexhead=newn;
}

void fillDataList(char * filename, char * varname)
{
	addToIndex(filename,varname);	
	addtolist(newnode("InitCondFile\0",malloc(sizeof(char) * DEFAULTSTRINGSIZE),STRING),varname);	
	addtolist(newnode("OutputDir\0",malloc(sizeof(char) * DEFAULTSTRINGSIZE),STRING),varname);	
	addtolist(newnode("SnapshotFileBase\0",malloc(sizeof(char) * DEFAULTSTRINGSIZE),STRING),varname);	
	addtolist(newnode("EnergyFile\0",malloc(sizeof(char) * DEFAULTSTRINGSIZE),STRING),varname);
	addtolist(newnode("CpuFile\0",malloc(sizeof(char) * DEFAULTSTRINGSIZE),STRING),varname);
	addtolist(newnode("InfoFile\0",malloc(sizeof(char) * DEFAULTSTRINGSIZE),STRING),varname);
	addtolist(newnode("TimingsFile\0",malloc(sizeof(char) * DEFAULTSTRINGSIZE),STRING),varname);
	addtolist(newnode("RestartFile\0",malloc(sizeof(char) * DEFAULTSTRINGSIZE),STRING),varname);
	addtolist(newnode("ResubmitCommand\0",malloc(sizeof(char) * DEFAULTSTRINGSIZE),STRING),varname);
	addtolist(newnode("OutputListFilename\0",malloc(sizeof(char) * DEFAULTSTRINGSIZE),STRING),varname);	
	addtolist(newnode("OutputListOn\0",malloc(sizeof(int)),INT),varname);	
	addtolist(newnode("Omega0\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("OmegaBaryon\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("OmegaLambda\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("HubbleParam\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("BoxSize\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("PeriodicBoundariesOn\0",malloc(sizeof(int)),INT),varname);
	addtolist(newnode("TimeOfFirstSnapshot\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("CpuTimeBetRestartFile\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("TimeBetStatistics\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("TimeBegin\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("TimeMax\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("TimeBetSnapshot\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("UnitVelocity_in_cm_per_s\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("UnitLength_in_cm\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("UnitMass_in_g\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("TreeDomainUpdateFrequency\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("ErrTolIntAccuracy\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("ErrTolTheta\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("ErrTolForceAcc\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("MinGasHsmlFractional\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("MaxSizeTimestep\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("MinSizeTimestep\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("MaxRMSDisplacementFac\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("ArtBulkViscConst\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("CourantFac\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("DesNumNgb\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("MaxNumNgbDeviation\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("ComovingIntegrationOn\0",malloc(sizeof(int)),INT),varname);
	addtolist(newnode("ICFormat\0",malloc(sizeof(int)),INT),varname);
	addtolist(newnode("SnapFormat\0",malloc(sizeof(int)),INT),varname);
	addtolist(newnode("NumFilesPerSnapshot\0",malloc(sizeof(int)),INT),varname);
	addtolist(newnode("NumFilesWrittenInParallel\0",malloc(sizeof(int)),INT),varname);
	addtolist(newnode("ResubmitOn\0",malloc(sizeof(int)),INT),varname);
	addtolist(newnode("TypeOfTimestepCriterion\0",malloc(sizeof(int)),INT),varname);
	addtolist(newnode("TypeOfOpeningCriterion\0",malloc(sizeof(int)),INT),varname);
	addtolist(newnode("TimeLimitCPU\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("SofteningHalo\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("SofteningDisk\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("SofteningBulge\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("SofteningGas\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("SofteningStars\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("SofteningBndry\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("SofteningHaloMaxPhys\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("SofteningDiskMaxPhys\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("SofteningBulgeMaxPhys\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("SofteningGasMaxPhys\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("SofteningStarsMaxPhys\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("SofteningBndryMaxPhys\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("BufferSize\0",malloc(sizeof(int)),INT),varname);
	addtolist(newnode("PartAllocFactor\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("TreeAllocFactor\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("GravityConstantInternal\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("InitGasTemp\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newnode("MinGasTemp\0",malloc(sizeof(double)),DOUBLE),varname);
	addtolist(newauxnode("OutputListLength\0",malloc(sizeof(int)),INT),varname);
	//displayList(varname);	
}
