#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>
#include "buildmesham.h"

char expnames[20][100];
jmp_buf jmpbuf[20];
int bufferptr=0;

jmp_buf * MESHErrorregisterExceptionHandler(char * name)
{	
	strcpy(expnames[bufferptr],name);
	bufferptr++;	
	return &jmpbuf[bufferptr-1];	
}

void MESHErrorcallFarException(char * name)
{
	int i;	
	for (i=0;i<bufferptr;i++)
	{		
		if ((strcmp(expnames[i],name)==0) || (strcmp(expnames[i],"\0")==0)) 
		{
			longjmp(jmpbuf[i],2);
			printf("OK");
		}
	}
	MESHUnknownException(name);	// no exception found - unknown = error
}

DLLIMPORT void MESHErrordivideByZero()
{
	printf ("Divide By Zero\n");
	exit(EXIT_FAILURE);
};

DLLIMPORT void MESHUnknownException(char * s)
{
	printf("Uncaught exception \"%s\" occured during execution\n",s);
	exit(EXIT_FAILURE);
}

DLLIMPORT void MESHErrorMallocNull()
{
	printf ("Memory Allocation Failed\n");
	exit(EXIT_FAILURE);
};

DLLIMPORT void MESHErrorMemoryBlock()
{
	printf ("Shared Memory Block Too Small\n");
	exit(EXIT_FAILURE);
};

DLLIMPORT int MESHErrorIllegalBlockNumber()
{
	printf ("Illegal Block Number in partition access\n");
	exit(EXIT_FAILURE);
	return 0;	// required as the a[x?a:b] a and b both need to be integers
};

DLLIMPORT void MESHErrorBlockNumNotOnRecvProcess()
{
	printf ("Receiving process and process holding the block do not match\n");
	exit(EXIT_FAILURE);
};
