#include "mpi.h"
#include <stdio.h>
#include <setjmp.h>
#include <stddef.h>

#ifndef DLLIMPORT
	#define DLLIMPORT	
#endif

DLLIMPORT double MESHsqrt(double);
DLLIMPORT double MESHPI();
DLLIMPORT double MESHsqr(double);
DLLIMPORT float MESHrandom(int, int);
DLLIMPORT int MESHlog(int);
DLLIMPORT int MESHgetprime(int);
DLLIMPORT double MESHfloor(double);
DLLIMPORT int MESHmod(int,int);
//Async
DLLIMPORT void MESHRegisterOneSidedWindow(MPI_Win *,char *);
DLLIMPORT void MESHRegisterAsyncRequest(MPI_Request *,char *);
DLLIMPORT void MESHRegisterBufferedVar(char *,void *,int);
DLLIMPORT void MESHRegisterAsyncRequestAndMemCpy(MPI_Request *,char *,void *, void *,int,char *);
DLLIMPORT void MESHSyncWithVariableName(char *);
DLLIMPORT void MESHinformdeadvariable(char *);
DLLIMPORT void MESHSyncAll();
//Exceptions
jmp_buf * MESHErrorregisterExceptionHandler(char *);
void MESHErrorcallFarException(char *);
DLLIMPORT void MESHUnknownException(char *);
DLLIMPORT void MESHErrordivideByZero();
DLLIMPORT void MESHErrorMallocNull();
DLLIMPORT void MESHErrorMemoryBlock();
DLLIMPORT int MESHErrorIllegalBlockNumber();
DLLIMPORT void MESHErrorBlockNumNotOnRecvProcess();
//Misc
#define MESHShapeSpaceHandle int
MESHShapeSpaceHandle MESHregisterShapeSpace(char *,int,double *);
void MESHfreeShapeSpace(MESHShapeSpaceHandle);
void MESHaddtoShapeSpace(MESHShapeSpaceHandle,void * ,double *);
void * MESHgetdatafromShapeSpace(MESHShapeSpaceHandle, double *);
DLLIMPORT void MESHdisplaytime();
DLLIMPORT void MESHrecordtime();
DLLIMPORT int MESHcheckstartup(int,int,int,char **);
DLLIMPORT void MESHmemcpyandtranspose(void *,void * ,int , int ,int);
DLLIMPORT void * MESHtranposefn(void *,int,int,int);
DLLIMPORT void MESHcreateMPIComm(int ,int [],MPI_Comm * );
DLLIMPORT void MESHinplacesquaretranspose(void *,int, int);
DLLIMPORT void MESHTransposeWithTempVar(void * ,int ,int ,int );
DLLIMPORT double MESHbshiftl(int,int);
DLLIMPORT double MESHbshiftr(int,int);
DLLIMPORT void MESHdisplayhighresepoch();
DLLIMPORT void MESHCopyArray(void *,void *, int);
DLLIMPORT void MESHbitreverse(void *, int);
//IO
DLLIMPORT FILE * MESHopenfile(void *,int,char *);
DLLIMPORT void MESHclosefile(FILE * );
DLLIMPORT void MESHwritetofile(FILE * , const char *, ...);
DLLIMPORT void MESHwritechartofile(FILE *, int);
DLLIMPORT char MESHreadchar(FILE *);
DLLIMPORT char * MESHreadline(FILE *);
// Comm error
DLLIMPORT void MESHsetUpCommErrHandler(MPI_Comm);
DLLIMPORT void MESHsetErrAction(int , int);
DLLIMPORT int MESHcommerror;
// String
DLLIMPORT int MESHconverttoint(char *);
DLLIMPORT char * MESHconverttostring(float, int);
DLLIMPORT int MESHstrLen(char *);
DLLIMPORT char * MESHsubstring(char *,int,int);
DLLIMPORT void MESHstrcpy(char ** a,char *b);
DLLIMPORT char * MESHdeclareString();
DLLIMPORT char MESHcharat(char * ,int);
DLLIMPORT int MESHstrequals(char * ,char * );
DLLIMPORT char * MESHstrcat(char * ,char * );
DLLIMPORT void MESHstrinput(char **);
DLLIMPORT char * MESHstrlowercase(char * );
DLLIMPORT char * MESHstruppercase(char * );
// Char
DLLIMPORT char MESHlowercase(char);
DLLIMPORT char MESHuppercase(char);
// System calls
void MESHregisterreference(char * varname,char * keyword,void * dataptr);
void * MESHgetreference(char * varname, char * keyword);
void MESHremovevariablefromreference(char * varname);
void MESHtransferreferencelist(char *,char *);
int MESHgetPID();
DLLIMPORT void MESH_Init(int,int);
DLLIMPORT void MESHoscli(char *);
DLLIMPORT void MESHgarbagecollect();
DLLIMPORT void MESHkillgarbage();
DLLIMPORT void MESHregistergarbage(void *,int);
// Reference record
void MESHreferencerecordquicksortascending(void **,size_t,size_t,size_t);
void MESHreferencerecordquicksortdescending(void *,size_t,size_t,size_t);
void MESHrefrecordcreate(int,char * ,void * );
void MESHrefrecordlinkrelativeaddresses(void *);
void * MESHrefrecordallignmemory(void *);
void * MESHrefrecordgetabstracttable(void *);
int MESHrefrecordgetabstablesize(void *);
int MESHrefrecordgettotmemsize(void *);
void MESHrefrecorddisposetable(void *);
void MESHrefrecordconstructtablefromabstable(void *,void *);
void MESHrefrecordtableaddrow(void *,int ,void *);
void MESHrefrecordaddrowentry(int,char *,void *,void *);
int MESHrefrecordgetrownumber(void *,void *);
int MESHrefrecordneedtoanalysefurther(int,char *,void *);
void * MESHrefrecordgetrowentry(int ,char *,void *);
void MESHrefrecordremoverow(void *,void *);
int MESHrefrecordneedtolinkfurther(int,char *,void *);
#define MESH_COMM_ERR_UNKNOWN         -23      /* Invalid rank */
