#include "mpi.h"
#include <stdio.h>

#ifndef DLLIMPORT
	#define DLLIMPORT	
#endif

DLLIMPORT double MESHsqrt(double);
DLLIMPORT double MESHPI();
DLLIMPORT double MESHsqr(double);
DLLIMPORT float MESHrandom(int, int);
DLLIMPORT int MESHlog(int);
DLLIMPORT int MESHgetprime(int);
DLLIMPORT double MESHfloor(double);
DLLIMPORT int MESHmod(int,int);
//Async
DLLIMPORT void MESHRegisterAsyncRequest(MPI_Request *,char *);
DLLIMPORT void MESHRegisterAsyncRequestAndMemCpy(MPI_Request *,char *,void *, void *,int,char *);
DLLIMPORT void MESHSyncWithVariableName(char *);
DLLIMPORT void MESHinformdeadvariable(char *);
DLLIMPORT void MESHSyncAll();
//Exceptions
DLLIMPORT void MESHErrordivideByZero();
DLLIMPORT void MESHErrorMallocNull();
DLLIMPORT void MESHErrorMemoryBlock();
DLLIMPORT int MESHErrorIllegalBlockNumber();
DLLIMPORT void MESHErrorBlockNumNotOnRecvProcess();
//Misc
DLLIMPORT void MESHdisplaytime();
DLLIMPORT void MESHrecordtime();
DLLIMPORT int MESHcheckstartup(int,int,int,char **);
DLLIMPORT void * MESHtranposefn(void *,int,int,int);
DLLIMPORT void MESHcreateMPIComm(int ,int [],MPI_Comm * );
DLLIMPORT void MESHinplacesquaretranspose(void *,int, int);
DLLIMPORT void MESHTransposeWithTempVar(void * ,int ,int ,int );
DLLIMPORT double MESHbshiftl(int,int);
DLLIMPORT double MESHbshiftr(int,int);
DLLIMPORT void MESHdisplayhighresepoch();
DLLIMPORT void MESHCopyArray(void *,void *, int);
typedef struct {float r,i;} mycomplex; 
DLLIMPORT void MESHbitreverse(mycomplex *, int);
//IO
DLLIMPORT FILE * MESHopenfile(void *,int,char *);
DLLIMPORT void MESHclosefile(FILE * );
DLLIMPORT void MESHwritetofile(FILE * , const char *, ...);
DLLIMPORT void MESHwritechartofile(FILE *, int);
DLLIMPORT char MESHreadchar(FILE *);
DLLIMPORT char * MESHreadline(FILE *);
// Comm error
DLLIMPORT void MESHsetUpCommErrHandler(MPI_Comm);
DLLIMPORT void MESHsetErrAction(int , int);
DLLIMPORT int MESHcommerror;
// String
DLLIMPORT int MESHconverttoint(char *);
DLLIMPORT char * MESHconverttostring(float, int);
DLLIMPORT int MESHstrLen(char *);
DLLIMPORT char * MESHsubstring(char *,int,int);
DLLIMPORT void MESHstrcpy(char ** a,char *b);
DLLIMPORT char * MESHdeclareString();
DLLIMPORT char MESHcharat(char * ,int);
DLLIMPORT int MESHstrequals(char * ,char * );
DLLIMPORT char * MESHstrcat(char * ,char * );
DLLIMPORT void MESHstrinput(char **);
DLLIMPORT char * MESHstrlowercase(char * );
DLLIMPORT char * MESHstruppercase(char * );
// Char
DLLIMPORT char MESHlowercase(char);
DLLIMPORT char MESHuppercase(char);
// System calls
DLLIMPORT void MESH_Init(int,int);
DLLIMPORT void MESHoscli(char *);
DLLIMPORT void MESHgarbagecollect();
DLLIMPORT void MESHkillgarbage();
DLLIMPORT void MESHregistergarbage(void *,int);
#define MESH_COMM_ERR_UNKNOWN         -23      /* Invalid rank */
