#include "mpi.h"
#include "buildmesham.h"
#include <stdlib.h>
#include <stdio.h>
#include "garbage.h"
/*
	Very simple garbage collector - used at the moment primarily for the string handling fns, where memory might get dereferenced and we dont wish to cause a memory leak
	
	Also extended to hold partitioned temp data
*/
typedef struct llist {struct llist * prev;void * ptr; struct llist * next; int protectionmode;} List;
List * thehead=NULL;

void addgarbage(void *pt, int protectionlevel)
{
		List * newthehead=malloc(sizeof(List));
		newthehead->ptr=pt;
		newthehead->protectionmode=protectionlevel;
		newthehead->next=thehead;
		if (thehead != NULL)
		{
			thehead->prev=newthehead;
		}
		thehead=newthehead;
}
void registergarbage(void * pt)
{
	addgarbage(pt,0);
}

void cleargarbage(int protect)
{	
	if (thehead==NULL) return;
	List * cthehead=thehead;
	List * lastpt=NULL;
	List * newthehead=NULL;
	while (cthehead !=NULL)
	{
		if (cthehead->protectionmode >= protect)
		{
			free(cthehead->ptr);
			List * oldnode=cthehead;
			cthehead=cthehead->next;	
			free(oldnode);
		} else {
			if (lastpt != NULL)
			{
				lastpt->next=cthehead;
				cthehead->prev=lastpt;
			} else {
				newthehead=cthehead;
			}
			lastpt=cthehead;
			cthehead=cthehead->next;	
		}				
	}
	thehead=newthehead;
}

int sizeofgarbage()
{
	if (thehead==NULL) return 0;
	int i=1;
	List * cthehead=thehead;
	while (cthehead->next !=NULL)
	{
		i++;
		cthehead=cthehead->next;
	}
	return i;
}
