#include "mpi.h"
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <time.h>
#include "buildmesham.h"
#include "timeofday.h"

struct timeval times[10];
int nodes=0;

DLLIMPORT void MESHdisplaytime()
{
	int myid;
	MPI_Comm_rank(MPI_COMM_WORLD,&myid);
	printf("PID:%d ",myid);
	float dt[nodes + 1];
	int i;
	for(i=1;i<=nodes;i++)
	{
      dt[i] = ((float) ((times[i].tv_sec - times[i - 1].tv_sec) * 1000000 + times[i].tv_usec - times[i - 1].tv_usec)) / 1000000.0;
     }
     float sum;
      for(i=1;i<nodes;i++)
      {
      	printf("%2.6f   ", dt[i]);
      	sum=sum + dt[i];
      }
	printf("%2.6f \n",sum);  
}

DLLIMPORT void MESHrecordtime()
{
	gettimeofday(&times[nodes], (struct timeval*)0);	
	nodes++;
}
