#include "mpi.h"
#include <pthread.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "buildmesham.h"
#define REQUESTONLY 0
#define REQUESTANDMEMCPY 1
typedef struct llist {struct llist * prev;MPI_Request * asyncrequest; struct llist * next; char * varname; int mode; void * cpyinto ; void *src; int bytes;char * cpyintoname;pthread_t * copythread;} List;
List * head=NULL;
int getNumAllRequests();
int getNumRequestsPerVariable(char *);
void removeAllRequests();
void removeRequestsOfVars(char *);
void fillRequestArrayForAll(MPI_Request [], int);
void fillRequestArrayForVar(MPI_Request [], char *,int);
void honourMemCpyForVar(char *);
void honourMemCpyForAll();
void *asyncupdatememthread(List *);
int suspendthreads=0;
void *asyncupdatememthread(List * mydetails)
{
	int testr=0;
	while(testr==0){if (suspendthreads==0) {MPI_Test(mydetails->asyncrequest,&testr,MPI_STATUS_IGNORE);}}
	while (suspendthreads==1) {}
	if (mydetails->mode==REQUESTANDMEMCPY)
	{						
		memcpy(mydetails->cpyinto,mydetails->src,mydetails->bytes);
		free(mydetails->cpyintoname);
		free(mydetails->copythread);
	} 			
	removeRequestsOfVars(mydetails->varname);	// now remove the sync request as sync has been performed - not needed
}

DLLIMPORT void MESHRegisterAsyncRequest(MPI_Request * req,char * varname)
{
	List * newitem=malloc(sizeof(List));
	//need to issue malloc as the memory passed here is on the stack frame
	MPI_Request * newreq=malloc(sizeof(MPI_Request));
	memcpy(newreq,req,sizeof(MPI_Request));
	newitem->asyncrequest=newreq;
	
	char * newvarname=malloc(sizeof(char) * strlen(varname));
	strcpy(newvarname,varname);
	newitem->varname=newvarname;
	newitem->prev=NULL;
	newitem->next=NULL;
	newitem->mode=REQUESTONLY;	
	if (head==NULL)
	{
		head=newitem;
	} else {
		newitem->next=head;
		head->prev=newitem;
		head=newitem;
	}
}

DLLIMPORT void MESHinformdeadvariable(char * varname)
{
	// if a variable goes out of scope do not memcpy or update it with a sync
	suspendthreads=1; 
	List * ch=head;
	while (ch != NULL)
	{	
		if (ch->mode==REQUESTANDMEMCPY)
		{
			if (strcmp(ch->cpyintoname,varname)==0) 
			{
				ch->mode=REQUESTONLY;
				free(ch->cpyintoname);				
				free(ch->copythread);
			}			
		}
		ch=ch->next;
	}
	suspendthreads=0;
}

DLLIMPORT void MESHRegisterAsyncRequestAndMemCpy(MPI_Request * req,char * varname,void * cpyinto, void * src,int elements,char * cpyintoname)
{
	MESHRegisterAsyncRequest(req,varname);
	// new node is now the head;
	head->mode=REQUESTANDMEMCPY;
	head->cpyinto=cpyinto;
	head->src=src;
	head->bytes=elements;
	char * newvarname=malloc(sizeof(char) * strlen(cpyintoname));
	strcpy(newvarname,cpyintoname);
	head->cpyintoname=newvarname;
	pthread_t * thread=malloc(sizeof(pthread_t));
	head->copythread=thread;
	int rc=pthread_create(thread, NULL, asyncupdatememthread, head);
	if (rc)
	{
         printf("None fatal error: Can not create thread for %s variable update, error id: %d\n",cpyintoname,rc);
    }
}

DLLIMPORT void MESHSyncWithVariableName(char * varname)
{
	if (head==NULL) return ;
	int numberofrequests=getNumRequestsPerVariable(varname);	
	if (numberofrequests==0) return ;
	suspendthreads=1;
	MPI_Request requestholder[numberofrequests];
	fillRequestArrayForVar(requestholder,varname,numberofrequests);	
	MPI_Waitall(numberofrequests,requestholder,MPI_STATUSES_IGNORE);	
	honourMemCpyForVar(varname);
	removeRequestsOfVars(varname);
	suspendthreads=0;	
}

DLLIMPORT void MESHSyncAll()
{
	if (head==NULL) return ;
	int numberofrequests=getNumAllRequests();
	if (numberofrequests==0) return ;
	suspendthreads=1;
	MPI_Request requestholder[numberofrequests];
	fillRequestArrayForAll(requestholder,numberofrequests);
	MPI_Waitall(numberofrequests,requestholder,MPI_STATUSES_IGNORE);
	honourMemCpyForAll();
	removeAllRequests();	
	suspendthreads=0;
}

void honourMemCpyForAll()
{
	List * ch=head;
	while (ch != NULL)
	{		
			if (ch->mode==REQUESTANDMEMCPY)
			{			
				memcpy(ch->cpyinto,ch->src,ch->bytes);		
				if (ch->mode==REQUESTANDMEMCPY)
				{
					free(ch->cpyintoname);
					pthread_cancel(*ch->copythread);	
					free(ch->copythread);
				}					
			} 									
		ch=ch->next;
	}
}

void honourMemCpyForVar(char * varname)
{
	List * ch=head;
	while (ch != NULL)
	{
		if (strcmp(ch->varname,varname)==0)
		{		
			if (ch->mode==REQUESTANDMEMCPY)
			{					
				memcpy(ch->cpyinto,ch->src,ch->bytes);		
				if (ch->mode==REQUESTANDMEMCPY)
				{
					free(ch->cpyintoname);
					pthread_cancel(*ch->copythread);	
					free(ch->copythread);
				}	
			} 								
		}
		ch=ch->next;
	}
}

void removeAllRequests()
{
	List * ch=head;
	while (ch != NULL)
	{
		free(ch->asyncrequest);
		free(ch->varname);		
		List * oldch=ch;
		ch=ch->next;
		free(oldch);
	}
	head=NULL;
}

void removeRequestsOfVars(char * varname)
{
	List * ch=head;
	while (ch != NULL)
	{
		if (strcmp(ch->varname,varname)==0) 
		{
			free(ch->asyncrequest);
			free(ch->varname);					
			if ((ch->prev) != NULL) {(ch->prev)->next=ch->next;}			
			if ((ch->next) != NULL) {(ch->next)->prev=ch->prev;}			
			if (ch==head) {head=ch->next;}
			List * oldch=ch;			
			ch=ch->next;
			free(oldch);			
		}	else {
			ch=ch->next;
		}		
	}
}

void fillRequestArrayForAll(MPI_Request requestholder[], int numberofrequests)
{
	int index=0;
	List * ch=head;
	while (ch != NULL)
	{
		memcpy(&requestholder[index],ch->asyncrequest,sizeof(MPI_Request));		
		index++;
		ch=ch->next;
	}
	if (numberofrequests != index)
	{
		fprintf(stderr,"Async missmatch error!\n");
	}
}	

void fillRequestArrayForVar(MPI_Request requestholder[], char * varname,int numberofrequests)
{
	int index=0;
	List * ch=head;
	while (ch != NULL)
	{
		if (strcmp(ch->varname,varname)==0)
		{			
			memcpy(&requestholder[index],ch->asyncrequest,sizeof(MPI_Request));			
			index++;
		}
		ch=ch->next;
	}
	if (numberofrequests != index)
	{
		fprintf(stderr,"Async missmatch error!\n");
	}
}	

int getNumAllRequests()
{
	int req=0;
	List * ch=head;
	while (ch != NULL)
	{
		req++;
		ch=ch->next;
	}
	return req;
}

int getNumRequestsPerVariable(char * varname)
{
	int req=0;
	List * ch=head;
	while (ch != NULL)
	{
		if (strcmp(ch->varname,varname)==0) req++;
		ch=ch->next;
	}
	return req;
}
