#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include "mpi.h"
#include "buildmesham.h"

void fillprimes();

int * primes;
int seeded=0;
DLLIMPORT double MESHsqrt(double x)
{
	return sqrt(x);
}

DLLIMPORT double MESHPI()
{
	return 3.141592;
}

DLLIMPORT double MESHsqr(double x)
{
	return (x * x);
}


DLLIMPORT float MESHrandom(int from, int to)
{
	if (seeded==0)	// seed random number generator
	{
		int myrank;
		MPI_Comm_rank(MPI_COMM_WORLD, &myrank);
		if (myrank==0) MPI_Comm_size(MPI_COMM_WORLD,&myrank);		
		srand((unsigned int)time((time_t *)NULL) * myrank);
		seeded=1;
	}
	float num=rand();	
	if ((to - from)==1)
	{ 
		num= (float) rand() / (float) 0x7fffffff;
	} else {
		return from + rand() / (RAND_MAX / ((to) - from + 1) + 1);
	}
	//printf("%f\n",num);
	return num;
}

DLLIMPORT int MESHlog(int x)
{
	int i;
	 int nx = (int) x;
   	int logn = 0;
   while(( nx >>= 1) > 0)
      logn++;
   nx = 1;
   for (i=0; i<logn; i++)
      nx = nx*2;
      
      return logn;
}

DLLIMPORT int MESHgetprime(int x)
{
	if (primes==NULL)
	{
		fillprimes();
	}
	return primes[x];
}

DLLIMPORT double MESHfloor(double x)
{
	return floor(x);
}

DLLIMPORT int MESHmod(int x, int y)
{
	return (x % y);
}

void fillprimes()
{
	// uses the Sieve Of Erastosthenes
	int size=513719;	// up to 100
	int i;
	int flags[size];
	double limit=sqrt(size);
	
	primes=(int *) malloc(sizeof(int) * size);
	
	for (i=2;i< size;i++)
	{
		flags[i]=1;
	}
	
	int j=2;
	for (i=j+j;i<size;i=i+j)
	{
		flags[i]=0;	// cross out multiples of two
	}
	
	for (j=3;j<=limit;j=j+2)
	{
		if (flags[j]==1)
		{
			for (i=j+j;i<size;i=i+j)
			{
				flags[i]=0;	// cross out multiples of odd numbers
			}
		}
	}
	
	int primec=0;	
	// now build up prime list from the numbers left
	for (i=2;i<size;i++)
	{
		if (flags[i]==1)
		{
			primes[primec]=i;
			primec++;
		}
	}
}
