#include "mpi.h"
#include "buildmesham.h"
#include <stdio.h>
#include <stdlib.h>
//void (*fpointer[20])(void);
//void (*unknown)(void);
int fpointer[20];
int unknown=0;
void commerrorhandler(MPI_Comm * , int *);
void commerrorhandler(MPI_Comm * commgrop, int  * errcod)
{
	int ecode;
	MPI_Error_class(*errcod,&ecode);
	if (unknown==0)
	{
		if (fpointer[ecode]==1)
		{			
			MESHcommerror=1;
		} else {
			int unknown=1;
			fprintf(stderr,"Run Time Error - ");		
			if (ecode == MPI_ERR_RANK) {fprintf(stderr,"Invalid Rank");unknown=0;}
			if (ecode == MPI_ERR_ROOT) {fprintf(stderr,"Invalid Root");unknown=0;}
			if (ecode == MPI_ERR_BUFFER) {fprintf(stderr,"Invalid Buffer");unknown=0;}
			if (ecode == MPI_ERR_COUNT) {fprintf(stderr,"Invalid Count");unknown=0;}
			if (ecode == MPI_ERR_TYPE) {fprintf(stderr,"Invalid Type");unknown=0;}
			if (ecode == MPI_ERR_TAG) {fprintf(stderr,"Invalid Tag");unknown=0;}
			if (ecode == MPI_ERR_COMM) {fprintf(stderr,"Invalid Communication Group");unknown=0;}
			if (ecode == MPI_ERR_TRUNCATE) {fprintf(stderr,"Message truncated at receiver");unknown=0;}
			if (ecode == MPI_ERR_GROUP) {fprintf(stderr,"Invalid Communication Group");unknown=0;}
			if (ecode == MPI_ERR_OP) {fprintf(stderr,"Invalid Operation");unknown=0;}
			if (ecode == MPI_ERR_ARG) {fprintf(stderr,"Invalid Argument");unknown=0;}
			if (unknown==1) {fprintf(stderr,"Unknown Error");}
			fprintf(stderr," in Communication\n");
			//abort();
			MPI_Abort(*commgrop, ecode);
		}
	} else {	
		MESHcommerror=1;
	}
}
DLLIMPORT void MESHsetUpCommErrHandler(MPI_Comm comm)
{
	MPI_Errhandler errhandler;
	MPI_Comm_create_errhandler(commerrorhandler,&errhandler);
	MPI_Comm_set_errhandler(comm, errhandler);
}

DLLIMPORT void MESHsetErrAction(int classcode, int co)
{
	if (classcode > 0)
	{
		// need a better way!
		fpointer[classcode]=co;
	} else {
		if (classcode==MESH_COMM_ERR_UNKNOWN)
		{
			// unknown
			unknown=co;
		}
	}
}

