%{
#include <stdio.h>
#include <string.h>

yyerror(s)
char *s;
{
  fprintf(stderr, "%s\n",s);
}

 
int yywrap()
{
        return 1;
} 
  
main()
{
        yyparse();
} 
%}

%union 
{
        int number;
        char *string;
}

%token IF EQUALS FOR TO DEFINE PRINT PLING WHILE PRINTLN SQBRACEO SQBRACEC PCENT PROCESSORS END ELSE NOTHING PROC CALL SYNC INPUT DOLLAR ISYNC MODEL EREW CREW ERCW CRCW AMP HASH

%token <string> NUMBER
%token <string> OPERATOR
%token <string> IDENTIFIER
%token <string> BRACE
%token <string> COMPARITOR

%type <string> arrayorvar
%type <string> num


%%
commands: /* empty */
        | commands command
        ;

command:
        assignment
	|
	comparator
	|
	sytantical
	|
	loop
	|
	defin
	|
	maths
	|
	display	
	|
	while
	|
	numberofprocessors
	|
	end
	|
	syncronise
	|
	procedure
	|
	input
	|
	memorymodel
        ;

procedure:
	PROC IDENTIFIER
	{
		printf ("proc\n%s\n",$2);
	}
	|
	CALL IDENTIFIER
	{		
		printf ("call\n%s\n",$2);
	}
	;

memorymodel:
	MODEL EQUALS EREW
	{
		printf("modelerew\n");
	}
	|
	MODEL EQUALS CREW
	{
		printf("modelcrew\n");
	}
	|
	MODEL EQUALS ERCW
	{
		printf("modelercw\n");
	}
	|
	MODEL EQUALS CRCW  
	{
		printf("modelcrcw\n");
	}
	|
	CRCW EQUALS NUMBER
	{
		printf("crcw\n%s\n",$3);
	};

input:
	INPUT IDENTIFIER DOLLAR
	{
		printf("inputs\n%s\n",$2);
	}
	|
	INPUT IDENTIFIER
	{
		printf("input\n%s\n",$2);
	}
	;

syncronise:
	NOTHING
	{
		printf("nothing\n");
	}
	|
	SYNC
	{
		printf("sync\n");
	}
	|
	ISYNC
	{
		printf("isync\n");
	};

end:
	END
	{
		printf("end\n");
	}
	;

display:
	PRINT arrayorvar
	{
		printf("print\n%s\n",$2);
	}
	|
	PRINTLN arrayorvar
	{
		printf("println\n%s\n",$2);
	}
	;

maths:
	arrayorvar OPERATOR OPERATOR
	{
		printf(":=ion\n%s\n%s\n%s\n1\n",$1,$1,$2);
	};

assignment: 
        arrayorvar EQUALS arrayorvar
        {
                printf(":=\n%s\n%s\n",$1,$3);
        }
	|
	arrayorvar AMP EQUALS arrayorvar
	{
		printf("&=\n%s\n%s\n",$1,$4);
	}
	|
	arrayorvar HASH EQUALS arrayorvar
	{
		printf("#=\n%s\n%s\n",$1,$4);
	}
	|
	arrayorvar EQUALS num
	{
		printf(":=n\n%s\n%s\n",$1,$3);
	}	
	|
	arrayorvar EQUALS num OPERATOR num
	{
		printf(":=non\n%s\n%s\n%s\n%s\n",$1,$3,$4,$5);
	}
	|	
	arrayorvar EQUALS arrayorvar OPERATOR num
	{
		printf(":=ion\n%s\n%s\n%s\n%s\n",$1,$3,$4,$5);
	}
	|	
	arrayorvar EQUALS num OPERATOR arrayorvar
	{
		printf(":=ion\n%s\n%s\n%s\n%s\n",$1,$5,$4,$3);
	}
	|	
	arrayorvar EQUALS arrayorvar OPERATOR arrayorvar
	{
		printf(":=ioi\n%s\n%s\n%s\n%s\n",$1,$3,$4,$5);
	}	
        ;
	
comparator:
	IF arrayorvar COMPARITOR arrayorvar
	{
		printf("if\n%s\n%s\n%s\n",$3,$2,$4);
	}
	|
	IF arrayorvar COMPARITOR num
	{
		printf("ifn\n%s\n%s\n%s\n",$3,$2,$4);
	}
	|		
	IF num COMPARITOR arrayorvar
	{
		printf("ifnn\n%s\n%s\n%s\n",$3,$2,$4);
	}		
	;

while:
	WHILE arrayorvar COMPARITOR arrayorvar
	{
		printf ("while\n%s\n%s\n%s\n",$3,$2,$4);
	}
	|
	WHILE num COMPARITOR arrayorvar
	{
		printf ("whilen\n%s\n%s\n%s\n",$3,$2,$4);
	}
	|
	WHILE arrayorvar COMPARITOR num
	{
		printf ("whilenn\n%s\n%s\n%s\n",$3,$2,$4);
	}
	;

sytantical:
	BRACE
	{
		printf("%s\n",$1);
	}
	|
	BRACE ELSE BRACE
	{
		printf("%selse%s\n",$1,$3);
	}
	;

numberofprocessors:
	PROCESSORS EQUALS num
	{
		printf("processors\n%s\n",$3);
	}
	;

loop:
	FOR arrayorvar EQUALS num TO num
	{
		printf("for\n%s\n=\n%s\nto\n%s\n",$2,$4,$6);
	}
	|
	FOR arrayorvar EQUALS num TO arrayorvar
	{
		printf("fori\n%s\n=\n%s\nto\n%s\n",$2,$4,$6);
	}
	;

defin:
	DEFINE IDENTIFIER SQBRACEO num SQBRACEC
	{
		printf("def\n%s\n%s\n",$2,$4);
	}
	|
	DEFINE IDENTIFIER SQBRACEO num SQBRACEC SQBRACEO num SQBRACEC
	{
		printf("defr\n%s\n%s\n%s\n",$2,$4,$7);
	}
	;

arrayorvar:
	IDENTIFIER
	{
		$$=$1;
	}
	|
	IDENTIFIER PCENT
	{
		$1=strncat($1,"%",1);
		$$=strncat($1,"pid",(strlen("pid")));
	}
	|
	IDENTIFIER SQBRACEO num SQBRACEC
	{
		
		$$=strncat($1,$3,(strlen($3)));
	}
	|
	IDENTIFIER SQBRACEO IDENTIFIER SQBRACEC
	{
		$1=strncat($1,"[",1);
		$$=strncat($1,$3,(strlen($3)));
	}			
	|
	IDENTIFIER SQBRACEO IDENTIFIER SQBRACEO IDENTIFIER SQBRACEC SQBRACEC
	{
		$1=strncat($1,"[",1);
		$3=strncat($3,"[",1);
		$$=strncat($1,$3,(strlen($3)));		
		$$=strncat($$,$5,(strlen($5)));		
	}
	|
	IDENTIFIER SQBRACEO IDENTIFIER PCENT SQBRACEC
	{
		$1=strncat($1,"[",1);
		$3=strncat($3,"%",1);
		$$=strncat($1,$3,(strlen($3)));		
		$$=strncat($$,"pid",(strlen("pid")));		
	}	
	|
	IDENTIFIER SQBRACEO IDENTIFIER SQBRACEO num SQBRACEC SQBRACEC
	{
		$1=strncat($1,"[",1);
		$$=strncat($1,$3,(strlen($3)));		
		$$=strncat($$,$5,(strlen($5)));		
	}
	|
	IDENTIFIER SQBRACEO IDENTIFIER SQBRACEC SQBRACEO IDENTIFIER SQBRACEC
	{
		$1=strncat($1,"",1);
		$$=strncat($1,$3,(strlen($3)));
		$$=strncat($$,"",1);
		$$=strncat($$,$6,(strlen($6)));
	}
	|
	IDENTIFIER SQBRACEO IDENTIFIER SQBRACEC SQBRACEO IDENTIFIER PCENT SQBRACEC
	{
		$1=strncat($1,"",1);
		$$=strncat($1,$3,(strlen($3)));
		$$=strncat($$,"",1);		
		$6=strncat($6,"%",1);
		$$=strncat($$,$6,(strlen($6)));
		$$=strncat($$,"pid",(strlen("pid")));
	}
	|
	IDENTIFIER SQBRACEO IDENTIFIER PCENT SQBRACEC SQBRACEO IDENTIFIER PCENT SQBRACEC
	{
		$1=strncat($1,"",1);
		$3=strncat($3,"%",1);
		$$=strncat($1,$3,(strlen($3)));		
		$$=strncat($$,"pid",(strlen("pid")));
		$$=strncat($$,"",1);		
		$7=strncat($7,"%",1);
		$$=strncat($$,$7,(strlen($7)));
		$$=strncat($$,"pid",(strlen("pid")));
	}		
	;

num:
	NUMBER
	{
		$$=$1
	}
	|
	OPERATOR NUMBER
	{
		$$=strncat($1,$2,(strlen($2)));
	}
	;
%%


