%{
#include <stdio.h>
#include "example4_tab.h"
#include <math.h>
%}

ID       [a-z][a-z0-9]*

%%
[0-9]+                  	yylval.string=strdup(yytext); return NUMBER;

if				return IF;
model				return MODEL;
erew				return EREW;
crew				return CREW;
ercw				return ERCW;
crcw				return CRCW;
input				return INPUT;
isync				return ISYNC;
sync				return SYNC;
processors			return PROCESSORS;
procedure			return PROC;
proc				return PROC;
call				return CALL;
for 				return FOR;
to				return TO;
def				return DEFINE;
print				return PRINT;
println				return PRINTLN;
else				return ELSE;
while				return WHILE;
end				return END;
nothing				return NOTHING;
{ID}				yylval.string=strdup(yytext); return IDENTIFIER;
"+"|"-"|"/"|"*"|"."             yylval.string=strdup(yytext); return OPERATOR;
"!"				return PLING;
"$"				return DOLLAR;
"&"				return AMP;
"#"				return HASH;
"%"				return PCENT;
"="				return EQUALS;
"=="|"!="|"<"|">"|">="|"<="	yylval.string=strdup(yytext); return COMPARITOR;
"["				return SQBRACEO;
"]"				return SQBRACEC;
"{"|"}"				yylval.string=strdup(yytext);return BRACE;
"//".*$			/* ignore comments */;
\n                      /* ignore end of line */;
[ \t]+                  /* ignore whitespace */;
["("|")"]+                  /* ignore brackets */;
%%
