import java.util.*;
public class main
{
    protected ArrayList filecontents;    
    protected ArrayList variables;
    protected ArrayList dataarea;
    protected theassembly theasm;
    protected ArrayList bracehighlight;
    protected ArrayList usedbclose;
    protected ArrayList proc;
    protected ArrayList pointers;
    protected ArrayList elsebracecounter;
    protected ArrayList twodarrayname;
    protected ArrayList twodarrayfirstsize;
    protected ArrayList twodarraysecondsize;
    protected int openbrace;
    protected int bracecounter;
    protected int inputcounter;
    protected int returnpoints;
    protected int numberprocessors;
    protected int linenumber;
    protected boolean iselse;
    protected boolean isif;
    protected boolean isaproc;
    protected boolean inproc;
    protected boolean isintwod;
    protected int memmodel;
    protected int crcwmodel;
    protected String procname;
    protected highlevel hlevel;
    protected highlevel prochlevel;
    protected variable vars;
    
    public static void main(String args[])
    {
        main me=new main(args[0]);
    }
    
    public main(String filename)
    {
        filecontents=file.readfile(filename);
        variables=new ArrayList();
        elsebracecounter=new ArrayList();
        usedbclose=new ArrayList();
        proc=new ArrayList();
        dataarea=new ArrayList();
        twodarrayname=new ArrayList();
        twodarrayfirstsize=new ArrayList();
        twodarraysecondsize=new ArrayList();
        pointers=new ArrayList();
        theasm=new theassembly(this);
        theasm.add(".set noat\n");
        isintwod=false;
        theasm.reset();
        bracehighlight=new ArrayList();
        hlevel=new highlevel();
        prochlevel=new highlevel();
        vars=new variable();
        openbrace=1;
        bracecounter=1;
        inputcounter=1;
        isaproc=false;
        returnpoints=1;       
        numberprocessors=0;
        memmodel=0;
        crcwmodel=1;
        linenumber=0;
        iselse=false;
        inproc=false;
        isif=false;

        procname=new String("");
        compile();
    }
    
    public void compile()
    {
        Iterator i=filecontents.iterator();
        while (i.hasNext())
        {
            String checkstring=(String) i.next();
            
            if (checkstring.equals("{"))
            {
                linenumber++;
                if (isaproc)
                {         
                    inproc=true;
                    theasm.add("procopenbrace"+procname+":\n");
                    openproc();
                    procedure theprocedure=new procedure(procname,openbrace);
                    proc.add(theprocedure);                    
                    addhlevel("{");
                } else {
                theasm.add("openbrace"+openbrace+":\n");
                addhlevel("{",0);
                }
                openbrace++;
                bracecounter=openbrace;
                
                isaproc=false;
            }
            
            if (checkstring.equals("}"))
            {
                linenumber++;
                bracecounter--;
                boolean dontadd=false;
                while (checkclosebrace(bracecounter))
                {
                    bracecounter--;
                }
                int retp=checkbracepoint(bracecounter);
                if (retp !=0)
                {
                    theasm.add("nop\n");
                    theasm.add("j forloopreturn"+retp+"\n");
                    addhlevel("}");
                    dontadd=true;
                }
                iselse=testelse(bracecounter);
                if (iselse)
                {
                    theasm.add("closeelsebrace"+(bracecounter)+":\n");
                    addhlevel("}",0);
                    iselse=false;
                } else {
                    String aproc=checkproc(bracecounter);
                    if (! aproc.equals(""))
                    {
                        doendofproc(aproc);
                        theasm.add("procclosebrace"+aproc+":\n");
                        addhlevel("}");
                        inproc=false;
                    } else {
                        theasm.add("closebrace"+(bracecounter)+":\n");
                        if (!dontadd){addhlevel("}",0);}                        
                    }
                }
                usedbclose.add(new Integer(bracecounter));
                isif=false;
            }
            
            if (checkstring.equals("}else{"))
            {
                linenumber++;
                //if (!isif) {error("Else statement used without being closed in an if conditional");}                
                int theelsebrace=bracecounter;
                theelsebrace--;
                while (checkclosebrace(theelsebrace))
                {
                    theelsebrace--;
                }                
                theasm.add("nop\n");
                theasm.add("j closeelsebrace"+theelsebrace+"\n");                
                theasm.add("closebrace"+(theelsebrace)+":\n");
                addhlevel("{");
                elsebracecounter.add(new Integer(theelsebrace));
            }
            
            if (checkstring.equals("proc"))
            {
                isaproc=true;   
                String varname=(String) i.next();
                procname=varname;
                addhlevel("proc "+varname);
            }
            
            if (checkstring.equals("call"))
            { 
                String varname=(String) i.next();
                theasm.add("nop\n");
                theasm.add("jal procopenbrace"+varname+"\n");
                                    addhlevel("call" +parsevariable(varname));
            }
            
            if (checkstring.equals("nothing"))
            {
                linenumber++;
                theasm.add("nop\n");
                                    addhlevel("nothing");
            }
            
            if (checkstring.equals("end"))
            {
                linenumber++;
                theasm.add("li $2,01\n");
                theasm.add("syscall\n");
                                    addhlevel("end");
            }
            
            if (checkstring.equals("sync"))
            {
                linenumber++;
                theasm.add("li $2,11\n");
                theasm.add("syscall\n");
                                    addhlevel("sync");
            }
            
            if (checkstring.equals("modelerew"))
            {
                linenumber++;
                memmodel=1;
            }
            
            if (checkstring.equals("modelcrew"))
            {
                linenumber++;
                memmodel=2;
            }
            
            if (checkstring.equals("modelercw"))
            {
                linenumber++;
                memmodel=3;
            }
            
            if (checkstring.equals("modelcrcw"))
            {
                linenumber++;
                memmodel=4;
            }
            
            if (checkstring.equals("crcw"))
            {
                linenumber++;
                String varname=(String) i.next();  
                int themode=(new Integer(varname)).intValue();
                if (themode > 6 || themode <0)
                {
                    crcwmodel=1;
                } else {
                    crcwmodel=themode;   
                }
            }
            
            if (checkstring.equals("isync"))
            {
                linenumber++;
                theasm.add("li $2,12\n");
                theasm.add("syscall\n");
                                    addhlevel("isync");
            }
            
            if (checkstring.equals("input") || checkstring.equals("inputs"))
            {
                linenumber++;
                String varname=(String) i.next();
                if (checkstring.equals("input"))
                {
                    theasm.add("li $2,7\n");
                } else {
                    theasm.add("li $2,8\n");    
                }
                theasm.add("syscall\n");
                // get user input
                theasm.add("li $2,10\n");
                theasm.add("syscall\n");
                theasm.add("move $8,$2\n");   
                // get the size of input into register 8
                if (checkstring.equals("input"))
                {
                    if (!checkvariable(varname)){addtodef(varname);}
                    theasm.add("la $10,"+varname+"\n");
                } else {
                    theasm.add("la $10,"+varname+"1\n");
                }
                theasm.add("startofinput"+inputcounter+":\n");
                theasm.add("li $9,0\n");
                theasm.add("nop\n");
                theasm.add("beq $8,$9,endofinput"+inputcounter+"\n");
                theasm.add("li $2,9\n");
                theasm.add("syscall\n");
                theasm.add("sw $2,0($10)\n");
                theasm.add("li $9,4\n");
                theasm.add("addu $10,$10,$9\n");
                theasm.add("li $9,1\n");
                theasm.add("subu $8,$8,$9\n");
                theasm.add("nop\n");
                theasm.add("j startofinput"+inputcounter+"\n");
                theasm.add("endofinput"+inputcounter+":\n");
                inputcounter++;
                addhlevel("input "+parsevariable(varname));
            }
            
            if (checkstring.equals("print") || checkstring.equals("println"))
            {
                linenumber++;
                String varname=(String) i.next();

                if (!specialvariable(varname,4))
                {                  
                    if (checkarrayvarindex(varname))
                    {                
                        arrayindexviavariable(varname,4,5);
                    } else {
                        //if (!checkvariable(varname)){error("Error, "+varname+" not defined for use");} 
                        theasm.add("la $4,"+varname+"\n");
                        if (ispointer(varname))
                        {
                            theasm.add("lw $4,0($4)\n");
                        }
                    }
                    
                    theasm.add("lw $4,0($4)\n");
                }
                
                if (checkstring.equals("println"))
                {
                    theasm.add("li $2,05\n");
                    theasm.add("syscall\n");
                    addhlevel("println "+parsevariable(varname));
                } else {
                    theasm.add("li $2,02\n");
                    theasm.add("syscall\n");
                    addhlevel("print "+parsevariable(varname));
                }
                
                
            }
            
            if (checkstring.equals("def"))
            {
                 linenumber++;
                 String varone=(String) i.next();  
                 String numberone=(String) i.next();  
                 if (varone.equals("pid")){error("Error, can not write to processor ID");}
                 int sizeofarray=(new Integer(numberone)).intValue();
                 vars.addvariable("array "+sizeofarray,varone);
                 for (int j=0;j<sizeofarray;++j)
                 {
                    addtodef(varone+j);   
                 }
            }
            
            if (checkstring.equals("defr"))
            {
                 String varone=(String) i.next();  
                 String numberone=(String) i.next();  
                 String numbertwo=(String) i.next();  
                 if (varone.equals("pid")){error("Error, can not write to processor ID");}
                 int sizeofarrayone=(new Integer(numberone)).intValue();
                 int sizeofarraytwo=(new Integer(numbertwo)).intValue();
                 int sizeofarray=sizeofarrayone*sizeofarraytwo;
                 twodarrayname.add(varone);
                 twodarrayfirstsize.add(new Integer(sizeofarrayone));
                 twodarraysecondsize.add(new Integer(sizeofarraytwo));
                 vars.addvariable("array "+sizeofarray,varone);
                 for (int j=0;j<sizeofarrayone;++j)
                 {
                    for (int innercounter=0;innercounter<sizeofarraytwo;++innercounter)
                    {
                        addtodef(varone+j+"x"+innercounter);   
                    }
                 }
            }
            
            if (checkstring.equals("if") || checkstring.equals("ifn") || checkstring.equals("ifnn"))
            {
                isif=true;
                linenumber++;
                String comparitor=(String) i.next();

                     String varone=(String) i.next(); 
                     String vartwo=(String) i.next();   
                                                          
                     
                     if (!specialvariable(varone,8))
                     {                                                                      
                         
                        if (checkstring.equals("ifnn")) 
                        {                            
                            if ((new Integer(varone).intValue())<0)
                            {
                                theasm.add("lui $8,65535\n");
                                theasm.add("li $9,"+varone+"\n");
                                theasm.add("or $8,$8,$9\n");
                            } else {
                                theasm.add("li $8,"+varone+"\n");
                            }           
                        } else {
                            if (checkarrayvarindex(varone))
                            {                
                                arrayindexviavariable(varone,8,9);
                            } else {
                                if (!checkvariable(varone)){error("Error, "+varone+" not defined for use");}                
                                theasm.add("la $8,"+varone+"\n");
                            }                      
                            if (ispointer(varone))
                            {
                                theasm.add("lw $8,0($8)\n");
                            }
                            theasm.add("lw $8,0($8)\n");
                    }
                    }
                                          
                     if (!specialvariable(vartwo,9))
                     {                         
                        if (checkstring.equals("ifn")) 
                        {
                            
                            if ((new Integer(vartwo).intValue())<0)
                            {
                                theasm.add("lui $9,65535\n");
                                theasm.add("li $10,"+vartwo+"\n");
                                theasm.add("or $9,$9,$10\n");
                            } else {
                                theasm.add("li $9,"+vartwo+"\n");
                            }                                                        
                        } else {
                            if (checkarrayvarindex(vartwo))
                            {                
                                arrayindexviavariable(vartwo,9,10);
                            } else {
                                if (!checkvariable(vartwo)){error("Error, "+vartwo+" not defined for use");}                
                                theasm.add("la $9,"+vartwo+"\n");
                            }             
                            if (ispointer(vartwo))
                            {
                                theasm.add("lw $9,0($9)\n");
                            }
                            theasm.add("lw $9,0($9)\n");
                        }
                     }                                          
                     theasm.add("nop\n");
                     if (comparitor.equals("=="))
                     {
                        theasm.add("bne $8,$9,closebrace"+openbrace+"\n");
                     }
                     
                     if (comparitor.equals("!="))
                     {
                        theasm.add("beq $8,$9,closebrace"+openbrace+"\n");
                     }    
                     
                     if (comparitor.equals("<") ||comparitor.equals("<="))
                     {
                         if (comparitor.equals("<")) {theasm.add("beq $8,$9,closebrace"+openbrace+"\n");}                         
                         theasm.add("subu $8,$8,$9\n");                
                         theasm.add("nop\n");                
                         theasm.add("bgtz $8,closebrace"+openbrace+"\n");                
                    }
                    
                    
                    if (comparitor.equals(">") || comparitor.equals(">="))
                    {                    
                        if (comparitor.equals(">")) {theasm.add("beq $8,$9,closebrace"+openbrace+"\n");}
                        theasm.add("subu $8,$9,$8\n");                
                        theasm.add("nop\n");                
                        theasm.add("bgtz $8,closebrace"+openbrace+"\n");                
                    }
                    addhlevel("if "+parsevariable(varone)+" "+comparitor+" "+parsevariable(vartwo));
                    
            }      
            
            if (checkstring.equals("for") || checkstring.equals("fori"))
            {
                linenumber++;
                String vartouse=(String) i.next();
                if (!checkvariable(vartouse)){addtodef(vartouse);}
                String eqsign=(String) i.next();
                String initval=(String) i.next();
                
                if ((new Integer(initval).intValue())<0)
                {
                    theasm.add("lui $8,65535\n");
                    theasm.add("li $9,"+initval+"\n");
                    theasm.add("or $8,$8,$9\n");
                } else {
                    theasm.add("li $8,"+initval+"\n");
                }
                                                  
                theasm.add("la $9,"+vartouse+"\n");    
                theasm.add("sw $8,0($9)\n");
                String tosign=(String) i.next();
                String endval=(String) i.next();               
                theasm.add("forloopreturn"+returnpoints+":\n");
                theasm.add("la $9,"+vartouse+"\n");
                theasm.add("lw $8,0($9)\n");                                
                if (checkstring.equals("fori"))
                {
                    if (checkarrayvarindex(endval))
                    {                
                        arrayindexviavariable(endval,9,10);
                    } else {
                        if (!checkvariable(endval)){error("Error, "+endval+" not defined for use");}                
                        theasm.add("la $9,"+endval+"\n");
                    }                   
                    if (ispointer(endval))
                    {
                        theasm.add("lw $9,0($9)\n");
                    }
                    theasm.add("lw $9,0($9)\n");
                } else {
                        if ((new Integer(endval).intValue())<0)
                        {
                            theasm.add("lui $9,65535\n");
                            theasm.add("li $10,"+endval+"\n");
                            theasm.add("or $9,$9,$10\n");
                         } else {
                            theasm.add("li $9,"+endval+"\n");
                         }
                }
                theasm.add("subu $8,$8,$9\n");
                theasm.add("la $9,"+vartouse+"\n");
                theasm.add("lw $10,0($9)\n");
                theasm.add("addu $10,$10,1\n");
                theasm.add("sw $10,0($9)\n");
                theasm.add("nop\n");
                theasm.add("bgtz $8,closebrace"+openbrace+"\n");                
                bracehighlight.add(new Integer(openbrace));
                bracehighlight.add(new Integer(returnpoints));
                ++returnpoints;
                addhlevel("for "+parsevariable(vartouse)+"="+initval+" to "+endval );
            }
            
            if (checkstring.equals("while") || checkstring.equals("whilen") || checkstring.equals("whilenn") )
            {
                linenumber++;
                String eqsign=(String) i.next();
                String varone=(String) i.next();                                
                String vartwo=(String) i.next();  
                theasm.add("forloopreturn"+returnpoints+":\n");                
                bracehighlight.add(new Integer(openbrace));
                bracehighlight.add(new Integer(returnpoints));
                ++returnpoints;
                
                if (checkstring.equals("whilen"))
                {
                    if ((new Integer(varone).intValue())<0)
                    {
                        theasm.add("lui $8,65535\n");
                        theasm.add("li $9,"+varone+"\n");
                        theasm.add("or $8,$8,$9\n");
                     } else {
                        theasm.add("li $8,"+varone+"\n");
                     }
                } else {
                    if (!specialvariable(varone,8))
                    {                    
                        if (checkarrayvarindex(varone))
                        {                
                            arrayindexviavariable(varone,8,9);
                        } else {
                            if (!checkvariable(varone)){error("Error, "+varone+" not defined for use");}                
                            theasm.add("la $8,"+varone+"\n");
                        }                  
                        if (ispointer(varone))
                        {
                            theasm.add("lw $8,0($8)\n");
                        }
                    theasm.add("lw $8,0($8)\n");
                    }
                }
                
                if (checkstring.equals("whilenn"))
                {
                    if ((new Integer(vartwo).intValue())<0)
                    {
                        theasm.add("lui $9,65535\n");
                        theasm.add("li $10,"+vartwo+"\n");
                        theasm.add("or $9,$9,$10\n");
                     } else {
                        theasm.add("li $9,"+vartwo+"\n");
                     }
                } else {                
                    if (!specialvariable(vartwo,9))
                    {
                        if (checkarrayvarindex(vartwo))
                        {                
                            arrayindexviavariable(vartwo,9,10);
                        } else {
                            if (!checkvariable(vartwo)){error("Error, "+vartwo+" not defined for use");}                
                            theasm.add("la $9,"+vartwo+"\n");
                        }            
                        if (ispointer(vartwo))
                        {
                            theasm.add("lw $9,0($9)\n");
                        }
                        theasm.add("lw $9,0($9)\n");
                    }
                }
                
                theasm.add("nop\n");
                if (eqsign.equals("=="))
                {
                    theasm.add("bne $8,$9,closebrace"+openbrace+"\n");                
                }
                
                if (eqsign.equals("!="))
                {
                    theasm.add("beq $8,$9,closebrace"+openbrace+"\n");                
                }
                
                 if (eqsign.equals("<") ||eqsign.equals("<="))
                     {
                         if (eqsign.equals("<")) {theasm.add("beq $8,$9,closebrace"+openbrace+"\n");}                         
                         theasm.add("subu $8,$8,$9\n");                
                         theasm.add("nop\n");                
                         theasm.add("bgtz $8,closebrace"+openbrace+"\n");                
                    }
                    
                    
                    if (eqsign.equals(">") || eqsign.equals(">="))
                    {                    
                        if (eqsign.equals(">")) {theasm.add("beq $8,$9,closebrace"+openbrace+"\n");}
                        theasm.add("subu $8,$9,$8\n");                
                        theasm.add("nop\n");                
                        theasm.add("bgtz $8,closebrace"+openbrace+"\n");                
                    }
                    
                    addhlevel("while "+parsevariable(varone)+" "+eqsign+" "+parsevariable(vartwo) );
                                
            }
            
            if (checkstring.equals("processors"))
            {
                linenumber++;
                   String varone=(String) i.next();  
                   numberprocessors=(new Integer(varone)).intValue();
            }
           
           if (checkstring.equals(":="))
            {
                linenumber++;
                 String varone=(String) i.next();  
                 String vartwo=(String) i.next(); 
                 if (varone.equals("pid")){error("Error, can not write to processor ID");}                                  
                 if (!specialvariable(vartwo,8))
                 {                    
                      if (checkarrayvarindex(vartwo))
                      {                
                          arrayindexviavariable(vartwo,8,9);
                      } else {
                          if (!checkvariable(vartwo)){error("Error, "+vartwo+" not defined for use");}                
                          theasm.add("la $8,"+vartwo+"\n");
                      }
                      if (ispointer(vartwo))
                      {
                        theasm.add("lw $8,0($8)\n");
                      }                    
                    theasm.add("lw $8,0($8)\n");
                    
                 }
                 
                 if (checkarrayvarindex(varone))
                 {                
                    arrayindexviavariable(varone,9,10);
                 } else {                    
                    if (!checkvariable(varone)){addtodef(varone);}
                    theasm.add("la $9,"+varone+"\n");
                 }            
                 if (ispointer(varone))
                 {
                    theasm.add("lw $9,0($9)\n");
                 }
                 theasm.add("sw $8,0($9)\n");
                 
                 addhlevel(parsevariable(varone)+"="+parsevariable(vartwo) );
            }
            
            if (checkstring.equals("&="))
            {
                linenumber++;
                 String varone=(String) i.next();  
                 pointers.add(varone);
                 String vartwo=(String) i.next(); 
                 if (varone.equals("pid")){error("Error, can not write to processor ID");}                                  
                 if (!specialvariable(vartwo,8))
                 {                    
                      if (checkarrayvarindex(vartwo))
                      {                
                          arrayindexviavariable(vartwo,8,9);
                      } else {
                          if (!checkvariable(vartwo)){error("Error, "+vartwo+" not defined for use");}                
                          theasm.add("la $8,"+vartwo+"\n");
                      }         
                      if (ispointer(vartwo))
                      {
                        theasm.add("lw $8,0($8)\n");
                      }
                 }
                 
                 if (checkarrayvarindex(varone))
                 {                
                    arrayindexviavariable(varone,9,10);
                 } else {                    
                    if (!checkvariable(varone)){addtodef(varone);}
                    theasm.add("la $9,"+varone+"\n");
                 }                 
                 theasm.add("sw $8,0($9)\n");
                 
                 addhlevel(parsevariable(varone)+"& ="+parsevariable(vartwo) );
            }
            
            if (checkstring.equals("#="))
            {
                linenumber++;
                 String varone=(String) i.next();  
                 pointers.add(varone);
                 String vartwo=(String) i.next(); 
                 if (varone.equals("pid")){error("Error, can not write to processor ID");}                                  
                 if (!specialvariable(vartwo,8))
                 {                    
                      if (checkarrayvarindex(vartwo))
                      {                
                          arrayindexviavariable(vartwo,8,9);
                      } else {
                          if (!checkvariable(vartwo)){error("Error, "+vartwo+" not defined for use");}                
                          theasm.add("la $8,"+vartwo+"\n");
                      }                               
                        theasm.add("lw $8,0($8)\n");                      
                 }
                 
                 if (checkarrayvarindex(varone))
                 {                
                    arrayindexviavariable(varone,9,10);
                 } else {                    
                    if (!checkvariable(varone)){addtodef(varone);}
                    theasm.add("la $9,"+varone+"\n");
                 }                 
                 theasm.add("sw $8,0($9)\n");
                 
                 addhlevel(parsevariable(varone)+"& ="+parsevariable(vartwo) );
            }
            
            if (checkstring.equals(":=n"))
            {
                linenumber++;
                 String varone=(String) i.next();  
                 String numberone=(String) i.next();  
                 if (varone.equals("pid")){error("Error, can not write to processor ID");}                 
                 if ((new Integer(numberone).intValue())<0)
                 {
                    theasm.add("lui $8,65535\n");
                    theasm.add("li $9,"+numberone+"\n");
                    theasm.add("or $8,$8,$9\n");
                 } else {
                    theasm.add("li $8,"+numberone+"\n");
                 }
                 if (checkarrayvarindex(varone))
                 {                
                    arrayindexviavariable(varone,9,10);
                 } else {                    
                    if (!checkvariable(varone)){addtodef(varone);}
                    theasm.add("la $9,"+varone+"\n");
                 }         
                 if (ispointer(varone))
                 {
                    theasm.add("lw $9,0($9)\n");
                 }
                 theasm.add("sw $8,0($9)\n");
                 
                addhlevel(parsevariable(varone)+"="+numberone );
            }
            
            if (checkstring.equals(":=non"))
            {
                linenumber++;
                 String varone=(String) i.next();  
                 String numberone=(String) i.next();  
                 String operator=(String) i.next();  
                 String numbertwo=(String) i.next();  
                 if (varone.equals("pid")){error("Error, can not write to processor ID");}
                 if (!checkvariable(varone)){addtodef(varone);}
                 Integer none=new Integer(numberone);
                 Integer ntwo=new Integer(numbertwo);
                 int tooperate=0;
                 if (operator.equals("+")) {tooperate=(none.intValue()) + (ntwo.intValue());}
                 if (operator.equals("-")) {tooperate=(none.intValue()) - (ntwo.intValue());}
                 if (operator.equals("*")) {tooperate=(none.intValue()) * (ntwo.intValue());}
                 if (operator.equals("/")) {tooperate=(none.intValue()) / (ntwo.intValue());}
                 if (operator.equals("."))
                 {
                    double thewholenum=(double) (none.intValue()) / (double) (ntwo.intValue());
                    int theintnumber=(none.intValue()) / (ntwo.intValue());
                    double thepoint=thewholenum-(double) theintnumber;
                    int result=(int) (thepoint*10);
                    tooperate=result;
                 }
                 if (tooperate<0)
                 {
                    theasm.add("lui $8,65535\n");
                    theasm.add("li $9,"+tooperate+"\n");
                    theasm.add("or $8,$8,$9\n");
                 } else {
                    theasm.add("li $8,"+tooperate+"\n");
                 }
                 theasm.add("la $9,"+varone+"\n");
                 theasm.add("sw $8,0($9)\n");
                 
                 addhlevel(parsevariable(varone)+"="+numberone+operator+numbertwo );
            }
            
            if (checkstring.equals(":=ion"))
            {
                linenumber++;
                 String varone=(String) i.next();  
                 String vartwo=(String) i.next();  
                 String operator=(String) i.next();  
                 String numberone=(String) i.next();  
                 if (varone.equals("pid")){error("Error, can not write to processor ID");}                    
                 Integer none=new Integer(numberone);                 
                 
                 if (!specialvariable(vartwo,8))
                 {                 
                    if (checkarrayvarindex(vartwo))
                    {                
                         arrayindexviavariable(vartwo,8,9);
                    } else { 
                        if (!checkvariable(vartwo)){error("Error, "+vartwo+" not defined for use");} 
                        theasm.add("la $8,"+vartwo+"\n"); 
                    }             
                    if (ispointer(vartwo))
                    {
                        theasm.add("lw $8,0($8)\n");
                    }
                    theasm.add("lw $8,0($8)\n");
                 }
                 
                 if (operator.equals("+")) 
                 {
                    if ((none.intValue())<0)
                    {
                        theasm.add("lui $9,65535\n");
                        theasm.add("li $10,"+(none.intValue())+"\n");
                        theasm.add("or $9,$9,$10\n");
                        theasm.add("addu $8,$8,$9\n");                
                    } else { 
                        theasm.add("addu $8,$8,"+(none.intValue())+"\n");                
                    }
                 }
                 
                 
                 if (operator.equals("-")) 
                 {
                    if ((none.intValue())<0)
                    {
                        theasm.add("lui $9,65535\n");
                        theasm.add("li $10,"+(none.intValue())+"\n");
                        theasm.add("or $9,$9,$10\n");
                        theasm.add("subu $8,$8,$9\n");                
                    } else { 
                        theasm.add("li $9,"+(none.intValue())+"\n");                
                        theasm.add("subu $8,$8,$9\n");
                    }                                     
                 }
                 
                 if (operator.equals("*")) 
                 {
                     theasm.add("li $9,"+(none.intValue())+"\n");
                     theasm.add("mul $8,$8,$9\n");                     
                 }
                 
                 if (operator.equals("/")) 
                 {
                     theasm.add("li $9,"+(none.intValue())+"\n");
                     theasm.add("divu $8,$9\n"); 
                 }                 
                 
                 if (operator.equals(".")) 
                 {
                     theasm.add("li $9,"+(none.intValue())+"\n");
                     theasm.add("divu $8,$9\n"); 
                     theasm.add("move $8,$9\n");
                 }
                 
                 if (checkarrayvarindex(varone))
                 {                
                    arrayindexviavariable(varone,9,10);
                 } else {                    
                    if (!checkvariable(varone)){addtodef(varone);}
                    theasm.add("la $9,"+varone+"\n");
                 }                       
                 if (ispointer(varone))
                 {
                    theasm.add("lw $9,0($9)\n");
                 }
                 theasm.add("sw $8,0($9)\n");
                 
                                  addhlevel(parsevariable(varone)+"="+parsevariable(vartwo)+operator+numberone );
            }            
            
            if (checkstring.equals(":=ioi"))
            {
                linenumber++;
                 String varone=(String) i.next();  
                 String vartwo=(String) i.next();  
                 String operator=(String) i.next();  
                 String varthree=(String) i.next();
                 if (varone.equals("pid")){error("Error, can not write to processor ID");}
                                 
                 if (!specialvariable(vartwo,8))
                 {                    
                    if (checkarrayvarindex(vartwo))
                    {                
                        arrayindexviavariable(vartwo,8,9);
                    } else {                    
                        if (!checkvariable(vartwo)){error("Error, "+vartwo+" not defined for use");}
                        theasm.add("la $8,"+vartwo+"\n");
                    }                    
                    if (ispointer(vartwo))
                    {
                        theasm.add("lw $8,0($8)\n");
                    }
                    theasm.add("lw $8,0($8)\n");
                 }
                 
                 if (!specialvariable(varthree,9))
                 {                                  
                    if (checkarrayvarindex(varthree))
                    {                
                        arrayindexviavariable(varthree,9,10);
                    } else {                    
                        if (!checkvariable(varthree)){error("Error, "+varthree+" not defined for use");}
                        theasm.add("la $9,"+varthree+"\n"); 
                    }       
                    if (ispointer(varthree))
                    {
                        theasm.add("lw $9,0($9)\n");
                    }
                    theasm.add("lw $9,0($9)\n");
                 }
                 
                 if (operator.equals("+")) 
                 {
                    theasm.add("addu $8,$8,$9\n");                
                 }
                 
                 
                 if (operator.equals("-")) 
                 {               
                     theasm.add("subu $8,$8,$9\n");                
                 }
                 
                 if (operator.equals("*")) 
                 {
                     theasm.add("mul $8,$8,$9\n");                     
                 }
                 
                 if (operator.equals("/")) 
                 {
                     theasm.add("divu $8,$9\n"); 
                 }
                 
                 if (operator.equals(".")) 
                 {                     
                     theasm.add("divu $8,$9\n"); 
                     theasm.add("move $8,$9\n");
                 }
                 
                 if (checkarrayvarindex(varone))
                 {                
                    arrayindexviavariable(varone,9,10);
                 } else {                    
                    if (!checkvariable(varone)){addtodef(varone);}
                    theasm.add("la $9,"+varone+"\n"); 
                 }          
                 if (ispointer(varone))
                 {
                    theasm.add("lw $9,0($9)\n");
                 }
                 theasm.add("sw $8,0($9)\n");
                 addhlevel(parsevariable(varone)+"="+parsevariable(vartwo)+operator+parsevariable(varthree));
            }
        }
        arrangefile();
    }
    
    public void arrangefile()
    {
        addend();
        ArrayList thelist=new ArrayList();
        Iterator i=theasm.iterator();
        while(i.hasNext())
        {
            String contents=(String) i.next();
            thelist.add(contents);
        }
        
        i=dataarea.iterator();
        while(i.hasNext())
        {
            String contents=(String) i.next();
            thelist.add(contents);
        }        
        file.writefile("c:\\gccmips\\assembly.s",thelist);
        dohighlevel();
        ArrayList loader=new ArrayList();
        loader.add("c:\\gccmips\\a.out\n");
        loader.add("c:\\gccmips\\this.hl\n");
        loader.add(numberprocessors+"\n");   
        loader.add(memmodel+"\n");
        loader.add(crcwmodel+"\n");
        file.writefile("run.pr",loader);
    }
    
    public void dohighlevel()
    {
        ArrayList touse=hlevel.getall();
        ArrayList proctouse=prochlevel.getall();
        Iterator i=proctouse.iterator();
        while (i.hasNext())
        {
            touse.add(i.next());   
        }
        
        ArrayList varstouse=vars.get();
        i=varstouse.iterator();
        while (i.hasNext())
        {
            touse.add(i.next());   
        }
        
        file.writefile("this.hl",touse);
    }
    
    public void addend()
    {
        theasm.add("li $2,01\n");
        theasm.add("syscall\n");   
        addhlevel("end");
    }
            
    public boolean checkvariable(String varname)
    {
        if (varname.equals("pid") || varname.equals("nprocessors")) {return true;}
        Iterator i=variables.iterator();
        while(i.hasNext())
        {
            String alreadyname=(String) i.next();
            if (alreadyname.equals(varname))
            {
                return true;   
            }
        }
        return false;
    }
    
    public boolean checkarrayvarindex(String variable)
    {
        for (int i=0;i<variable.length();++i)
        {
            char individ=variable.charAt(i);
            if (individ=='[' || individ=='%' || individ=='')
            {
                return true;   
            }
        }
        return false;
    }
    
    public boolean checktwodarray(String variable)
    {
        for (int i=0;i<variable.length();++i)
        {
            char individ=variable.charAt(i);
            if (individ=='')
            {
                return true;   
            }
        }
        return false;
    }
    
    public void arrayindexviavariable(String thevariable,int reg1, int reg2)
    {
        boolean twod=checktwodarray(thevariable);
        String[] thenameandindex=new String[4];
        if (twod)
        {
            thenameandindex=getdiffpartoftwodarray(thevariable);
        } else {           
            thenameandindex=getdiffpartofarray(thevariable);
        }
        
        if (!specialvariable(thenameandindex[1],reg1))
        {            
            if (checkarrayvarindex(thenameandindex[1]))
            {
                if (isintwod) 
                {
                    isintwod=false;
                    arrayindexviavariable(thenameandindex[1],reg1,reg2);
                    isintwod=true;
                } else {
                    arrayindexviavariable(thenameandindex[1],reg1,reg2);
                }
                theasm.add("lw $"+reg1+",0($"+reg1+")\n");
            } else {
                theasm.add("la $"+reg1+","+thenameandindex[1]+"\n");
                theasm.add("lw $"+reg1+",0($"+reg1+")\n");
            }
        }
        if (twod)
        {
            int sizeofsecondbit=getsizesecondbittwod(thenameandindex[0]);
            int sizetoput=sizeofsecondbit*4;
            theasm.add("li $"+reg2+","+sizetoput+"\n");
        } else {
            theasm.add("li $"+reg2+",4\n");
        }
        
        theasm.add("mul $"+reg1+",$"+reg2+"\n");
        if (ispointer(thenameandindex[0]))
        {
            theasm.add("la $"+reg2+","+thenameandindex[0]+"\n");
            theasm.add("lw $"+reg2+",0($"+reg2+")\n");            
        } else {
            if (!isintwod)
            {
                if (twod)
                {
                    theasm.add("la $"+reg2+","+thenameandindex[0]+"0x0\n");
                } else {
                    theasm.add("la $"+reg2+","+thenameandindex[0]+"0\n");
                }
            }
        }
        if (!isintwod)
        {
            theasm.add("addu $"+reg1+",$"+reg1+",$"+reg2+"\n");        
        }
        if (twod)
        {
           theasm.add("move $29,$"+reg1+"\n"); 
           isintwod=true;
           arrayindexviavariable(thenameandindex[0]+"["+thenameandindex[2],reg1,reg2);           
           isintwod=false;
           theasm.add("addu $"+reg1+",$"+reg1+",$29\n");        
        }
    }
    
    public int getsizesecondbittwod(String thevar)
    {
        Iterator theiterator=twodarrayname.iterator();
        Iterator thejiterator=twodarraysecondsize.iterator();
        while (theiterator.hasNext())
        {
            String thename=(String) theiterator.next();
            int secondsize=((Integer) thejiterator.next()).intValue();
            if (thename.equals(thevar))
            {
                return secondsize;   
            }
        }
        return 0;
    }
    
    public String[] getdiffpartoftwodarray(String thevar)
    {
        String[] toreturn=new String[3];
        toreturn[0]="";
        toreturn[1]="";
        toreturn[2]="";
        boolean afterfirstmark=false;
        boolean aftersecondmark=false;
        
        for (int i=0;i<thevar.length();++i)
        {
            char individ=thevar.charAt(i);
            if (individ=='')
            {
                if (afterfirstmark)
                {
                    aftersecondmark=true;
                } else {
                    afterfirstmark=true;   
                }
            } else {
                if (!afterfirstmark && !aftersecondmark)
                {
                    toreturn[0]=toreturn[0]+((new Character(individ)).toString());    
                }
                
                if (afterfirstmark && !aftersecondmark)
                {
                    toreturn[1]=toreturn[1]+((new Character(individ)).toString());    
                }
                
                if (afterfirstmark && aftersecondmark)
                {
                    toreturn[2]=toreturn[2]+((new Character(individ)).toString());    
                }
            }
        }
        return toreturn;
    }
    
    public String[] getdiffpartofarray(String thevar)
    {
        String[] toreturn=new String[2];  
        toreturn[0]="";
        toreturn[1]="";
        boolean aftermark=false;
        for (int i=0;i<thevar.length();++i)
        {
            char individ=thevar.charAt(i);
            if ((individ=='[' || individ=='%' || individ=='') && !aftermark)
            {
                aftermark= true;   
                if (individ=='%')
                {
                    if (!checkvariable(toreturn[0]+"0"))
                    {
                        if (numberprocessors==0) {error("You need to define the number of processors before using shared variables");}
                        vars.addvariable("array "+(numberprocessors+1),toreturn[0]);
                        for (int j=0;j<=numberprocessors;++j)
                        {                            
                            addtodef(toreturn[0]+j);   
                        }
                    }
                }
            } else {
                if (aftermark)
                {
                    toreturn[1]=toreturn[1]+((new Character(individ)).toString());    
                } else {
                    toreturn[0]=toreturn[0]+((new Character(individ)).toString());    
                }
            }
        }
        return toreturn;
    }
    
    public void addtodef(String varname)
    {
        if (!varname.equals("pid"))
        {
            variables.add(varname);
            dataarea.add(varname+":     .word 0\n");
            vars.addvariable(varname);
        }
    }
    
    public void error(String reason)
    {
        System.out.println(reason+" at line "+linenumber);
        System.exit(0);
    }
    
    public void nprocessors(int reg)
    {
        theasm.add("li $2,06\n");
        theasm.add("syscall\n");
        theasm.add("move $"+reg+",$2\n");
    }
    
    public boolean specialvariable(String thevariable, int reg)
    {
        if (thevariable.equals("pid") || thevariable.equals("nprocessors"))
        {
            if (thevariable.equals("pid"))
            {
                theasm.add("move $"+reg+",$1\n");
            }
            
            if (thevariable.equals("nprocessors"))
            {
                nprocessors(reg);
            }
            return true;
        } else {
            return false;
        }
    }
    
    public int checkbracepoint(int bracenumber)
    {
        Iterator i =bracehighlight.iterator();
        while (i.hasNext())
        {
            Integer theint=(Integer) i.next();
            Integer theretpoint=(Integer) i.next();
            
            int theintint=theint.intValue();
            if (theintint==bracenumber) {return theretpoint.intValue();}
        }
        return 0;
    }
    
    public boolean checkclosebrace(int bpoint)
    {
        Iterator i=usedbclose.iterator();
        while(i.hasNext())
        {
            int usedpoint=((Integer) i.next()).intValue();
            if (usedpoint==bpoint) {return true;}
        }
        return false;
    }
    
    public void openproc()
    {
        arrayindexviavariable(procname+"%pid",8,9);
        theasm.add("sw $31,0($8)\n");
    }
    
    public void doendofproc(String theprocname)
    {
        arrayindexviavariable(theprocname+"%pid",8,9);
        theasm.add("lw $31,0($8)\n");
        theasm.add("nop\n");
        theasm.add("jr $31\n");
    }
    
    public String checkproc(int bracenumber)
    {
        Iterator i=proc.iterator();
        while(i.hasNext())
        {
            procedure theproc=(procedure) i.next();
            if ((theproc.getbracenumber())==bracenumber)
            {
                return theproc.getname();   
            }
        }
        return "";
    }
    
    public boolean isinproc()
    {
        return inproc;  
    }
    
    public void addhlevel(String toadd)
    {
        if (inproc || isaproc)
        {
            prochlevel.add(toadd,theasm.getinst());
        } else {
            hlevel.add(toadd,theasm.getinst());   
        }
        theasm.reset();
    }
    
    public void addhlevel(String toadd, int tonegate)
    {
        if (tonegate==0)
        {
            if (inproc || isaproc)
            {
                prochlevel.add(toadd,0);
            } else {
                hlevel.add(toadd,0);   
            }
        } else {
            if (inproc || isaproc)
            {   
                prochlevel.add(toadd,theasm.getinst()-tonegate);
            } else {
                hlevel.add(toadd,theasm.getinst()-tonegate);   
            }
        }
        theasm.reset();
    }
    
    public String parsevariable(String variabletoparse)
    {
        String toreturn=variabletoparse;
        boolean addbrace=false;
        for (int i=0;i<variabletoparse.length();++i)
        {
            char isbrace=variabletoparse.charAt(i);
            if (isbrace=='[') {addbrace=true;}
        }
        if (variabletoparse.length() <4)
        {
            if (addbrace) {toreturn=toreturn+"]";}
            return toreturn;   
        }
        int lengthofvar=variabletoparse.length();
        String ispidornot=variabletoparse.substring(lengthofvar-4,lengthofvar);
        if (ispidornot.equals("%pid"))
        {
            toreturn=variabletoparse.substring(0,lengthofvar-3);
        }
        if (addbrace) {toreturn=toreturn+"]";}
        return toreturn;
    }
    
    public boolean ispointer(String vartocheck)
    {
        Iterator i=pointers.iterator();
        while (i.hasNext())
        {
            String isit=(String) i.next();
            if (isit.equals(vartocheck))
            {
                return true;   
            }
        }
        return false;
    }
    
    public boolean testelse(int bracenototest)
    {
        Iterator i=elsebracecounter.iterator();
        while (i.hasNext())
        {
            int theelsec=((Integer) i.next()).intValue();
            if (theelsec==bracenototest) {return true;}
        }
        return false;
    }
}