/*
	A Range class for range analysis, first written 23/4/07 by Nick Brown
	This was written to be used in preference to the Flexibo Range class because
	there is certain functionality that is required which is not implemeneted in that
	class - so it is used here to implement that.
	
	
	THIS ASSUMES THAT A IS SMALLER OR EQUAL TO B WHICH THERE ARE NO CHECKS TO PRESERVE!! 
*/
var Range:=class UnaryType
(
	var dynamic a;
	var dynamic b;
	var getvaluevalue:=null;
	var dynamic init:=method[aa,ab]
	(		
		a:=aa;
		b:=ab;
		this;
	);
	
	var isrange:=method[]
	(
		// a != b
		return (!(a==b));
	);
	
	var getCurrentType:=method[] Int;
	
	var generateCode:=method[] output.add[a];
	
	var add:=method x
	(		
		if (x::Range)
		(		
			return Range[a + x.a, b + x.b];
		) else (
			return new unknown[];
		);		
	);
	
	var multiply:=method x
	(
		if (x::Range)
		(
			return Range[a * x.a, b * x.b];
		) else (
			return new unknown[];
		);
	);
	
	var divide:=method x
	(
		if (x::Range)
		(
			return Range[a % x.a, b % x.b];
		) else (
			return new unknown[];
		);
	);
	
	var subtract:=method x
	(
		if (x::Range)
		(
			return Range[a - x.a, b - x.b];
		) else (
			return new unknown[];
		);
	);
	
	var equalTo:=method x
	(		
		if (!(x::Range)) 
		(			
			if ((x==a) && (x==b)) return true;
			return false;
		);
		if ((a <= x.a) && (b >= x.b)) return true;
		if ((x.a = a) && (x.b = b)) return true;
		return false;
	);
		
	var lessThan:=method x
	(
		if (!(x::Range)) return false;
		if ((a < x.a) && (b < x.b)) return true;
		return false;
	);
	
	var greaterThan:=method x
	(
		if (!(x::Range)) return false;
		if ((a > x.a) && (b > x.b)) return true;
		return false;
	);
	
	var check:=method[v]
	(			
		/*
			This check method is important - Flexibo's Range does not have a check method and to perform type checking
			it causes a problem with producing messy duplicated code, this method irradicates this
		*/
		if (v::thisclass)
		(
			if ((a.getType[]).check[(v.a).getType[]] && (b.getType[]).check[(v.b).getType[]])
			(
				return true;
			);		
		);
		return false;
	);
	var getValue:=method[]
	(
		if (getvaluevalue==null) return null;
		return this;
	);
	var printing:=method[] print a;
);