var errorsclass:=class Value
(
	// Syntactic Check
 	var SParallelError:=method[] throw error "Syntactic error - Parallel Statement Expected";
 	var SSequentialError:=method[] throw error "Syntactic error - Sequential Statement Expected";
 	var SAssignmentError:=method[] throw error "Syntactic error - Assignment Expected";
 	var SExpressionError:=method[] throw error "Syntactic error - Expression Expected";
 	var SVariableError:=method[] throw error "Syntactic error - Variable Expected";
 	var SConstantError:=method[] throw error "Syntactic error - Constant Expected";
 	var STypeError:=method[] throw error "Syntactic error - Type Expected"; 
 	var STypeSError:=method[] throw error "Syntactic error - Type Combination not allowed";
 	var STypeAError:=method[] throw error "Syntactic error - Too many arguments to Type";
 	
 	// Function errors
 	var FunctionMissing:=method[] throw error "Function error - Function name does not exist";
 	var FunctionArguments:=method[] throw error "Function error - Number of function arguments mismatch";
 	var FunctionReturnMixture:=method[] throw error "Function error - The type returned by function is a mixture of fn and base types";
 	
 	// Type check error
 	var TypeError:=method[] throw error "Type check error - Type inconsistent";
 	
 	// try catch
 	var nestedTry:=method[] throw error "Nested Try Catch block - The language does not support a try catch block in another's try block";
 	
 	// Parallel error
 	var DeterminError:=method[] throw error "Parallel error - The number of processors needs to be deterministic";
 	
 	// Array access error
 	var arrayindexError:=method[] throw error "Array Access error - The index specified is outside of the array range"; 	
 	var interferenceError:=method[] throw error "Interference error - Two processes are writing to the same variable in the same synchronization";
 	
 	// Type errors
 	var subtypeError:=method[] throw error "Can not move to subtype";
 	var supertypenotcurrentError:=method[] throw error "Super type given is not the current type";
 	var supertypeError:=method[] throw error "Can not move to supertype";
 	var typevarmisuseError:=method[] throw error "Type Variables cannot be used as normal variables";
 	
);

var errors:=new errorsclass[];