/*
File created 9/11/2007 by Nick Brown

This is the important note - we still need array bounds checking for the shared array
*/

var distributed:=class rootType
(	
	var dynamic a;
	var dynamic b;
	var dynamic dimensions:=0;
	var dynamic interfers;
	var dynamic nominvoke:=false;
	
	var dynamic even:=true;
	var dynamic extra:=0;
	
	//var getId:=method[] return 1;
	
	var init:=method[]
	(
		super;
		startroot[];		
		interfers:=new interference[];
		this
	);
	
	var getDotValue:=method[x]
	{		
		computeDims[];
		((getVariable[]).getstoredtype[]).computeSize[];
    	var sone:=((getVariable[]).getstoredtype[]).getSizeIndex[0];
		// for now ignore s2 and b!
		var eachsize:=sone.a % a.a;
		var touse:=currentparallelprocess;
		if (currentparallelprocess==0) touse:=parallelgeneratecounter;
		var zeros:=eachsize * (touse - 1);
		if (x="low") return Range[zeros,zeros];	
		var top:=(zeros + eachsize) - 1;

		if (touse == totalprocesses) top:=sone.a - 1;	// the last process will take all the excess up too
		
		if (x="high") return Range[top,top];
		core.getDotValue[x];	
	};
	
	var getdottype:=method[thestring]
	 (
	 	if (thestring="low" || thestring="high")
	 	(
	 		return Int;
	 	);	 	
	 	core.getdottype[thestring];
	 );
	
	var clone:=method[]
    {
    	var rety:=new distributed[a,b];	    	
    	rety.a:=a;
    	rety.b:=b;
    	rety.alone:=alone;
    	rety.core:=core.clone[];    
    	return rety;
    };
    
    var setnominvoke:=method[r] nominvoke:=r;
    var getnominvoke:=method[] nominvoke;
    
    var isDistributed:=method[] true;
    
    var computeDims:=method[]
	(
		if (!(a :: Range))
		(
			if ( !((a.getValue[])==null) && !((a.getValue[]) :: unknown) && !((a.getValue[]).check[new unknown]) )
			(
				a:=a.getValue[];
			);
		);
		
		if (dimensions > 0)
		(
		
		if (!(b :: Range))
		(
			if ( !((b.getValue[])==null) && !((b.getValue[]) :: unknown) && !((b.getValue[]).check[new unknown]) )
			(
				b:=b.getValue[];
			);
		);
		);
	);
    
    var setarg:=method[x,i]
	(		
		if (i==0) 
		(
			if ( ((x.getValue[])==null) || ((x.getValue[]) :: unknown))
			(
				a:=x;
			) else (
				a:=(x.getValue[]);
			);			
		);
		
		if (i==1) 
		(
			if ( ((x.getValue[])==null) || ((x.getValue[]) :: unknown))
			(
				b:=x;
			) else (
				b:=(x.getValue[]);
			);			
		);
		dimensions:=i;
		if (i > 1) errors.STypeAError[];
	);
	
	var displaySize:=method[s1,s2,pa,pb]
    {
    	// if different to two d array would need stack or something
    	//computeDims[];    	
    	output.add["("];
    	if (s1 :: Range)
    	(
    		output.add[s1.a % pa.a];
    	) else (
    		output.add["("];
    		s1.generateCode[];
			output.add[" / "];
			pa.generateCode[];
			output.add[")"];
    	);
    	output.add["*"];
    	if (s2 :: Range)
    	(
    		output.add[s2.a % pb.a];
    	) else (
    		output.add["("];
    		s2.generateCode[];
			output.add[" / "];
			pb.generateCode[];
			output.add[")"];
    	);
    	output.add[")"];
 	};
 	
 	var optimiseAccess:=method[x,i]
 	{ 		
 		computeDims[];
 		if (i==null)
 		(
 			if (((getVariable[]).getstoredtype[]).isshared[]==true)
    		(
    			var arglist:=new ArrayList[];
				arglist.aadd[x];
				arglist.aadd[i];
				arglist.aadd[getVariable[]];
				arglist.aadd[a];
				arglist.aadd[b];
				var j;
				for j from 0 to (totalprocesses - 1)
				(
					if !(j==(currentparallelprocess - 1))
					(
						syncs.add[j,this.generateAccessGather,arglist];
						if (even==false) 
						(
							((getVariable[]).getstoredtype[]).computeSize[];
    						var s1:=((getVariable[]).getstoredtype[]).getSizeIndex[0];
    						var s2:=((getVariable[]).getstoredtype[]).getSizeIndex[1];
							var newargs:=new ArrayList[];
							newargs.aadd[getVariable[]];
							newargs.aadd[currentparallelprocess - 1];
							newargs.aadd[(s1.a % a.a) * s2.a];
							newargs.aadd[extra];
							newargs.aadd[s2.a];
							syncs.add[j,this.generateOddSend,newargs];
						);
					);
				);
    		);
 		) else (
 			var localornot:=computeLocalorNot[i,currentparallelprocess - 1];
 			if (localornot==false)
 			(
 				var o:=i.top[];
 				if (!(o::Range)) o:=o.getValue[]; 				
 				var src:=getSourceProcess[i];				
 				if (o.a == o.b)
 				(
 					arglist:=new ArrayList[];
					arglist.aadd[getVariable[]];
					arglist.aadd[i];
					arglist.aadd[currentparallelprocess - 1];
					arglist.aadd[a];
					arglist.aadd[b];	
					arglist.aadd[1];	
					syncs.add[src,this.generateSend,arglist];
				) else (					
					((getVariable[]).getstoredtype[]).getSharedPoolID[];	// dont use value but will create one if not already done so
					syncs.setDynamicSync[];
				);
 			); 			
 		);
 	};
 	
 	var generateAccess:=method[x,i]
 	{
 	    	// IMPORTANT NOTE AT TOP!
	 	computeDims[];  
	 	computeEvenorOdd[getVariable[]];	 	
    	var ni:=i;
    	if (i==null)
    	(
    		if (((getVariable[]).getstoredtype[]).isshared[]==true)
    		(
    			generateAccessGather[x,i,getVariable[],a,b];			
    			if (even==false) 
    			(
    				(x.getstoredtype[]).computeSize[];
    				var s1:=(x.getstoredtype[]).getSizeIndex[0];
    				var s2:=(x.getstoredtype[]).getSizeIndex[1];
    				generateOddReceive[x,totalprocesses - 1,(((s1.a % a.a) * s2.a) * totalprocesses),extra,s2.a];
    			);
				return true;
    		);
    	) else (
    		// something in the index!    		
    		var localornot:=computeLocalorNot[ni,parallelgeneratecounter - 1];
    		if (localornot==true)
    		(    		
    			// local write  
    			x.generateCode[];  
    			output.add["="];			
    			var newdims:=computeLocalDimensions[ni,parallelgeneratecounter - 1,getVariable[],a,b];
    			(getVariable[]).generateName[];
    			if (newdims :: unknown)
    			(
    				generateDynamicLocalDimensions[ni];
    			) else (
    				var oldn:=((getVariable[]).getstoredtype[]).getnominvoke[];
    				((getVariable[]).getstoredtype[]).setnominvoke[true];
    				((getVariable[]).getstoredtype[]).generateMethodInvoke[newdims];
    				((getVariable[]).getstoredtype[]).setnominvoke[oldn];
    			);    			
    			output.add[";"];
    			output.newline[];  			
    			return true;
    		);
    		if (localornot==false)
    		(   		    		
    		 	var o:=i.top[];
 				if (!(o::Range)) o:=o.getValue[];
 				if (o.a == o.b)
 				(
    				generateGetOtherProcessValue[x,ni];		
    			) else (
    				generateDynamicReceive[x,i];
 					output.newline[];
    			);
    			return true;
    			// global write
    		);
    		
    		if (localornot :: unknown)
    		(    		
    			// who knows?     			    				
    			if (x.hasBeenDeclared[]==false)
    			(
    				// if not already declared, declare variable here, so in scope for MESH code
    				x.generateCode[];
    				output.add[";\n"];
    			);    			     			    			
    			generateDynamicLocalCheck[ni];
    			output.newline[];
    			output.add["{\n"];
    			x.generateCode[];
    			output.add["="];
    			(getVariable[]).generateName[];
    			generateDynamicLocalDimensions[ni];    			
    			output.add[";"];
    			output.newline[]; 
    			output.add["} else {\n"];
    			generateDynamicReceive[x,i];
    			output.add["}\n"];
    			// no global write yet!
    			return true;
    		);
    	);
 	};
 	
 	var generateReceive:=method[v,i,dest,pa,pb,numbertoget]
 	{
 		output.add["MPI_Status rstat"];
 		output.add[MPIstatuscnt];
 		output.add[";\n"]; 		
 		output.add["MPI_Recv(&"];
 		var localdms:=computeLocalDimensions[i,parallelgeneratecounter - 1,v,pa,pb];
 		var oldn:=(v.getstoredtype[]).getnominvoke[];
 		(v.getstoredtype[]).setnominvoke[true];
 		v.generateMethodInvoke[localdms];
 		(v.getstoredtype[]).setnominvoke[oldn];
 		output.add[","];
 		output.add[numbertoget];
 		output.add[","];
 		((v.getstoredtype[]).getCoreType[]).generateMPIDeclaration[];
 		output.add[","];
 		output.add[dest];
 		output.add[",0,MPI_COMM_WORLD,&rstat"];
 		output.add[MPIstatuscnt];
 		output.add[");\n"];
 		MPIstatuscnt:=MPIstatuscnt + 1;
 	};
 	
 	var generateSend:=method[v,i,dest,pa,pb,numbertosend]
 	{
 		output.add["MPI_Send(&"];
 		var localdms:=computeLocalDimensions[i,parallelgeneratecounter - 1,v,pa,pb];
 		var oldn:=(v.getstoredtype[]).getnominvoke[];
 		(v.getstoredtype[]).setnominvoke[true];
 		v.generateMethodInvoke[localdms];
 		(v.getstoredtype[]).setnominvoke[oldn];
 		output.add[","];
 		output.add[numbertosend];
 		output.add[","];
 		((v.getstoredtype[]).getCoreType[]).generateMPIDeclaration[];
 		output.add[","];
 		output.add[dest];
 		output.add[",0,MPI_COMM_WORLD);\n"];
 	};
 	
 	var generateSetOtherProcessValue:=method[x,i]
 	( 		
 		output.add["MPI_Send(&"];
 		x.generateCode[]; 		
 		output.add[",1,"];
 		(((getVariable[]).getstoredtype[]).getCoreType[]).generateMPIDeclaration[];
 		output.add[","];
 		output.add[getSourceProcess[i]];
 		output.add[",0,MPI_COMM_WORLD);"];
 		output.newline[];
 	);
 	
 	var generateGetOtherProcessValue:=method[x,i]
 	{
 		if (x.hasBeenDeclared[]==false)
 		(
 			x.generateCode[];
 			output.add[";\n"];
 		);
 		output.add["MPI_Status rstat"];
 		output.add[MPIstatuscnt];
 		output.add[";\n"];
 		output.add["MPI_Recv(&"];
 		x.generateCode[]; 		
 		output.add[",1,"];
 		(((getVariable[]).getstoredtype[]).getCoreType[]).generateMPIDeclaration[];
 		output.add[","];
 		output.add[getSourceProcess[i]];
 		output.add[",0,MPI_COMM_WORLD,&rstat"];
 		output.add[MPIstatuscnt];
 		output.add[");"];
 		MPIstatuscnt:=MPIstatuscnt + 1;
 		output.newline[];
 	};
 	
 	var getSourceProcess:=method[i]
 	{
 		var bitone:=i.lget[0];
    	if !(bitone :: Range) bitone:=bitone.getValue[];    	
    	var bittwo;
    	if (dimensions > 0)
    	(
    		bittwo:=i.lget[1];
    		if (!(bittwo :: Range) && (!(bittwo==null))) bittwo:=bittwo.getValue[];
    		if (!(bittwo==null)) if ((bittwo.a != bittwo.b)) return new unknown;    		    		
    	);
    	if (bitone.a != bitone.b)  return new unknown;
    	computeDims[];
    	((getVariable[]).getstoredtype[]).computeSize[];
    	var sone:=((getVariable[]).getstoredtype[]).getSizeIndex[0]; 

    	if (a.a > 1)
    	(
    		var eone:=sone.a % a.a;    	   
    		return (bitone.a % eone);
    	) else (
    		return 0;
    	);    	
 	};
 	
 	var computeEvenorOdd:=method[v]
 	{
 		(v.getstoredtype[]).computeSize[];
 		var s1:=(v.getstoredtype[]).getSizeIndex[0];
 		if (dimensions > 0) var s2:=(v.getstoredtype[]).getSizeIndex[1];		
		var q:=(s1.a % a.a) * totalprocesses;
		if (q!=s1.a)
		(
			even:=false;
			extra:=s1.a - q;
		);
 	};
 	
 	var optimiseAssignment:=method[x,i]
 	{ 	 	
 		if ((x.getCurrentType[]).hasOwnCommBehaviour[]==true) return null;
 		if !((core.overrideAssignment[])==null)
 		(
 			return core.optimiseAssignment[x,i];
 		);
 		computeDims[]; 		
 		computeEvenorOdd[getVariable[]]; 		
 		if (i==null)
 		(
 			if (((getVariable[]).getstoredtype[]).isshared[]==true)
    		(
    			var arglist:=new ArrayList[];
				arglist.aadd[x];
				arglist.aadd[i];
				arglist.aadd[getVariable[]];
				arglist.aadd[a];
				arglist.aadd[b];
				var j;
				for j from 0 to (totalprocesses - 1)
				(
					if !(j==(currentparallelprocess - 1))
					(
						syncs.add[j,this.generateAssignmentScatters,arglist];
						if (j==totalprocesses - 1)
						(						
							if (even==false) 
							(
								((getVariable[]).getstoredtype[]).computeSize[];
    							var s1:=((getVariable[]).getstoredtype[]).getSizeIndex[0];
    							var s2:=((getVariable[]).getstoredtype[]).getSizeIndex[1];
								var newargs:=new ArrayList[];
								newargs.aadd[getVariable[]];
								newargs.aadd[currentparallelprocess - 1];
								newargs.aadd[(s1.a % a.a) * s2.a];
								newargs.aadd[extra];
								newargs.aadd[s2.a];
							 	syncs.add[j,this.generateOddReceive,newargs];
							);
						);
					);					
				);
    		);
 		) else (
 			if ((interfers.docheck[syncs.getSyncNumber[],i,currentparallelprocess - 1])==true)
 			( 		
 				skip;//errors.interferenceError[];
 			) else (
 				if ((interfers.contains[syncs.getSyncNumber[],i,currentparallelprocess - 1])==false)
 				( 		 				
 					interfers.add[syncs.getSyncNumber[],i,currentparallelprocess - 1];
 				);
 			);
 			var localornot:=computeLocalorNot[i,currentparallelprocess - 1];
 			
 			if (localornot==false)
 			(
 				var o:=i.top[]; 				
 				if (!(o::Range)) o:=o.getValue[];
 				var src:=getSourceProcess[i];
 				if (o.a == o.b)
 				(
 					// we know exactly who to send to!
 					arglist:=new ArrayList[];
					arglist.aadd[getVariable[]];
					arglist.aadd[i];
					arglist.aadd[currentparallelprocess - 1];
					arglist.aadd[a];					
					if (dimensions > 0) 
					(
						arglist.aadd[b];
					) else (
						arglist.aadd[null];
					);
					arglist.aadd[1];										
					syncs.add[src,this.generateReceive,arglist];
				) else (
					// need to use dynamic sync here					
					((getVariable[]).getstoredtype[]).getSharedPoolID[];	// dont use value but will create one if not already done so
					syncs.setDynamicSync[];
				);				
 			); 		
 			if (localornot :: unknown)
 			(
 				((getVariable[]).getstoredtype[]).getSharedPoolID[];	// dont use value but will create one if not already done so
				syncs.setDynamicSync[];
 			);	 			
 		);
 	};
	
	var generateAssignment:=method[x,i]
    {
    	// IMPORTANT NOTE AT TOP!
    	if ((x.getCurrentType[]).hasOwnCommBehaviour[]==true) return null;   
    	if !((core.overrideAssignment[])==null)
 		(
 			return core.generateAssignment[x,i];
 		); 	
    	computeDims[];  
    	computeEvenorOdd[getVariable[]];
    	var ni:=i;
    	if (i==null)
    	(
    		// no arguments, therefore is assigned to whole array and needs to be scattered!
    		if (((getVariable[]).getstoredtype[]).isshared[]==true)
    		(
    			generateAssignmentScatters[x,i,getVariable[],a,b];		
    			if (even==false) 
    			(
    				(x.getstoredtype[]).computeSize[];
    				var s1:=(x.getstoredtype[]).getSizeIndex[0];
    				var s2:=(x.getstoredtype[]).getSizeIndex[1];
    				
    				generateOddSend[x,totalprocesses - 1,(((s1.a % a.a) * s2.a) * totalprocesses),extra,s2.a];    			
    			);
				return true;
    		);
    	) else (    		    		
    	    // something in the index!
    	    var localornot:=computeLocalorNot[ni,parallelgeneratecounter - 1];    
    		if (localornot==true)
    		(
    			// local write    			
    			var newdims:=computeLocalDimensions[ni,parallelgeneratecounter - 1,getVariable[],a,b];    			
    			(getVariable[]).generateName[];
    			if (newdims :: unknown)
    			(
    				generateDynamicLocalDimensions[ni];
    			) else (    			
    				var oldn:=getnominvoke[];
    				setnominvoke[true];
    				((getVariable[]).getstoredtype[]).generateMethodInvoke[newdims];
    				setnominvoke[oldn];    				
    			);
    			output.add["="];
    			x.generateCode[];
    			output.add[";"];
    			output.newline[];  	    			
    			return true;
    		);    		    		
    		 
    		if (localornot==false)
    		(    			
    		    // global write
    		    var o:=i.top[];
 				if (!(o::Range)) o:=o.getValue[];
 				if (o.a == o.b)
 				(
    				generateSetOtherProcessValue[x,ni];    				
    			) else (    				
					generateDynamicSend[x,i];
 					output.newline[];
    			);
    			return true;
    		);
    		
    		if (localornot :: unknown)
    		(
    			// who knows?
    			generateDynamicLocalCheck[ni];
    			output.newline[];
    			output.add["{\n"];
    			(getVariable[]).generateName[];
    			generateDynamicLocalDimensions[ni];
    			output.add["="];
    			x.generateCode[];
    			output.add[";"];
    			output.newline[]; 
    			output.add["} else {\n"];
    			generateDynamicSend[x,i];
    			output.add["}\n"];
    			return true;
    		);
    	);
    };
    
    var generateDynamicReceive:=method[x,i]
    {
    	output.add["MESHrecvdynamic(&"];
    	x.generateCode[]; 		
    	output.add[",1,"];
 		(((getVariable[]).getstoredtype[]).getCoreType[]).generateMPIDeclaration[];
 		output.add[","];
 		output.add[((getVariable[]).getstoredtype[]).getSharedPoolID[]]; 					
 		output.add[",("];

 		(i.top[]).generateCode[];

 		output.add[") - ( ("];

 		var s1:=((getVariable[]).getstoredtype[]).getSizeIndex[0];

 		output.add[s1.a];
 		output.add["/"];
 		output.add[a.a];
 		output.add[") * ("];

 		(i.top[]).generateCode[];
 		output.add[") / ("];
 		s1:=((getVariable[]).getstoredtype[]).getSizeIndex[0];
 		output.add[s1.a];
 		output.add["/"];
 		output.add[a.a];
 		output.add[")) "];
 		if (dimensions > 0) 
 		(
 			output.add["+"];
 			(i.lget[1]).generateCode[]; 		 		
 		);
 		output.add[",("];
 		(i.top[]).generateCode[];
 		output.add[") / ("];
 		s1:=((getVariable[]).getstoredtype[]).getSizeIndex[0];
 		output.add[s1.a];
 		output.add["/"];
 		output.add[a.a];
 		output.add["));"];
    };
    
    var generateDynamicSend:=method[x,i]
    {
    	output.add["MESHsenddynamic(&"];
    	x.generateCode[]; 		
    	output.add[",1,"];
 		(((getVariable[]).getstoredtype[]).getCoreType[]).generateMPIDeclaration[];
 		output.add[","];
 		output.add[((getVariable[]).getstoredtype[]).getSharedPoolID[]]; 					
 		output.add[",("];

 		(i.top[]).generateCode[];

 		output.add[") - ( ("];

 		var s1:=((getVariable[]).getstoredtype[]).getSizeIndex[0];

 		output.add[s1.a];
 		output.add["/"];
 		output.add[a.a];
 		output.add[") * ("];

 		(i.top[]).generateCode[];
 		output.add[") / ("];
 		s1:=((getVariable[]).getstoredtype[]).getSizeIndex[0];
 		output.add[s1.a];
 		output.add["/"];
 		output.add[a.a];
 		output.add[")) "];
 		if (dimensions > 0) 
 		(
 			output.add["+"];
 			(i.lget[1]).generateCode[]; 		 		
 		);
 		output.add[",("];
 		(i.top[]).generateCode[];
 		output.add[") / ("];
 		s1:=((getVariable[]).getstoredtype[]).getSizeIndex[0];
 		output.add[s1.a];
 		output.add["/"];
 		output.add[a.a];
 		output.add["));"];
    };
    
    var optimiseMethodInvoke:=method[x]
    {
    	var localornot:=computeLocalorNot[x,currentparallelprocess - 1];
    	if (localornot==false)
    	(
    		var src:=getSourceProcess[x];
    		((getVariable[]).getstoredtype[]).computeSize[];
    		var sone:=((getVariable[]).getstoredtype[]).getSizeIndex[0];
    		if (dimensions > 0)
    		(
    			var stwo:=((getVariable[]).getstoredtype[]).getSizeIndex[1];   	    	
    		);
			var datasize:=1;
			if (x.getsize[]==1) datasize:=stwo;
			var arglist:=new ArrayList[];
			arglist.aadd[getVariable[]];
			arglist.aadd[x];
			arglist.aadd[currentparallelprocess - 1];
			arglist.aadd[a];
			arglist.aadd[b];	
			arglist.aadd[datasize];	
			syncs.add[src,this.generateSend,arglist];
			
			arglist:=new ArrayList[];
			arglist.aadd[getVariable[]];
			arglist.aadd[x];
			arglist.aadd[currentparallelprocess - 1];
			arglist.aadd[a];
			if (dimensions > 0) 
			(
				arglist.aadd[b];
			) else (
				arglist.aadd[null];
			);
			arglist.aadd[datasize];												
			syncs.add[src,this.generateReceive,arglist];
    	);
    };
    
    var generateMethodInvoke:=method[x]
    {    	
    	// is local? no - well easy, just get the data
    	
    	// gen code not  working atm as refering as 1d rather than 2d - fix it needing a 2d!
    	
    	// so that can generate corrected local array rather than the global one!
    	if (nominvoke==true) return false;
    	if ((x.getsize[])==0) return false;
    	var localornot:=computeLocalorNot[x,parallelgeneratecounter - 1];
    	if (localornot==true)
    	(
    		var dims:=computeLocalDimensions[x,parallelgeneratecounter - 1,getVariable[],a,b]; 
    		if (dims :: unknown)
    		(
    			generateDynamicLocalDimensions[x]; // this is a hack, might be able to determine the dimensions directly!
    		) else (
    			var oldv:=((getVariable[]).getstoredtype[]).getnominvoke[];
    			((getVariable[]).getstoredtype[]).setnominvoke[true];
    			((getVariable[]).getstoredtype[]).generateMethodInvoke[dims];
    			((getVariable[]).getstoredtype[]).setnominvoke[oldv];
    		);
    	) else (
	    	var src:=getSourceProcess[x];
    		
    		((getVariable[]).getstoredtype[]).computeSize[];
    		var sone:=((getVariable[]).getstoredtype[]).getSizeIndex[0];
    		if (dimensions > 0)
    		(
    			var stwo:=((getVariable[]).getstoredtype[]).getSizeIndex[1];   	    	
    		);
			var datasize:=1;
			if (x.getsize[]==1) datasize:=stwo;
			// do the memory allocation
			var fnname:=((output.getCurrentText[]).contents).aget[(output.getCurrentText[]).contents.getsize[] - 4];
			output.clearline[];
			output.newline[];
			if (datasize==1)
			(
				(((getVariable[]).getstoredtype[]).t).generateDeclaration[];
				output.add[" tempvariable"];
				output.add[MPIstatuscnt];
				output.add[";\n"];
			) else (
				((getVariable[]).getstoredtype[]).generateDeclaration[]; 
				output.add[" tempvariable"];
				output.add[MPIstatuscnt];
				output.add["= ("];
				((getVariable[]).getstoredtype[]).generateDeclaration[]; 
				output.add[" ) malloc(sizeof("];
				(((getVariable[]).getstoredtype[]).t).generateDeclaration[]; 
				output.add[") * "];
				output.add[datasize];
				output.add[");\n"];
			);
			// now the communication
 			output.add["MPI_Status rstat"];
 			output.add[MPIstatuscnt];
 			output.add[";\n"];
 			output.add["MPI_Recv(&tempvariable"];
 			output.add[MPIstatuscnt];
 			output.add[","];
 			output.add[datasize];
 			output.add[","];
 			(((getVariable[]).getstoredtype[]).getCoreType[]).generateMPIDeclaration[];
 			output.add[","];
 			output.add[getSourceProcess[x]];
 			output.add[",0,MPI_COMM_WORLD,&rstat"];
 			output.add[MPIstatuscnt];
 			output.add[");"];

			// below is function call
 			output.newline[];
 			output.add[fnname];
 			output.add["(&tempvariable"];
 			output.add[MPIstatuscnt];
 			output.add[");\n"];
 			
 			// now do the call to return the data to the source process
 			output.add["MPI_Send(&tempvariable"];
 			output.add[MPIstatuscnt];
 			output.add[","];
 			output.add[datasize];
 			output.add[","];
 			(((getVariable[]).getstoredtype[]).getCoreType[]).generateMPIDeclaration[];
 			output.add[","];
 			output.add[getSourceProcess[x]];
 			output.add[",0,MPI_COMM_WORLD"];
 			output.add[");"];
 			
 			// need to free structure lastly, then ignore till newline so does not add the );\n onto it
 			if (datasize != 1)
 			(
 				output.add["\nfree(tempvariable"];
 				output.add[MPIstatuscnt];
 				output.add[");"];
 			);
 			output.ignoretillnewline[];
 			MPIstatuscnt:=MPIstatuscnt + 1;
    	);    	    	
    };
    
    var generateDynamicLocalCheck:=method[i]
    {
    	var bitone:=i.lget[0];    	
    	var bittwo;
    	if (dimensions > 0)
    	(	
    		bittwo:=i.lget[1];
    	);
    	
    	computeDims[];
    	((getVariable[]).getstoredtype[]).computeSize[];
    	var sone:=((getVariable[]).getstoredtype[]).getSizeIndex[0];
    	if (dimensions > 0)
    	(
    		var stwo:=((getVariable[]).getstoredtype[]).getSizeIndex[1];
    	);
    	output.add["if (("];
    	if (a.a > 1)
    	(
    		bitone.generateCode[];
    		output.add[">= (myrank *("];    	
    		sone.generateCode[];
    		output.add["/"];
    		a.generateCode[];
    		output.add["))) && ("];
    		bitone.generateCode[];
    		output.add["<= ((myrank *("];
    		sone.generateCode[];
    		output.add["/"];
    		a.generateCode[];
    		output.add["))+("];
    		sone.generateCode[];
    		output.add["/"];
    		a.generateCode[];
    		output.add[") - 1))"];
    	);
    	if (dimensions > 0)
    	(
    	if (b.a > 1)
    	(
    		if (a.a > 1) output.add["&& ("];
    		bittwo.generateCode[];
    		output.add[">= (myrank *("];    	
    		stwo.generateCode[];
    		output.add["/"];
    		b.generateCode[];
    		output.add["))) && ("];
    		bittwo.generateCode[];
    		output.add["<= ((myrank *("];
    		stwo.generateCode[];
    		output.add["/"];
    		b.generateCode[];
    		output.add["))+("];
    		stwo.generateCode[];
    		output.add["/"];
    		b.generateCode[];
    		output.add[") - 1))"];
    	);
    	);
    	output.add[")"];
    };
    
    var generateDynamicLocalDimensions:=method[i]
    {
    	output.add["[((("];
    	var bitone:=i.lget[0];    	
    	var bittwo;
    	if (dimensions > 0) bittwo:=i.lget[1];
    	computeDims[];
    	((getVariable[]).getstoredtype[]).computeSize[];
    	var sone:=((getVariable[]).getstoredtype[]).getSizeIndex[0];
    	if (dimensions > 0)
    	(
    		var stwo:=((getVariable[]).getstoredtype[]).getSizeIndex[1];
    	);
    	bitone.generateCode[];    	
    	if (dimensions > 0)
    	(
    		output.add["*"];
    		stwo.generateCode[];
    	);
    	output.add[")"];
    	if (a.a > 1)
    	(
    		output.add["- ((myrank *("];    	
    		sone.generateCode[];
    		output.add["/"];
    		a.generateCode[];
    		output.add[")))"];
    		if (dimensions > 0)
    		(
    			output.add["*"];
    			stwo.generateCode[];
    		);
    		output.add[")"];
    	) else (
    		output.add[")"];	// closing brace
    	);
    	if !(bittwo==null)
    	(
    		output.add["+("];    	
    		bittwo.generateCode[];
    		if (b.a > 1)
    		(
    			output.add["- (myrank *("];    	
    			stwo.generateCode[];
    			output.add["/"];
    			b.generateCode[];
    			output.add[")))"];
    		) else (
    			output.add[")"];
    		)
    	);
    	output.add[")]"];
    };
    
    var computeLocalDimensions:=method[i,p,v,pa,pb]
    {
    	// first, assume 2d array!   
    	var returnstack:=new stack[];    	
    	var returnone:=0;
    	var returntwo:=0;
    	var bitone:=i.lget[0];
    	if (!(bitone :: Range) && (!(bitone==null))) bitone:=bitone.getValue[];  
    	var bittwo;    	
    	if !(pb == null)
    	(
    	bittwo:=i.lget[1];
    	if (!(bittwo :: Range) && (!(bittwo==null))) bittwo:=bittwo.getValue[];    	    	
    	);
    	if (bitone :: Range)
    	(
    		if (bitone.a != bitone.b) return new unknown;
    	);
    	if (bittwo :: Range)
    	(
    		 if (bittwo.a != bittwo.b) return new unknown;
    	);    
    	//computeDims[];
    	(v.getstoredtype[]).computeSize[];
    	var sone:=(v.getstoredtype[]).getSizeIndex[0];
    	if !(pb ==null)
    	(
    		var stwo:=(v.getstoredtype[]).getSizeIndex[1];  
    	);
		if !(bitone==null)
		(		
    	if (pa.a > 1)
    	(
    		var eone:=sone.a % pa.a;    	
    		var starting:=p * eone;    
    		returnone:=bitone.a - starting;
    	) else (
    		returnone:=bitone.a;
    	);
    	returnstack.push[new Range[returnone,returnone]];
    	);
    	if !(bittwo==null)
    	(
    	if (pb.a > 1)
    	(
	    	var etwo:=stwo.a % pb.a;
    		starting:=p * etwo;
    		returntwo:=bittwo.a - starting;
    		returnstack.laddtotail[new Range[returntwo,returntwo]];
    	) else (    		
    		if (bittwo :: unknown)
    		(
    			returntwo:=i.lget[1];
    			returnstack.laddtotail[returntwo];
    		) else (
    			returntwo:=bittwo.a;
    			returnstack.laddtotail[new Range[returntwo,returntwo]];
    		);
    	);    	
    	
    	);
    	return returnstack;
    };
    
    var computeLocalorNot:=method[i,p]
    {
    	// first, assume 2d array!
    	var bitone:=i.lget[0];
    	if !(bitone :: Range) bitone:=bitone.getValue[];     
    	var bittwo;
    	if (dimensions > 0)
    	(	  	
    		bittwo:=i.lget[1];
    		if ((!(bittwo :: Range)) && (!(bittwo==null)) ) bittwo:=bittwo.getValue[];
    	);
    	if ((bitone :: unknown) || (bittwo :: unknown)) return new unknown;
    	computeDims[];
    	((getVariable[]).getstoredtype[]).computeSize[];
    	var sone:=((getVariable[]).getstoredtype[]).getSizeIndex[0];
    	if (dimensions > 0)
    	(
    		var stwo:=((getVariable[]).getstoredtype[]).getSizeIndex[1];   	    	
    	);
    	if !(bitone==null)
    	(
    	if (a.a > 1)
    	(
    		var eone:=sone.a % a.a;    	
    		var starting:=p * eone;
    		var ending:=(starting + eone) - 1;
    		if (bitone.a !=bitone.b)
    		(    			
    			// range analysis - if both false, then false, if either then unknown else true
    			if (((bitone.a < starting) || (bitone.a > ending)) && ((bitone.b < starting) || (bitone.b > ending))) return false;
    			if ((bitone.a < starting) || (bitone.a > ending)) return new unknown;
    			if ((bitone.b < starting) || (bitone.b > ending)) return new unknown;
    		) else (
    			if ((bitone.a < starting) || (bitone.a > ending)) return false;
    		);
    	);
    	);
    	if (dimensions > 0)
    	(
    		if !(bittwo==null)
    		(
    		if (b.a > 1)
    		(
	    	var etwo:=stwo.a % b.a;
    		starting:=p * etwo;
    		ending:=(starting + etwo) - 1;
    		
    		if (bittwo.a !=bittwo.b)
    		(
    			if (((bittwo.a < starting) || (bittwo.a > ending)) && ((bittwo.b < starting) || (bittwo.b > ending))) return false;
    			if ((bittwo.a < starting) || (bittwo.a > ending)) return new unknown;
    			if ((bittwo.b < starting) || (bittwo.b > ending)) return new unknown;
    		) else (
    			if ((bittwo.a < starting) || (bittwo.a > ending)) return false;
    		);
    		    		
    		);
    		);
    	);
    	return true;
    };
    
    var generateOddReceive:=method[x,r,q,e,s2]
    {
    	var coresize:=((x.getstoredtype[]).getCoreType[]).getstoredtype[];
    	output.add["MPI_Status rstat"];
 		output.add[MPIstatuscnt];
 		output.add[";\n"]; 		
    	output.add["MPI_Recv(&"];
 		x.generateName[];
 		output.add["["];
 		output.add[q - 1]; 		 		
 		output.add["],"];
 		output.add[e * s2];
 		output.add["*"];
		output.add[coresize.getSize[]];
 		output.add[","];
 		((x.getstoredtype[]).getCoreType[]).generateMPIDeclaration[];
 		output.add[","];
 		output.add[r];
 		output.add[",0,MPI_COMM_WORLD,&rstat"];
 		output.add[MPIstatuscnt];
 		MPIstatuscnt:=MPIstatuscnt + 1;
 		output.add[");\n"];
    };
    
    var generateOddSend:=method[x,r,q,e,s2]
    {
    	var coresize:=((x.getstoredtype[]).getCoreType[]).getstoredtype[];
    	output.add["MPI_Send(&"];
 		x.generateName[];
 		output.add["["];
 		output.add[q - 1]; 		 		
 		output.add["],"];
 		output.add[e * s2];
 		output.add["*"];
		output.add[coresize.getSize[]];
 		output.add[","];
 		((x.getstoredtype[]).getCoreType[]).generateMPIDeclaration[];
 		output.add[","];
 		output.add[r];
 		output.add[",0,MPI_COMM_WORLD);\n"];
    };
    
    var generateAccessGather:=method[x,i,v,pa,pb]
    {
    //	if (((getVariable[]).getstoredtype[]).isshared[]==true)
    //	(    
    		var newstack:=new stack[];    		
    		output.add["MPI_Gather (&"];
    		
    		var oldn:=(v.getstoredtype[]).getnominvoke[];
	 		(v.getstoredtype[]).setnominvoke[true];
 			v.generateMethodInvoke[newstack];
 			(v.getstoredtype[]).setnominvoke[oldn];	    		
			output.add[","];
			var s1:=(v.getstoredtype[]).getSizeIndex[0];
			var s2:=(v.getstoredtype[]).getSizeIndex[1];
			var coresize:=((v.getstoredtype[]).getCoreType[]).getstoredtype[];	// ASSUMES AS IN FFT IS A record type for the array type
			displaySize[s1,s2,pa,pb];
			output.add["*"];
			output.add[coresize.getSize[]];
		
			output.add[","];
			((v.getstoredtype[]).getCoreType[]).generateMPIDeclaration[];		
			output.add[",&"];
			x.generateMethodInvoke[newstack];		
			output.add[","];
			displaySize[s1,s2,pa,pb];
			output.add["*"];
			output.add[coresize.getSize[]];
			
			output.add[", "];
			((v.getstoredtype[]).getCoreType[]).generateMPIDeclaration[];
			output.add[","];
			output.add["0"];	// fudge that p=0 is root initially!
			output.add[",MPI_COMM_WORLD);\n"];
			output.add["MPI_Barrier(MPI_COMM_WORLD);"];
			output.newline[];						
    //	);
    };
    
    var generateAssignmentScatters:=method[x,i,v,pa,pb]
    {
    //	if (((getVariable[]).getstoredtype[]).isshared[]==true)
    //	(    
    		var newstack:=new stack[];    		
    		output.add["MPI_Scatter (&"];
    		x.generateMethodInvoke[newstack];		
			output.add[","];
			var s1:=(v.getstoredtype[]).getSizeIndex[0];
			var s2:=(v.getstoredtype[]).getSizeIndex[1];
			var coresize:=((v.getstoredtype[]).getCoreType[]).getstoredtype[];	// ASSUMES AS IN FFT IS A record type for the array type
			displaySize[s1,s2,pa,pb];
			output.add["*"];
			output.add[coresize.getSize[]];
		
			output.add[","];
			((v.getstoredtype[]).getCoreType[]).generateMPIDeclaration[];
		
			output.add[",&"];
			var oldn:=(v.getstoredtype[]).getnominvoke[];
	 		(v.getstoredtype[]).setnominvoke[true];
 			v.generateMethodInvoke[newstack];
 			(v.getstoredtype[]).setnominvoke[oldn];	
			output.add[","];
			displaySize[s1,s2,pa,pb];
			output.add["*"];
			output.add[coresize.getSize[]];
			
			output.add[", "];
			((v.getstoredtype[]).getCoreType[]).generateMPIDeclaration[];
			output.add[","];
			output.add["0"];	// fudge that p=0 is root initially!
			output.add[",MPI_COMM_WORLD);\n"];
			output.add["MPI_Barrier(MPI_COMM_WORLD);"];
			output.newline[];						
    //	);
    };
	
	var getDimensionIndex:=method[x] 
    (
    	computeDims[];
    	if (x==0) return a;
    	if (x==1) return b;
    	return null;
    );
	
	var valid1:=method[] 
	(
		if (!alone) (core.valid8[];)	
	);		
	
	var valid2:=method[] 
	(
		if (!alone) (core.valid8[];)	
	);	
	
	var valid4:=method[] 
	(
		if (!alone) (core.valid8[];)	
	);
	
	var valid5:=method[] 
	(
		if (!alone) (core.valid8[];)	
	);
	
	var valid9:=method[] 
	(
		if (!alone) (core.valid8[];)	
	);
	
	var check:=method[v]
	(
		if (v::thisclass) (return true;);
		return core.check[v];
	);
);