/*
File created 21/1/2008 by Nick Brown

Basic Communication - acts as an abstract class thing for many methods in the communication
*/

var basiccomm:=class rootType
(
	var sendtempvar:=0;
	var generateBcastIndex:=method[i,root,mevar]
	{
		output.add["int tempvar"];
 		output.add[MPIstatuscnt];
 		output.add[";\n"];
 		
 		output.add["MPI_Bcast(&tempvar"];
 		output.add[MPIstatuscnt];
 		output.add[",1,MPI_INT,"];
 		output.add[root];
 		output.add[",MPI_COMM_WORLD);\n"];
		MPIstatuscnt := MPIstatuscnt + 1;
		return MPIstatuscnt - 1;
	};
	
	var generateGather:=method[x,r,root,elements]
	{
		generateComplexGather[x,new stack[],r,root,elements,"MPI_COMM_WORLD",""];
	};
	
	var generateScatterCode:=method[x,i,r,root,elements,comm1,comm2]
	{
		output.add["MPI_Scatter(&"];
		x.generateMethodInvoke[new stack];
		output.add[","];
		output.add[elements];
		output.add[","];
		((x.getstoredtype[]).getCoreType[]).generateMPIDeclaration[];
		output.add[",&"];
		r.generateMethodInvoke[i];
		output.add[","];
		output.add[elements];
		output.add[","];
		((r.getstoredtype[]).getCoreType[]).generateMPIDeclaration[];
		output.add[","];
		root.generateCode[];
		output.add[","];
		output.add[comm1];
		output.add[comm2];
		output.add[");\n"];
		misc.performCommErrorCheck[];
	};
	
	var generateComplexScatter:=method[x,i,r,root,elements]
	{
		generateScatterCode[x,i,r,root,elements,"MPI_COMM_WORLD",""];
	};
	
	var generateComplexGroupScatter:=method[x,i,r,root,elements,theworld]
	{
		var grouproot:=theworld.getGroupRank[root];
		generateScatterCode[x,i,r,new Range[grouproot,grouproot],elements,"MESH_COMM_VAR",theworld.getCommId[]];
	};
	
	var generateStringScatter:=method[x,i,r,root,elements,s,temptransposecount]
	{
		output.add["MPI_Scatter(&"];
		output.add[s];
		output.add[temptransposecount];
		output.add[","];
		output.add[elements];
		output.add[","];
		((x.getstoredtype[]).getCoreType[]).generateMPIDeclaration[];
		output.add[",&"];
		r.generateMethodInvoke[i];
		output.add[","];
		output.add[elements];
		output.add[","];
		((r.getstoredtype[]).getCoreType[]).generateMPIDeclaration[];
		output.add[","];		
		root.generateCode[];
		output.add[",MPI_COMM_WORLD);\n"];
		misc.performCommErrorCheck[];
	};
	
	var generateStringGather:=method[x,i,r,root,elements,s,temptransposecount]
	{
		output.add["MPI_Gather("];
		output.add[s];
		output.add[temptransposecount];
		output.add[","];
		output.add[elements];
		output.add[","];
		((x.getstoredtype[]).getCoreType[]).generateMPIDeclaration[];
		output.add[",&"];
		r.generateMethodInvoke[i];
		output.add[","];
		output.add[elements];
		output.add[","];
		((r.getstoredtype[]).getCoreType[]).generateMPIDeclaration[];
		output.add[","];
		root.generateCode[];
		output.add[",MPI_COMM_WORLD);\n"];
		misc.performCommErrorCheck[];
	};
	
	var generateGatherCode:=method[x,i,r,root,elements,comm1,comm2]
	{
		output.add["MPI_Gather(&"];
		x.generateMethodInvoke[new stack];
		output.add[","];
		output.add[elements];
		output.add[","];
		((x.getstoredtype[]).getCoreType[]).generateMPIDeclaration[];
		output.add[",&"];
		r.generateMethodInvoke[i];
		output.add[","];
		output.add[elements];
		output.add[","];
		((r.getstoredtype[]).getCoreType[]).generateMPIDeclaration[];
		output.add[","];
		root.generateCode[];
		output.add[","];
		output.add[comm1];
		output.add[comm2];
		output.add[");\n"];
		misc.performCommErrorCheck[];
	};
	
	var generateComplexGroupGather:=method[x,i,r,root,elements,theworld]
	{
		var grouproot:=theworld.getGroupRank[root];
		generateGatherCode[x,i,r,new Range[grouproot,grouproot],elements,"MESH_COMM_VAR",theworld.getCommId[]];
	};
	
	var generateComplexGather:=method[x,i,r,root,elements]
	{
		generateGatherCode[x,i,r,root,elements,"MPI_COMM_WORLD",""];
	};
	
	var generateScatter:=method[x,r,root,elements]
	{
		generateComplexScatter[x,new stack[],r,root,elements];
	};
	
	var generateSBcastIndex:=method[i,root,mevar]
	{
		output.add["int tempvar"];
 		output.add[MPIstatuscnt];
 		output.add["="];
 		(i.top[]).generateCode[];
 		if (i.getsize[]==2)
 		(
 			output.add["*"];
 			output.add[((mevar).getstoredtype[]).getSizeIndex[1]];
 			output.add["+"];
 			i.lget[1].generateCode[];
 		);
 		output.add[";\n"];
 		output.add["MPI_Bcast(&tempvar"];
 		output.add[MPIstatuscnt];
 		output.add[",1,MPI_INT,"];
 		output.add[root];
 		output.add[",MPI_COMM_WORLD);\n"];
		MPIstatuscnt := MPIstatuscnt + 1;
		return MPIstatuscnt - 1;
	};
	
	var generateRecvIndexandBcast:=method[i,root,mevar]
	{
		var idex:=generateBcastIndex[i,root,mevar];
		generateBcast[i,root,mevar,idex];
	};
	
	var generateSendIndexandBcast:=method[i,root,mevar]
	{
		var idex:=generateSBcastIndex[i,root,mevar];
		generateBcast[i,root,mevar,null];
	};
	
	var generateGroupBcast:=method[x,root,mevar,theworld]
	{
		var grouproot:=theworld.getGroupRank[root];
		generateBcastCode[x,grouproot,mevar,null,"MESH_COMM_VAR",theworld.getCommId[]];
	};
	
	var generateBcastCode:=method[i,root,mevar,idex,comm,commid]
	{
		var thesizeofdata:=((mevar).getstoredtype[]).getSizeIndex[1];
 		if  (thesizeofdata==null) thesizeofdata:=new Range[1,1];
 		var numberofargs;
 		var thearrayindextoread;	// for which process to read from
 		if (i==null)
 		(
 			numberofargs:=0;
 			thesizeofdata:=new Range[(mevar.getstoredtype[]).getSize[],(mevar.getstoredtype[]).getSize[]];
 		) else (
 			numberofargs:=i.getsize[];	// number of arguments passed in i.e. g#r#t = 2
 			if (numberofargs==2) thesizeofdata:=new Range[1,1];
 		);

 		var newstack:=new stack[]; 	// for x generateMethodInvoke - called twice
 		
 		if (!(i==null))
 		(
 			thearrayindextoread:=i.top[];	// only issue top as we need the complete stack if want to call generateMethodInvoke in dynamic check below
 		);
 		
 		//if (!(i==null)) i.pop[];	// now remove the top element in the stack as no longer need the complete stack :)
 		
		output.add["MPI_Bcast(&"];
		if (i==null)
		(
			if ((mevar.getstoredtype[]).getSize[].a==1)
			(
				mevar.generateCode[];
			) else (
				mevar.generateMethodInvoke[new stack[]];
			);
		) else (
			if (idex==null)
			(
				mevar.generateMethodInvoke[i];
			) else (
				mevar.generateName[];
				output.add["[tempvar"];
				output.add[idex];
				output.add["]"];
			);
		);
		output.add[","];
		
		//output.add[thesizeofdata];	// for now colour is number of elements
		if (((mevar.getCurrentType[]).check[String])==true)
		(
			output.add["strlen("];
			mevar.generateCode[];
			output.add[")"];
		) else (
			thesizeofdata.generateCode[];		
		);
		output.add[","];
		((mevar.getstoredtype[]).getCoreType[]).generateMPIDeclaration[];
		output.add[","];		
		output.add[root];
		output.add[","];
		output.add[comm];
		output.add[commid];
		output.add[");"];		
		output.newline[];				
		misc.performCommErrorCheck[];
	};
	
	var generateBcast:=method[i,root,mevar,idex]
	{
		generateBcastCode[i,root,mevar,idex,"MPI_COMM_WORLD",""];
	};
	
	var generateSendIndexandRecv:=method[x,i,root,mevar]
	{
		var idex:=generateSendIndex[x,i,root,mevar];
		generateRecv[x,i,root,mevar,null];
	};
	
	var generateIndexandRecv:=method[x,i,root,mevar]
	{
		var idex:=generateRecvIndex[x,i,root,mevar];
		generateRecv[x,i,root,mevar,idex];
	};
	
	var generateSendIndex:=method[x,i,root,mevar]
	{
		output.add["int tempvar"];
 		output.add[MPIstatuscnt];
 		output.add["="];
 		(i.top[]).generateCode[];
 		if (i.getsize[]==2)
 		(
 			output.add["*"];
 			output.add[((mevar).getstoredtype[]).getSizeIndex[1]];
 			output.add["+"];
 			i.lget[1].generateCode[];
 		);
 		output.add[";\n"];
 		
 		output.add["MPI_Send(&tempvar"];
 		output.add[MPIstatuscnt];
 		output.add[",1,MPI_INT,"];
 		output.add[root];
 		output.add[",0,MPI_COMM_WORLD);\n"];
	};
	
	var generateRecvIndex:=method[x,i,root,mevar]
	{		 		
 		output.add["MPI_Status rstat"];
 		output.add[MPIstatuscnt];
 		output.add[";\n"]; 		
 		output.add["int tempvar"];
 		output.add[MPIstatuscnt];
 		output.add[";\n"];
 		
 		output.add["MPI_Recv(&tempvar"];
 		output.add[MPIstatuscnt];
 		output.add[",1,MPI_INT,"];
 		output.add[root];
 		output.add[",0,MPI_COMM_WORLD,&rstat"];
 		output.add[MPIstatuscnt];		
		output.add[");\n"];
		MPIstatuscnt := MPIstatuscnt + 1;
		return MPIstatuscnt - 1;
	};
	
	var generateASyncRecv:=method[x,i,root,mevar,idex]
	{
		if (mevar.hasBeenDeclared[]==false)
 		(
 			mevar.generateCode[];
 			output.add[";\n"];
 		);
		var thesizeofdata:=((mevar).getstoredtype[]).getSizeIndex[1];
 		if  (thesizeofdata==null) thesizeofdata:=Range[1,1];
 		
 		var numberofargs;
 		var thearrayindextoread;	// for which process to read from
 		if (i==null)
 		(
 			numberofargs:=0;
 			thesizeofdata:=new Range[(mevar.getstoredtype[]).getSize[],(mevar.getstoredtype[]).getSize[]];
 		) else (
 			numberofargs:=i.getsize[];	// number of arguments passed in i.e. g#r#t = 2
 			if (numberofargs > =2) thesizeofdata:=new Range[1,1];
 		);

 		var newstack:=new stack[]; 	// for x generateMethodInvoke - called twice
 		
 		if (!(i==null))
 		(
 			thearrayindextoread:=i.top[];	// only issue top as we need the complete stack if want to call generateMethodInvoke in dynamic check below
 		);
 		 		
 		output.add["{MPI_Request MESHasyncrequest;\n"];
 		
		output.add["MPI_Irecv(&"];
		if (i==null)
		(
			mevar.generateMethodInvoke[new stack[]];
		) else (
			if (idex==null)
			(
				mevar.generateMethodInvoke[i];				
			) else (
				mevar.generateName[];
				output.add["[tempvar"];
				output.add[idex];
				output.add["]"];
			);
		);
		output.add[","];
		
		//output.add[thesizeofdata];	// for now colour is number of elements
		thesizeofdata.generateCode[];
		output.add[","];
		((mevar.getstoredtype[]).getCoreType[]).generateMPIDeclaration[];
		output.add[","];
		if (root :: Int)
		(
			output.add[root];
		) else (
			root.generateCode[];
		);
		output.add[",0,MPI_COMM_WORLD,&MESHasyncrequest);\nMESHRegisterAsyncRequestAndMemCpy(&MESHasyncrequest,\""];		
		mevar.generateName[];
		output.add["\\0\",&"];
		x.generateMethodInvoke[new stack[]];		
		output.add[",&"];
		mevar.generateMethodInvoke[new stack[]];
		// need size here
		output.add[",sizeof("];
		output.add[mevar.getstoredtype[].getCoreType[].getDeclaration[]];
    	output.add[") * "];
    	thesizeofdata.generateCode[];	
    	output.add[","];
		output.add["\""];
		x.generateName[];
		output.add["\\0\""];
		output.add[");}"];
		output.newline[];
		mevar.setDirty[true];
		x.setDirty[true];
		misc.addDirtyandLink[mevar,x];		
		misc.performCommErrorCheck[];
	};
	
	var generateRecv:=method[x,i,root,mevar,idex]
	{		
		if (mevar.hasBeenDeclared[]==false)
 		(
 			mevar.generateCode[];
 			output.add[";\n"];
 		);
		var thesizeofdata:=((mevar).getstoredtype[]).getSizeIndex[1];
 		if  (thesizeofdata==null) thesizeofdata:=Range[1,1];
 		
 		var numberofargs;
 		var thearrayindextoread;	// for which process to read from
 		if (i==null)
 		(
 			numberofargs:=0;
 			thesizeofdata:=new Range[(mevar.getstoredtype[]).getSize[],(mevar.getstoredtype[]).getSize[]];
 		) else (
 			numberofargs:=i.getsize[];	// number of arguments passed in i.e. g#r#t = 2
 			if (numberofargs > =2) thesizeofdata:=new Range[1,1];
 		);

 		var newstack:=new stack[]; 	// for x generateMethodInvoke - called twice
 		
 		if (!(i==null))
 		(
 			thearrayindextoread:=i.top[];	// only issue top as we need the complete stack if want to call generateMethodInvoke in dynamic check below
 		);
 		 		
 		output.add["MPI_Status rstat"];
 		output.add[MPIstatuscnt];
 		output.add[";\n"]; 		
 		
 		
		output.add["MPI_Recv(&"];
		if (i==null)
		(
			mevar.generateMethodInvoke[new stack[]];
		) else (
			if (idex==null)
			(
				mevar.generateMethodInvoke[i];				
			) else (
				mevar.generateName[];
				output.add["[tempvar"];
				output.add[idex];
				output.add["]"];
			);
		);
		output.add[","];
		
		//output.add[thesizeofdata];	// for now colour is number of elements
		thesizeofdata.generateCode[];
		output.add[","];
		((mevar.getstoredtype[]).getCoreType[]).generateMPIDeclaration[];
		output.add[","];
		if (root :: Int)
		(
			output.add[root];
		) else (
			root.generateCode[];
		);
		output.add[",0,MPI_COMM_WORLD,&rstat"];
 		output.add[MPIstatuscnt];		
		output.add[");"];		
		MPIstatuscnt:=MPIstatuscnt + 1;
		output.newline[];
		misc.performCommErrorCheck[];
	};
	
	
	var generateRecvIndexandSend:=method[x,i,root,mevar,whichindex]
	{
		var idex:=generateRecvIndex[x,i,root,mevar];
		generateSend[x,i,root,mevar,whichindex,idex];
	};
	
	
	var generateIndexandSend:=method[x,i,root,mevar,whichindex]
	{
		var idex:=generateSendIndex[x,i,root,mevar];
		generateSend[x,i,root,mevar,whichindex,null];
	};
	
	var generateSend:=method[x,i,root,mevar,whichindex,idex]
	{		
		if ((x.isavariable[]) == false)
		(			
			x.getCurrentType[].generateDeclaration[];
			output.add[" tempsendvar"];
			output.add[sendtempvar];
			output.add["="];
			x.generateCode[];
			output.add[";\n"];
		) else (
		/*
			if (x.hasBeenDeclared[]==false)
 			(
 				x.generateCode[];
 				output.add[";\n"];
 			);
 		*/
 		skip;
 		);
		var thesizeofdata:=((mevar).getstoredtype[]).getSizeIndex[1];
 		if  (thesizeofdata==null) thesizeofdata:=Range[1,1];
 		
 		var numberofargs;
 		var thearrayindextoread;	// for which process to read from
 		if (i==null)
 		(
 			numberofargs:=0;
 			thesizeofdata:=new Range[(mevar.getstoredtype[]).getSize[],(mevar.getstoredtype[]).getSize[]];
 		) else (
 			numberofargs:=i.getsize[];	// number of arguments passed in i.e. g#r#t = 2
 			if (numberofargs >= ((mevar).getstoredtype[]).getDimensions[]) thesizeofdata:=new Range[1,1];
 		);

 		var newstack:=new stack[]; 	// for x generateMethodInvoke - called twice
 		
 		if (!(i==null))
 		(
 			thearrayindextoread:=i.top[];	// only issue top as we need the complete stack if want to call generateMethodInvoke in dynamic check below
 		); 		 		
		output.add["MPI_Send(&"];
		if ((x.isavariable[]) == true)
		(
			if (whichindex==null || i==null)
			(
				x.generateMethodInvoke[newstack];
			) else (
				if (idex==null)
				(
					x.generateMethodInvoke[i];
				) else (
					x.generateName[];
					output.add["[tempvar"];
					output.add[idex];
					output.add["]"];
				);
		
			);
		) else (
			output.add["tempsendvar"];
			output.add[sendtempvar];
			sendtempvar:=sendtempvar + 1;
		);
		output.add[","];
		
		//output.add[thesizeofdata];	// for now colour is number of elements
		thesizeofdata.generateCode[];
		output.add[","];
		((mevar.getstoredtype[]).getCoreType[]).generateMPIDeclaration[];
		output.add[","];
		if (root :: Int)
		(
			output.add[root];
		) else (
			root.generateCode[];
		);
		output.add[",0,MPI_COMM_WORLD);"];		
		output.newline[];
		misc.performCommErrorCheck[];
	};
	
	var generateASyncSend:=method[x,i,root,mevar]
	{
		if ((x.isavariable[]) == false)
		(			
			x.getCurrentType[].generateDeclaration[];
			output.add[" tempsendvar"];
			output.add[sendtempvar];
			output.add["="];
			x.generateCode[];
			output.add[";\n"];
		);
		
		var thesizeofdata:=((mevar).getstoredtype[]).getSizeIndex[1];
 		if  (thesizeofdata==null) thesizeofdata:=Range[1,1];
 		
 		var numberofargs;
 		var thearrayindextoread;	// for which process to read from
 		if (i==null)
 		(
 			numberofargs:=0;
 			thesizeofdata:=new Range[(mevar.getstoredtype[]).getSize[],(mevar.getstoredtype[]).getSize[]];
 		) else (
 			numberofargs:=i.getsize[];	// number of arguments passed in i.e. g#r#t = 2
 			if (numberofargs >= ((mevar).getstoredtype[]).getDimensions[]) thesizeofdata:=new Range[1,1];
 		);
		
		output.add["{MPI_Request MESHasyncRequest;\nMPI_Isend(&"];
		if ((x.isavariable[]) == true)
		(
			x.generateMethodInvoke[i];
		) else (
			output.add["tempsendvar"];
			output.add[sendtempvar];
			sendtempvar:=sendtempvar + 1;
		);
		output.add[","];
		thesizeofdata.generateCode[];
		output.add[","];
		((mevar.getstoredtype[]).getCoreType[]).generateMPIDeclaration[];
		output.add[","];
		if (root :: Int)
		(
			output.add[root];
		) else (
			root.generateCode[];
		);
		output.add[",0,MPI_COMM_WORLD,&MESHasyncRequest);\nMESHRegisterAsyncRequest(&MESHasyncRequest,\""];		
		mevar.generateName[];
		output.add["\\0\");}"];
		output.newline[];
		misc.addASyncVar[mevar];
		misc.performCommErrorCheck[];		
	};
	
	var generateStringSend:=method[x,i,root,mevar,whichindex,idex,s,temptransposecount]
	{		
		var thesizeofdata:=((mevar).getstoredtype[]).getSizeIndex[1];
 		if  (thesizeofdata==null) thesizeofdata:=Range[1,1];
 		
 		var numberofargs;
 		var thearrayindextoread;	// for which process to read from
 		if (i==null)
 		(
 			numberofargs:=0;
 			thesizeofdata:=new Range[(mevar.getstoredtype[]).getSize[],(mevar.getstoredtype[]).getSize[]];
 		) else (
 			numberofargs:=i.getsize[];	// number of arguments passed in i.e. g#r#t = 2
 			if (numberofargs>=2) thesizeofdata:=new Range[1,1];
 		);

 		var newstack:=new stack[]; 	// for x generateMethodInvoke - called twice
 		
 		if (!(i==null))
 		(
 			thearrayindextoread:=i.top[];	// only issue top as we need the complete stack if want to call generateMethodInvoke in dynamic check below
 		); 		
 		
		output.add["MPI_Send(&"];
		output.add[s];
		output.add[temptransposecount];
		output.add[","];
		
		//output.add[thesizeofdata];	// for now colour is number of elements
		thesizeofdata.generateCode[];
		output.add[","];
		((mevar.getstoredtype[]).getCoreType[]).generateMPIDeclaration[];
		output.add[","];
		output.add[root];
		output.add[",0,MPI_COMM_WORLD);"];		
		output.newline[];
		misc.performCommErrorCheck[];
	};
	
	var generateDynamicBcast:=method[x,i]
    {
    	output.add["MESHbcastdynamic(&"];
    	x.generateCode[]; 		
    	output.add[",1,"];
 		(((getVariable[]).getstoredtype[]).getCoreType[]).generateMPIDeclaration[];
 		output.add[","];
 		output.add[((getVariable[]).getstoredtype[]).getSharedPoolID[]]; 
 		output.add[","];
 		if !(i==null)
 		(
 			var sizeofarg:=i.getsize[];
 			if (sizeofarg==1) (i.top[]).generateCode[];
 			if (sizeofarg==2)
 			(
 				(i.top[]).generateCode[];
 				output.add["*"];
 				output.add[((getVariable[]).getstoredtype[]).getSizeIndex[1]];
 				output.add["+"];
 				i.lget[1].generateCode[]; 			
 			);
 		) else (
 			output.add["0"];
 		);
 		output.add[",MPI_COMM_WORLD"];
 		output.add[");"];
 		output.newline[];
    };
    
    var generateDynamicSend:=method[x,i,dest]
    {
    	output.add["MESHsenddynamic(&"];
    	x.generateCode[]; 		
    	output.add[",1,"];
 		(((getVariable[]).getstoredtype[]).getCoreType[]).generateMPIDeclaration[];
 		output.add[","];
 		output.add[((getVariable[]).getstoredtype[]).getSharedPoolID[]]; 
 		output.add[","];
 		if !(i==null)
 		(
 			var sizeofarg:=i.getsize[];
 			if (sizeofarg==1) (i.top[]).generateCode[];
 			if (sizeofarg==2)
 			(
 				(i.top[]).generateCode[];
 				output.add["*"];
 				output.add[((getVariable[]).getstoredtype[]).getSizeIndex[1]];
 				output.add["+"];
 				i.lget[1].generateCode[];
 			
 			);
 		) else (
 			output.add["0"];
 		);
 		output.add[","];
 		output.add[dest];
 		output.add[");"];
 		output.newline[];
    };
    
     var generateDynamicRecv:=method[x,i,dest]
    {
    	if (x.hasBeenDeclared[]==false)
 		(
 			x.generateCode[];
 			output.add[";\n"];
 		);
    	output.add["MESHrecvdynamic(&"];
    	x.generateCode[]; 		
    	output.add[",1,"];
 		(((getVariable[]).getstoredtype[]).getCoreType[]).generateMPIDeclaration[];
 		output.add[","];
 		output.add[((getVariable[]).getstoredtype[]).getSharedPoolID[]]; 
 		output.add[","];
 		if !(i==null)
 		(
 			var sizeofarg:=i.getsize[];
 			if (sizeofarg==1) (i.top[]).generateCode[];
 			if (sizeofarg==2)
 			(
 				(i.top[]).generateCode[];
 				output.add["*"]; 				 					
 				output.add[((getVariable[]).getstoredtype[]).getSizeIndex[1]];
 				output.add["+"];
 				i.lget[1].generateCode[]; 			
 			)
 		) else (
 			output.add["0"];
 		);	
 		output.add[","];
 		//output.add[dest];
 		if (dest :: Range)
 		(
 			output.add[dest.a];
 		) else (
 			dest.generateCode[];
 		);
 		output.add[");"];
 		output.newline[];
    };
    
    var computeIndex:=method[x]
	{
		if (x==null) return null;
		var i:=new stack[];
		var t:=x.getsize[];
		var one:=x.top[];	
		if ((one.getValue[]) :: unknown) return new unknown;
		//if (one==null) return null;
		if (!(one :: Range)) one:=one.getValue[];
		if (one.a !=one.b) return new unknown;
		one:=one.a;
		if (t==2)
		(
			var two:=x.lget[1];
			if (!(two :: Range)) two:=two.getValue[];
			if (two.a !=two.b) return new unknown;
			two:=two.a;
			two:=new Range[two,two];
			i.push[two];
		);
		one:=new Range[one,one];
		i.push[one];
		return i;
	};
);