#include "mpi.h"
#include "buildmesham.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#define DEFAULTINSIZE 10
/*
 String fns - quite a few of them produce memory which might get dereferenced, therefore register with garbage collector
*/
DLLIMPORT int MESHconverttoint(char * c)
{
	return atoi(c);
}

DLLIMPORT char MESHcharat(char * str,int index)
{
	if (index < 0) {printf("Negative Index not allowed\n");exit(EXIT_FAILURE);}
	if (strlen(str) <= index) { printf("Index past end of String\n");exit(EXIT_FAILURE);}
	return str[index];
}

DLLIMPORT char * MESHconverttostring(float converty, int  cid)
{
	char * thestring=(char *) malloc(sizeof(char) + 10);	
	switch(cid)
	{
		case 1: sprintf(thestring,"%d",(int) converty); break;
		case 2:  sprintf(thestring,"%f",(float) converty); break;
		case 3:  sprintf(thestring,"%d",(double) converty); break;
		case 5:  sprintf(thestring,"%c",(char) converty); break;	
		case 6: sprintf(thestring,"FILE"); break;
		case 7: sprintf(thestring,"void"); break;
		case 8: if((int) converty==0) {sprintf(thestring,"false"); } else { sprintf(thestring,"true");} break; 
		default: thestring[0]='\n'; break;
	}
	registergarbage(thestring);
	return thestring;
}

DLLIMPORT int MESHstrLen(char * c)
{
	return strlen(c);
}

DLLIMPORT char * MESHstruppercase(char * c)
{
	char * toret=(char *) malloc(sizeof(char) * strlen(c) + 1);
	int i;
	for (i=0;i<strlen(c);i++)
	{
		toret[i]=toupper(c[i]);
	}
	toret[i]='\0';
	registergarbage(toret);
	return toret;
}

DLLIMPORT char * MESHstrlowercase(char * c)
{
	char * toret=(char *) malloc(sizeof(char) * strlen(c) + 1);
	int i;
	for (i=0;i<strlen(c);i++)
	{
		toret[i]=tolower(c[i]);
	}
	toret[i]='\0';
	registergarbage(toret);
	return toret;
}

DLLIMPORT void MESHstrinput(char ** a)
{
	char * inputstr=(char *) malloc (sizeof(char) * DEFAULTINSIZE);
	int i=0;
	int s=DEFAULTINSIZE;
	char inp;
	while (inp !='\n')
	{
		inp=fgetc(stdin);
		inputstr[i]=inp;
		i++;
		if (i >= s)
		{
			inputstr=realloc(inputstr,s + DEFAULTINSIZE);
			s=s + DEFAULTINSIZE;
		}
	}
	inputstr[i - 1]='\0';
	*a=realloc(*a,sizeof(char) * strlen(inputstr));
	strcpy(*a,inputstr);
	free(inputstr);
}

DLLIMPORT char * MESHstrcat(char * a,char * b)
{
	char * m=(char *) malloc(sizeof(char) + strlen(a) + strlen(b) + 1);
	strcpy(m,a);
	strcat(m,b);	
	registergarbage(m);
	return m;
}

DLLIMPORT char * MESHdeclareString()
{
	char * tr= (char *) malloc(sizeof(char));
	tr[0]='\0';
	return tr;
}

DLLIMPORT int MESHstrequals(char * a,char * b)
{
	return strcmp(a,b);
}

DLLIMPORT void MESHstrcpy(char ** a,char *b)
{		
	*a=realloc(*a,sizeof(char) * strlen(b) + 1);
	strcpy(*a,b);
}

DLLIMPORT char * MESHsubstring(char * c, int a,int b)
{
	if (a < 0 || b < 0) {printf("Negative Index not allowed\n");exit(EXIT_FAILURE);}
	if ((strlen(c) <b) || (strlen(c) < a)) { printf("Index past end of String\n");exit(EXIT_FAILURE);}
	int i;
	char * retchar=(char *) malloc((b - a) * sizeof(char) + 1);
	for (i=0;i<=b - a;i++)
	{
		retchar[i]=c[i + a];
	}
	retchar[i]='\0';
	registergarbage(retchar);
	return retchar;
}
