#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include "include/main.h"
#include "include/config.h"
#include "platform.h"
char * outputfile=NULL;
char * inputfile=NULL;
char * forwardargs=NULL;
int conly=0;
int pponly=0;
int reportcce=0;
int nowarns=0;
int staticlib =USESTATICLIBRARY;
int main(int argc,char * argv[])
{
	parsearguments(argc,argv);
	if (inputfile==NULL) {compileerror("No Source File Specified\0");}
	if (outputfile==NULL) {inferoutput();}
	int initcompsize=strlen(inputfile) + 40 + strlen(serveraddress) + strlen(PORTNUM) + strlen(tempdir);
	char initcomp[initcompsize];
	srand((unsigned int)time((time_t *)NULL));
	int tempcname=rand();	// name of c file
	char prep[4];
	if (pponly==1)
	{
		sprintf(prep,"-pp\0");
	} else {
		prep[0]='\0';
	}
	sprintf(initcomp,"%s -cp %s %s %s %s %s %s > %s%d.c\0",javart,classpathtopreprocessorclient,ppclientname,inputfile,prep,PORTNUM,serveraddress,tempdir,tempcname,prep);
	system(initcomp);
	if (conly==1 || pponly==1)
	{
		int movefilecmdlen=strlen(tempdir) + strlen(outputfile) + 10 + strlen(copycmd); 
		char movefilecmd[movefilecmdlen];
		char ending[6];
		if (pponly==1)
		{
			sprintf(ending,".flex\0");
		} else {
			sprintf(ending,".c\0");
		}
		sprintf(movefilecmd,"%s %s%d.c %s%s\0",copycmd,tempdir,tempcname,outputfile,ending);
		system(movefilecmd);
		removetempfile(tempcname);
		cleanup();
		return 0;
	}
	// C file now created - now compile it
	
	char * compileargs=getcompileargs(tempcname);	
	int fwargs=0;
	if (forwardargs!=NULL) {fwargs=strlen(forwardargs);}
	int execcallsize=strlen(tempdir) + strlen(outputfile) + strlen(compileargs) + strlen(anyothercompile) + strlen(librarylocation) + strlen(headerlocation)+ 65 + strlen(mpicccmd) + fwargs;
	char * execcall=malloc(sizeof(char) * execcallsize);
	char ke[strlen(killerrors)];
	strcpy(ke,killerrors);
	char st[7]="\0";
	if (staticlib==1) {strcpy(st,"-static\0");}
	if (reportcce==1) {ke[0]='\0';}
	if (forwardargs==NULL)
	{
		sprintf(execcall,"%s -o %s %s%d.c %s %s %s %s %s %s\0",mpicccmd,outputfile,tempdir,tempcname,anyothercompile,st,librarylocation,headerlocation,compileargs, ke);
	} else {
		sprintf(execcall,"%s %s -o %s %s%d.c %s %s %s %s %s %s\0",mpicccmd,forwardargs,outputfile,tempdir,tempcname,anyothercompile,st,librarylocation,headerlocation,compileargs,ke);
	}	
	system(execcall);	
	removetempfile(tempcname);
	cleanup();
	return 0;
}

void cleanup()
{
	if (inputfile!=NULL) {free(inputfile);}
	if (outputfile!=NULL) {free(outputfile);}
	if (forwardargs!=NULL) {free(forwardargs);}
}

char * getcompileargs(int fname)
{	
	int openfsize=strlen(tempdir) + 10;
	char fopenname[openfsize];
	sprintf(fopenname,"%s%d.c\0",tempdir,fname);
	FILE * cfhandler=fopen(fopenname,"r");
	typedef struct llist {struct llist * prev;char data[100]; struct llist * next;} List;
	List * head=NULL;
	List * tail=NULL;
	char line[100];	
	while (fgets(line,100,cfhandler) !=NULL)
	{		
		List * newitem=malloc(sizeof(List));
		strcpy(newitem->data,line);
		if (head==NULL) 
		{
			head=newitem;
			tail=newitem;
		} else {
			tail->next=newitem;
			newitem->prev=tail;
			tail=newitem;
		}		
	}
	fclose(cfhandler);
	char slastline[100];	
	strcpy(slastline,(tail->prev)->data);	
	/*
		Assuming success, the compile string is now in slastline - now need to display any warnings produced.
	*/
	if (nowarns==0)
	{
	int stopcheck=0;
	char thewarnline[100];
	List * currentlinetocheck=(tail->prev)->prev;
	while (stopcheck==0)
	{
		strcpy(thewarnline,currentlinetocheck->data);
		if (thewarnline[0]=='/' && thewarnline[1]=='/' && thewarnline[2]=='W' && thewarnline[3]=='A' && thewarnline[4]=='R' && thewarnline[5]=='N')
		{
			// it is a warning
			char displaywarn[98];
			int i;
			for (i=0;i<98;i++)
			{
				displaywarn[i]=thewarnline[i+2];				
				if (thewarnline[i+2]=='\0') {break;}
			}
			printf("%s",displaywarn);
			currentlinetocheck=currentlinetocheck->prev;
		} else {
			// no more warnings
			stopcheck=1;
		}
	}
	}
	if (slastline[0]=='/' && slastline[1]=='/' && slastline[2]=='m' && slastline[3]=='p' && slastline[4]=='i' && slastline[5]=='c' && slastline[6]=='c')
	{
		// succesful compile into c
		int arglen=strlen(slastline) - 26;
		if (arglen > 0)
		{
			char * args=malloc(sizeof(char) * arglen);
			strcpy(args,&slastline[27]);
			args[arglen-2]='\0';	// remove the new line from end of arguments			
			return args;
		}			
	} else {
		// error occured - display it and exit
		cfhandler=fopen(fopenname,"r");
		int displayerr=0;
		while (fgets(line,100,cfhandler) !=NULL)
		{
			if (line[0]=='=' && line[1]=='=' && line[2]=='=' && line[3]=='=' && line[4]=='=' && line[5]=='=' && line[6]=='=') {displayerr=1;}
			if (displayerr==1) {fprintf(stderr,"%s",line);}			
		}
		fclose(cfhandler);
		removetempfile(fname);
		cleanup();
		exit(EXIT_FAILURE);
	}  	
}

void removetempfile(int tempn)
{
	int delfilecmdlen=strlen(tempdir) + 10;
	char delfilecmd[delfilecmdlen];
	sprintf(delfilecmd,"%s %s%d.c\0",rmcmd,tempdir,tempn);
	system(delfilecmd);
}

void inferoutput()
{
	// infer the name of the output file from that of input file	
	int startpoint=0;
	int endpoint=0;
	int i;
	for (i=strlen(inputfile);i>0;i--)
	{
		if (inputfile[i]=='.') {endpoint=i;}
		if (inputfile[i]=='/' || inputfile[i]=='\\') {startpoint=i + 1;i=-1;}
	}
	char fname[(endpoint-startpoint) + 1];
	for (i=startpoint;i<endpoint;i++)
	{
		fname[i-startpoint]=inputfile[i];
	}
	fname[endpoint-startpoint]='\0';
	outputfile=malloc(sizeof(char) * ((endpoint-startpoint) + 1));
	strcpy(outputfile,fname);
}

void parsearguments(int argc,char * argv[])
{
	int i;
	int defaultaction=1;
	for (i=1;i<argc;i++)
	{
		defaultaction=1;
		if (strcmp(argv[i],"-o\0")==0)
		{
			defaultaction=0;
			// output file specified
			i++;
			outputfile=malloc(sizeof(char) * (strlen(argv[i]) + 2));
			sprintf(outputfile,"%s\0",argv[i]);
		}
		if (strcmp(argv[i],"-c\0")==0) { defaultaction=0;conly=1;}
		if (strcmp(argv[i],"-static\0")==0) {defaultaction=0;staticlib=1;}
		if (strcmp(argv[i],"-shared\0")==0) {defaultaction=0;staticlib=0;}
		if (strcmp(argv[i],"-s\0")==0) { defaultaction=0;nowarns=1;}
		if (strcmp(argv[i],"-pp\0")==0) { defaultaction=0;pponly=1;}
		if (strcmp(argv[i],"-e\0")==0) { defaultaction=0;reportcce=1;}
		if (strcmp(argv[i],"-h\0")==0) {defaultaction=0;displayhelp();cleanup();exit(EXIT_SUCCESS);}
		if (strcmp(argv[i],"-f\0")==0)
		{
			// forward args to gcc
			defaultaction=0;
			i++;
			forwardargs=malloc(sizeof(char) * (strlen(argv[i]) + 2));
			sprintf(forwardargs,"%s\0",argv[i]);
		}
		if (defaultaction==1)
		{
			if (argv[i][0]=='-') { compileerror("Invalid Command Line Option\0");}
			// No options specified therefore must be the source file
			inputfile=malloc(sizeof(char) * (strlen(argv[i]) + 2));
			sprintf(inputfile,"%s\0",argv[i]);
		}
	}
}

void displayhelp()
{
	printf("Compiler Chain\nsc [args] [source file]\n\nArguments:\n");
	printf("-o [file]                 Select output file name\n");
	printf("-c	                  Output C Code only\n");
	printf("-static	         	  Statically link with runtime library\n");
	printf("-shared	      	          Link with shared runtime library\n");
	printf("-e	                  Display C Compiler errors/warnings\n");
	printf("-s			  Silent Operation (No warnings)\n");
	printf("-pp                       Preprocess code only\n");
	printf("-f [args]                 Forward args to the C compiler\n");
	printf("-h	                  Display this help\n");			
}

void compileerror(char * errormessage)
{
	fprintf(stderr,"%s\n",errormessage);
	cleanup();
	exit(EXIT_FAILURE);
}
