import java.util.*;
public class processor implements instructions
{
    private ArrayList registers;
    private ArrayList registerindex;
    
    private register r0;
    private register at;
    private register v0;
    private register v1;
    private register a0;
    private register a1;
    private register a2;
    private register a3;
    private register t0;
    private register t1;
    private register t2;
    private register t3;
    private register t4;
    private register t5;
    private register t6;
    private register t7;
    private register s0;
    private register s1;
    private register s2;
    private register s3;
    private register s4;
    private register s5;
    private register s6;
    private register s7;
    private register t8;
    private register t9;
    private register k0;
    private register k1;
    private register gp;
    private register sp;
    private register s8;
    private register ra;
    private register pc;
    private memorymanager mem;
    private processorlist plist;
    private int one;
    private int two;
    private int three;
    private int four;
    private boolean halt;
    private int nocycle;
    private int procid;
    private int opcode;
    private output o;
    private input input;
    private highlevel h;
    private int memwrite;
    private int memread;
    private int registeraccess;
    private int arithmetic;
    private int conditionals;
    private int jumps;
    private boolean suspended;
    private boolean waitforinput;
    private clock caller;
            
    public processor(memorymanager amem,output outp,input ainput,int pid, processorlist aplist)
    {
        memwrite=0;
        input=ainput;
        memread=0;
        registeraccess=0;
        arithmetic=0;
        conditionals=0;
        jumps=0;
        suspended=false;
        waitforinput=false;
        procid=pid;
        plist=aplist;
        o=outp;
        mem=amem;
        registerindex=new ArrayList();
        registers= new ArrayList();
        r0=new register();
        registers.add(r0);
        at=new register();
        registers.add(at);
        v0=new register();
        registers.add(v0);        
        v1=new register();
        registers.add(v1);        
        a0=new register();
        registers.add(a0);        
        a1=new register();
        registers.add(a1);        
        a2=new register();
        registers.add(a2);        
        a3=new register();
        registers.add(a3);        
        t0=new register();
        registers.add(t0);        
        t1=new register();
        registers.add(t1);        
        t2=new register();
        registers.add(t2);        
        t3=new register();
        registers.add(t3);        
        t4=new register();
        registers.add(t4);        
        t5=new register();
        registers.add(t5);        
        t6=new register();
        registers.add(t6);        
        t7=new register();
        registers.add(t7);        
        s0=new register();
        registers.add(s0);        
        s1=new register();
        registers.add(s1);        
        s2=new register();
        registers.add(s2);
        s3=new register();
        registers.add(s3);        
        s4=new register();
        registers.add(s4);        
        s5=new register();
        registers.add(s5);        
        s6=new register();
        registers.add(s6);        
        s7=new register();
        registers.add(s7);        
        t8=new register();
        registers.add(t8);        
        t9=new register();
        registers.add(t9);        
        k0=new register();
        registers.add(k0);        
        k1=new register();
        registers.add(k1);        
        gp=new register();
        registers.add(gp);        
        sp=new register();
        registers.add(sp);        
        s8=new register();
        registers.add(s8);        
        ra=new register();
        registers.add(ra);
        pc=new register();
        pc.put(0);
        at.put(pid);
        for (int i=0;i<32;i++)
        {
            registerindex.add(new Integer(i));   
        }        
        halt=false;
        nocycle=0;
     }
     
     public void resetall()
     {
        memwrite=0;        
        memread=0;
        registeraccess=0;
        arithmetic=0;
        conditionals=0;
        jumps=0;
        suspended=false;
        waitforinput=false;
        nocycle=0;
        halt=false;
        pc.reset();
        Iterator i=registers.iterator();
        while (i.hasNext())
        {
            register r=(register) i.next();
            r.reset();
        }
        at.put(procid);
     }
     
     public void sethlevel(highlevel ah)
     {
        h=ah;   
     }
     
     public void updatecycle()
     {
        ++nocycle;   
     }
     
     public boolean signal(int cycle,int phase,clock acaller)
     {        
         caller=acaller;
         //System.out.println(cycle+" "+phase+" "+pc.get());
         if (halt)
         {
             return false;
         }       
         if (suspended)
         {
            return true;   
         }
         
         if (waitforinput)
         {           
            return true;              
         }         
         
         if (phase==1)
         {
             ++nocycle;
             int count=pc.get(); 
             if (!mem.checkinstruction(count)) {return false;}             
             one=mem.get(count);
             count++;
             two=mem.get(count);
             count++;
             three=mem.get(count);             
             count++;
             four=mem.get(count);            
             count++;
             pc.put(count);
             Integer ione=new Integer(one);
             String thebinstring=misc.toBinary(ione);
             opcode=misc.fromBinary(thebinstring.substring(0,6));      
             h.addtrace(this,(count-4),nocycle);
             return true;              
         }
         if (phase==2)
         {    
            //System.out.println("CODE: "+opcode);
            switch (opcode)
            {
                case INS_ADDIU:     addiu(); break;
                case INS_SPECIAL:   special(); break;
                case INS_BEQ:       beq(); break;
                case INS_BNE:       bne(); break;
                case INS_BGTZ:      bgtz(); break;
                case INS_J:         j(); break;
                case INS_LUI:       lui();break;                                
                case INS_JAL:       jal();break;
                case INS_BLEZ:      blez();break;
                case INS_SPECIAL2:  special2();break;
                default:         break;
            }            
            //System.out.println("PC: "+pc.get());
            if (halt)
            {
                return false;
            } else {
                return true;   
            }
         }
         if (phase==3)         
         {     
            switch (opcode)
            {
                case INS_LW:       lw(cycle); break;
                case INS_LBU:      lbu(cycle);break;
                default:        break;
            }
            return true;
         }
         if (phase==4)
         {
            switch (opcode)
            {
                case INS_SW:       sw(cycle); break;
                case INS_SB:       sb(cycle);break;
                default:        break;
            }
            return true;
         }
         return false;
     }
     
     private void special()
     {         
         Integer ifour=new Integer(four);
         String thebinstring=misc.toBinary(ifour);
         int funct=misc.fromBinary(thebinstring.substring(2,8));
         switch (funct)
         {
            case FUNCT_OR:      or();   break;
            case FUNCT_ADDU:    addu();   break;
            case FUNCT_SUBU:    subu();   break;
            case FUNCT_SYSCALL: syscall(); break;
            case FUNCT_JR:      jr();   break;
            case FUNCT_DIVU:     divu();   break;
            case FUNCT_BREAK:    breakinst();   break;
            default:    break;
         }
     }
     
     private void special2()
     {         
         Integer ifour=new Integer(four);
         String thebinstring=misc.toBinary(ifour);
         int funct=misc.fromBinary(thebinstring.substring(2,8));
         switch (funct)
         {
            case SPECIAL2_MUL:      mul();   break;
            default:    break;
         }
     }
     
     public void syscall()
     {
           register touse=(register) registers.get(2);
           if (touse.get()==01)
           {
                //System.out.println("Processor Halt "+nocycle);
                halt=true;                
           }
           
           if (touse.get()==02)
           {
                Integer thein=new Integer(a0.get());
                o.display(thein.toString());
           }
           
           if (touse.get()==03)
           {                
                o.displayline();
           }
           
           if (touse.get()==04)
           {
                int theint=a0.get();
                char c=(char) theint;
                Character thechar=new Character(c);
                o.display(thechar.toString());
           }
           if (touse.get()==05)
           {
               Integer thein=new Integer(a0.get());
               o.display(thein.toString());
               o.displayline();
           }
           
           if (touse.get()==06)
           {
               touse.put(plist.size());
           }
           
           if (touse.get()==07)
           {
                input.getinput(false);
                waitforinput=true;
           }
           
           if (touse.get()==8)
           {
                System.out.println("INPUT "+procid);
                input.setproc(this);
                new Thread(input).start(); 
                //input.getinput(true);
                waitforinput=true;
           }
           
           if (touse.get()==9)
           {
                int theinput=input.getnext();
                touse.put(theinput);
                //waitforinput=true;
           }
           
           if (touse.get()==10)
           {
                touse.put(input.getsize());   
           }
           
           if (touse.get()==11)
           {
                caller.setsyncmode(false);
                caller.sync(procid);                   
           }
           
           if (touse.get()==12)
           {
                caller.setsyncmode(true);
                caller.sync(procid);                   
           }
     }
     
     private void or()
     {
         misc themisc=new misc();
         int thevalues[]=themisc.checkrtype(one,two,three,four);
         int rs=thevalues[1];
         int rt=thevalues[2];
         int rd=thevalues[3];
         register toput=(register) registers.get(rd);
         register oneor=(register) registers.get(rs);
         register twoor=(register) registers.get(rt);
         String orresult=misc.ortwostring(misc.toBinary(oneor.get()),misc.toBinary(twoor.get()));
         //System.out.println(orresult+" "+rs+" "+rt+" "+rd);
         toput.put(misc.fromBinary(orresult));
         //System.out.println(toput.get()+" "+misc.fromBinary(orresult));
     }
     
     private void divu()
     {
        arithmetic++;
        misc themisc=new misc();
        int thevalues[]=themisc.checkitype(one,two,three,four); 
        register regone=(register) registers.get(thevalues[1]);
        register regtwo=(register) registers.get(thevalues[2]);
        int regoneval=regone.get();
        int regtwoval=regtwo.get();
        int result=regoneval/regtwoval;
        
        double r=(double) regoneval/(double) regtwoval;
        double thepoint=r-(double) result;
        double quotent=thepoint*10;
        int qtoput=(int) quotent;       
        regtwo.put(qtoput);        
        regone.put(result);
     }
     
     
     private void mul()
     {
         arithmetic++;
         misc themisc=new misc();
         int thevalues[]=themisc.checkrtype(one,two,three,four);
         int rs=thevalues[1];
         int rt=thevalues[2];
         int rd=thevalues[3];
         register toput=(register) registers.get(rd);
         register onemul=(register) registers.get(rs);
         register twomul=(register) registers.get(rt);
         int onemulval=onemul.get();
         int twomulval=twomul.get();
         int mulresult=onemulval*twomulval;
         toput.put(mulresult);         
     }
     
     private void jal()
     {
         jumps++;
         ra.put(pc.get()+4);
         //System.out.println(ra.get());
         j();
     }
     
     private void breakinst()
     {
         ra.put(pc.get()+4);         
         pc.put(1047552);
     }
     
     private void jr()
     {
         jumps++;
         misc themisc=new misc();
         int thevalues[]=themisc.checkitype(one,two,three,four);
         register toget=(register) registers.get(thevalues[1]);
         pc.put(toget.get());
     }
     
     private void lbu(int acycle)
     {
         memread++;
         misc themisc=new misc();
         int thevalues[]=themisc.checkitype(one,two,three,four); 
         register touse=(register) registers.get(thevalues[2]);
         int addrtouse=thevalues[3];     
         addrtouse=addrtouse+((register) registers.get(thevalues[1])).get();
         touse.put(mem.get(addrtouse,procid,acycle));
     }
     
     private void lw(int acycle)
     {
         memread++;
         misc themisc=new misc();
         int thevalues[]=themisc.checkitype(one,two,three,four); 
         register touse=(register) registers.get(thevalues[2]);
         int addrtouse=thevalues[3];     
         addrtouse=addrtouse+((register) registers.get(thevalues[1])).get();
         int bone=mem.get(addrtouse,procid,acycle);
         int btwo=mem.get(addrtouse+1,procid,acycle);
         int bthree=mem.get(addrtouse+2,procid,acycle);
         int bfour=mem.get(addrtouse+3,procid,acycle);
         String thebinst=misc.toBinary(bone)+misc.toBinary(btwo)+misc.toBinary(bthree)+misc.toBinary(bfour);         
         touse.put(misc.fromBinary(thebinst));   
     }
     
     private void sb(int acycle)
     {
         memwrite++;
         misc themisc=new misc();
         int thevalues[]=themisc.checkitype(one,two,three,four); 
         register touse=(register) registers.get(thevalues[2]);
         int addrtouse=thevalues[3];
         addrtouse=addrtouse+((register) registers.get(thevalues[1])).get();
         mem.put(touse.get(),addrtouse,procid,acycle);
     }
     
     private void sw(int acycle)
     {
         memwrite++;
         misc themisc=new misc();
         int thevalues[]=themisc.checkitype(one,two,three,four); 
         register touse=(register) registers.get(thevalues[2]);
         int addrtouse=thevalues[3];
         addrtouse=addrtouse+((register) registers.get(thevalues[1])).get();
         int regint=touse.get();
         String thebinst=misc.toBinary(regint);
         int lenofst=thebinst.length();
         if ((32-lenofst) >0)
         {
            thebinst=misc.addzero(thebinst,(32-lenofst));
         }
         //System.out.println(thebinst);         
         String tpone=thebinst.substring(0,8);
         String tptwo=thebinst.substring(8,16);
         String tpthree=thebinst.substring(16,24);
         String tpfour=thebinst.substring(24,32);
//                  System.out.println(tpone+" "+tptwo+" "+tpthree+" "+tpfour);
         mem.put(misc.fromBinary(tpone),addrtouse,procid,acycle);
         mem.put(misc.fromBinary(tptwo),addrtouse+1,procid,acycle);
         mem.put(misc.fromBinary(tpthree),addrtouse+2,procid,acycle);
         mem.put(misc.fromBinary(tpfour),addrtouse+3,procid,acycle);
     }
     
     private void j()
     {
         jumps++;
         misc themisc=new misc();
         int thevalues[]=themisc.checkjtype(one,two,three,four);
         int valofjump=thevalues[1];         
         valofjump=valofjump*4;            
         pc.put(valofjump);               
     }
     
     private void lui()
     {
         registeraccess++;
         misc themisc=new misc();
         int thevalues[]=themisc.checkitype(one,two,three,four);
         register thereg=(register) registers.get(thevalues[2]);         
         String thetopbit=misc.toBinary(thevalues[3]);
         thetopbit=thetopbit+"0000000000000000";
         thereg.put(misc.fromBinary(thetopbit));
     }
     
     private void beq()
     {
         conditionals++;
         misc themisc=new misc();
         int thevalues[]=themisc.checkitype(one,two,three,four); 
         int regone=thevalues[1];
         int regtwo=thevalues[2];
         int addr=thevalues[3];
         register theregone=(register) registers.get(regone);
         register theregtwo=(register) registers.get(regtwo);
         int valofone=theregone.get();
         int valoftwo=theregtwo.get();
         if (regtwo==0)
         {
              valoftwo=0;
         }
           
         if (valofone==valoftwo)
         {
              int addrt[]=themisc.twoscomp(three,four);    
              if (addrt[0]==0)
              {
                  branch(addrt[1],false);
              } else {
                  branch(addrt[1],true);
              }
         }
     }
     
     private void bgtz()
     {
         conditionals++;
         misc themisc=new misc();
         int thevalues[]=themisc.checkitype(one,two,three,four); 
         int regone=thevalues[1];
         int addr=thevalues[3];
         register theregone=(register) registers.get(regone);         
         int valofone=theregone.get();         
           
         if (valofone>0)
         {
              int addrt[]=themisc.twoscomp(three,four);    
              //System.out.println("DONE"+valofone);
              if (addrt[0]==0)
              {
                  branch(addrt[1],false);
              } else {
                  branch(addrt[1],true);
              }
         }
     }
     
     private void blez()
     {
         conditionals++;
         misc themisc=new misc();
         int thevalues[]=themisc.checkitype(one,two,three,four); 
         int regone=thevalues[1];
         int addr=thevalues[3];
         register theregone=(register) registers.get(regone);         
         int valofone=theregone.get();         
           
         if (valofone<=0)
         {
              int addrt[]=themisc.twoscomp(three,four);    
              //System.out.println("DONE"+valofone);
              if (addrt[0]==0)
              {
                  branch(addrt[1],false);
              } else {
                  branch(addrt[1],true);
              }
         }
     }
     
      
     private void bne()
     {
         conditionals++;
         misc themisc=new misc();
         int thevalues[]=themisc.checkitype(one,two,three,four); 
         int regone=thevalues[1];
         int regtwo=thevalues[2];
         int addr=thevalues[3];
           register theregone=(register) registers.get(regone);
           register theregtwo=(register) registers.get(regtwo);
           int valofone=theregone.get();
           int valoftwo=theregtwo.get();
           if (regtwo==0)
           {
                valoftwo=0;
           }
           
           if (valofone!=valoftwo)
           {
                int addrt[]=themisc.twoscomp(three,four);    
                if (addrt[0]==0)
                {
                    branch(addrt[1],false);
                } else {
                    branch(addrt[1],true);
                }
           }
     }
     
     private void addu()
     {       
            arithmetic++;
             misc themisc=new misc();
             int thevalues[]=themisc.checkrtype(one,two,three,four);
             int rs=thevalues[1];
             int rt=thevalues[2];
             int rd=thevalues[3];
             register toput=(register) registers.get(rd);
             register oneadd=(register) registers.get(rs);
             register twoadd=(register) registers.get(rt);
             toput.put((oneadd.get())+(twoadd.get()));
     }
     
     private void subu()
     {                
         arithmetic++;
             misc themisc=new misc();
             int thevalues[]=themisc.checkrtype(one,two,three,four);
             int rs=thevalues[1];
             int rt=thevalues[2];
             int rd=thevalues[3];
             register toput=(register) registers.get(rd);
             register oneadd=(register) registers.get(rs);
             register twoadd=(register) registers.get(rt);
             toput.put((oneadd.get())-(twoadd.get()));
     }
     
     
     private void addiu()
     {         
         registeraccess++;
         misc themisc=new misc();
         int thevalues[]=themisc.checkitype(one,two,three,four);
         register rs=(register) registers.get(thevalues[1]);
         register rt=(register) registers.get(thevalues[2]);            
         int val=three*256;         
         val=val+four;         
         if (thevalues[1]!=0)
         {
               val=val+rs.get();              
         }
         rt.put(val);             
     }     
     
     
     private void branch(int addr,boolean negative)
     {
         addr=addr*4;
         if (!negative)
         {
            addr=addr+pc.get();
         } else {
            addr=pc.get()-addr; 
            //addr=addr-4;
         }
         //System.out.println(addr);
         //System.exit(0);
         pc.put(addr);
     }
     
     public void setsuspended(boolean issuspended)
     {
        suspended=issuspended;   
     }
     
     public boolean getsuspended()
     {
        return suspended;   
     }
     
     // for interfacing the processor with the GUI and reports etc...
          
     public ArrayList getregisters()
     {
        return registers;   
     }
     
     public ArrayList getregindex()
     {
         return registerindex;
     }
     
     public int getpc()
     {
        return pc.get();   
     }
     
     public void setpc(int theval)
     {
        pc.put(theval);   
     }
     
     public void reset()
     {
         nocycle=0;
         halt=false;
     }
     
     public int getcycle()
     {
        return nocycle;   
     }
     
     public int getid()
     {
        return procid;   
     }
     
     public void setwait(boolean toset)
     {
        waitforinput=toset;   
     }
     
     public int[] getinstuse()
     {
        int[] toreturn=new int[6];
        toreturn[0]=memwrite;
        toreturn[1]=memread;
        toreturn[2]=registeraccess;
        toreturn[3]=arithmetic;
        toreturn[4]=conditionals;
        toreturn[5]=jumps;
        return toreturn;
     }    
}