import java.util.*;
public class memorymanager
{
    memory thememory;
    private int rmode; // 0 = ER, 1 = CR
    private int wmode; // 0 = EW, 1 = CW
    private int cwmode;
    private int errors;
    private ArrayList errorlist;
    // cwmode is the concurrent write mode: 
    // 0 = weak (zero by 2 or more = ok, else conflict)
    // 1 = common (writting same value is ok, else conflict)
    // 2 = tollerant (ignore this new write, old value is unchanged)
    // 3 = collision (special collision symbol)
    // 4 = collision+ (special collision symbol or write value if the same)
    // 5 = arbitrary (one value will be written to it, cant tell which)
    // 6 = priority (processor with lower ID will succeed)
    
    private ArrayList readhistory[];
    private ArrayList writehistory[];
    
    public memorymanager()
    {
        rmode=1;
        errorlist=new ArrayList();
        errors=0;
        wmode=1;
        cwmode=1;
        thememory=new memory((1024*1024));
        readhistory=new ArrayList[getsize()];       
        writehistory=new ArrayList[getsize()];       
    }
    
    public void setmodel(int mode)
    {
        if (mode==1)
        {
            rmode=0;
            wmode=0;
        }
        if (mode==2)
        {
            rmode=1;
            wmode=0;
        }
        if (mode==3)
        {
            rmode=0;
            wmode=1;
        }
        if (mode==4)
        {
            rmode=1;
            wmode=1;
        }
    }
    
    public void setcrcwmodel(int mode)
    {
        cwmode=mode;
    }
    
    public int getcrcwmodel()
    {
        return cwmode;   
    }
    
    public int getmodel()
    {
        if (rmode==0 && wmode==0) {return 1;}
        if (rmode==1 && wmode==0) {return 2;}
        if (rmode==0 && wmode==1) {return 3;}
        if (rmode==1 && wmode==1) {return 4;}
        return 0;
    }
    
    public void put(byte toput,int address)
    {
        thememory.put(toput,address);   
    }
    
    public void clear()
    {
        thememory.clear();   
    }
    
    public void put(int toput,int address, int pid, int cycleid)
    {
        
            boolean isconflict=conflicttest(address,cycleid,1);        
            if (isconflict)
            {
                if (wmode==0)
                {
                    errorlist.add("Processor " +pid+" write conflict. Cycle "+cycleid+" write to address "+address);
                    errors++;
                } else {
                    boolean concconflict=writeconflict(toput, address, pid, cycleid);
                    if (concconflict)
                    {
                        errorlist.add("Processor " +pid+" write conflict. Cycle "+cycleid+" write to address "+address);
                        errors++;
                    }
                }
            } else {
                writehistory[address].add(new Integer(cycleid));   
                put (toput, address);
            }                                
    }
    
    
    public int get(int address, int pid, int cycleid)
    {                
        if (rmode==0)
        {
            boolean isconflict=conflicttest(address,cycleid,0);        
            if (isconflict)
            {
                errorlist.add("Processor "+pid+"read conflict. Cycle "+cycleid+" read from address "+address);
                errors++;
            } else {
                readhistory[address].add(new Integer(cycleid));   
            }
        }
        //System.out.println("Processor read "+pid+" cycle "+cycleid+" read "+address);
        return get (address);
    }
    
    public void put(int toput,int address)
    {     
        //System.out.println("want to add "+toput);
        toput=toput-128;
        //System.out.println("added "+toput);
        Integer pbyte=new Integer(toput);        
        byte tput=pbyte.byteValue();
        thememory.put(tput,address);   
    }
    
    public void change(int toput,int address)
    {     
        toput=toput-128;
        
        Integer pbyte=new Integer(toput);        
        byte tput=pbyte.byteValue();
        thememory.change(tput,address);   
    }
    
    public int get(int address)
    {
        
        byte ag= thememory.get(address);           
        int g=ag+128;
        //System.out.println("memory retrieval: "+ag+" "+g);
        return g;
    }  
    
    //public ArrayList getall()
    //{
    //    return thememory.getList();
    //}
    
    public boolean checkinstruction(int check)
    {
        if ((thememory.listsize()+3)>=check)
        {
            return true;   
        } else {
            return false;   
        }
    }
    
    public ArrayList getpage(int page)
    {
        return thememory.getpage(page);   
    }
    
    public int getsize()
    {
        return thememory.listsize();   
    }
    
    public void testifexist(int indextotest,int whichone)
    {
        if (whichone==0)
        {
            if (readhistory[indextotest]==null)
            {
                readhistory[indextotest]=new ArrayList();   
            }
        } else {
            if (writehistory[indextotest]==null)
            {
                writehistory[indextotest]=new ArrayList();   
            }
        }
    }
    
    public boolean conflicttest(int addrtotest, int cycle,int whichone)
    {
        testifexist(addrtotest,whichone);
        Iterator i;
        if (whichone==0)
        {
            i=readhistory[addrtotest].iterator();
        } else {
            i=writehistory[addrtotest].iterator();
        }
        while (i.hasNext())
        {
            int individualcycle=((Integer) i.next()).intValue();
            if (individualcycle==cycle)
            {
                return true;   
            }
        }
        return false;
    }
    
    public boolean writeconflict(int toput, int addrtouse, int pid, int acycle)
    {
        if (cwmode==0)
        {
            if ((get(addrtouse))==0 && toput==0)  
            {
                // dont need to add as zero already in
                return false;   
            } else {
                return true;   
            }
        }
        
        if (cwmode==1)
        {
            if (get(addrtouse)==toput)  
            {
                // dont need to add as value already in
                return false;   
            } else {
                return true;   
            }
        }
        
        if (cwmode==2)
        {
            // dont need to add as value already in
            return false; // ignore this value
        }
        
        if (cwmode==3)
        {
            put (0, addrtouse);   // zero is collision symbol
            return false;
        }
        
        if (cwmode==4)
        {
            if (get(addrtouse)==toput)  
            {
                // dont need to add as value already in                
            } else {
                put (0, addrtouse);   // zero is collision symbol
            }
            return false;
        }
        
        if (cwmode==5)
        {
            // lowest pid suceed therefore dont write
            return false;
        }
        
        if (cwmode==6)
        {
            // lowest pid, therefore dont write
            return false;
        }
        
        return true;
    }
    
    public int geterrors()
    {
        return errors;   
    }
    
    public ArrayList geterrorlist()
    {
        return errorlist;   
    }
    
    public void reset()
    {
        errors=0;
        errorlist.clear();
        int g=readhistory.length;
        for (int i=0;i<g;++i)
        {
            if (readhistory[i] !=null) {readhistory[i].clear();}
        }
        
        g=writehistory.length;
        for (int i=0;i<g;++i)
        {
            if (writehistory[i] !=null) {writehistory[i].clear();}   
        }
    }
    
    public void resetall()
    {
        reset();
        rmode=1;                
        wmode=1;
        cwmode=1;
        thememory.reset();
    }
}