import javax.swing.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.event. ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowEvent;
import javax.swing.event.MenuKeyListener;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class memorygui extends JPanel implements ActionListener, WindowListener, MouseListener
{
   
  protected JScrollPane jScrollPane1;
  protected JButton buttonprev;
  protected JButton buttonnext;
  protected JList list;
  protected memorymanager m;
  protected int page;
    
    public static void main(String args[])
    {
//     tablegui me=new tablegui();
    }
    
   public memorygui(memorymanager am, int apage)
    {
        m=am;
        page=apage;
        try 
        {
            UIManager.setLookAndFeel(UIManager.
                                             getSystemLookAndFeelClassName());
        } catch (Exception exception) {
            exception.printStackTrace();
        }
        Container container1=new Container();
        container1.setLayout(new BorderLayout());
        JFrame theframe=new JFrame("Memory");
        final Container cpane=theframe.getContentPane();
        cpane.setLayout(new BorderLayout());
          String data[]={ };
        list=new JList(data);
        list.addMouseListener(this);
        jScrollPane1 = new JScrollPane(list);
        updatemem();
        
        cpane.add(jScrollPane1,BorderLayout.CENTER);  
        
        buttonprev=new JButton("Prev");
        buttonnext=new JButton("Next");
        buttonprev.addMouseListener(this);
        buttonnext.addMouseListener(this);
        if (page==0){buttonprev.setEnabled(false);}
        container1.add(buttonprev,BorderLayout.WEST);
        container1.add(buttonnext,BorderLayout.EAST);
        cpane.add(container1,BorderLayout.SOUTH);
        theframe.addWindowListener(this);
        theframe.pack();
        theframe.setSize(200,300);
 
        theframe.setVisible(true);
    }
    
    public void mouseClicked(MouseEvent e)
    {
        JComponent cl = (JComponent) e.getSource();        
        if (cl==list)
        {
            String thestr=(String) list.getSelectedValue();
            String data = thestr.substring(0,8);
            Integer thed=new Integer(data);
            int theintdata=thed.intValue();
            int dataval=m.get(theintdata);

            guival editor=new guival("Memory Address "+data,dataval,m,theintdata,this);
        }
        
        if (cl==buttonnext)
        {
            page++;
            updatemem();
            buttonprev.setEnabled(true);
        }
        
        if (cl==buttonprev)
        {
            if (page!=0)
            {
                page--;
                updatemem();
            }
            if (page==0){buttonprev.setEnabled(false);}
        }
    }
    
    
    
    public void actionPerformed(ActionEvent e)
    {    
        
   }
   
      public void windowActivated(final WindowEvent pWindowEvent)
   {
   }

   public void windowClosed(final WindowEvent pWindowEvent)
   {
   }

   public void windowClosing(final WindowEvent pWindowEvent)
   {
      final Window tWindow = pWindowEvent.getWindow();
      tWindow.setVisible(false);
      tWindow.dispose();
      
   }

   public void windowDeactivated(final WindowEvent pWindowEvent)
   {
   }

   public void windowDeiconified(final WindowEvent pWindowEvent)
   {
   }

   public void windowIconified(final WindowEvent pWindowEvent)
   {
   }

   public void windowOpened(final WindowEvent pWindowEvent)
   {
   }
   
   public void mousePressed(MouseEvent e)
   {
   }
   
   public void mouseReleased(MouseEvent e)
   {
   }
   
   public void mouseEntered(MouseEvent e)
   {
   }
   
   public void mouseExited(MouseEvent e)
   {
   }
   
   public void updatemem()
   {
        ArrayList memcontents=m.getpage(page);
        Vector thedata=new Vector();
        Iterator i=memcontents.iterator();
        int addr=(1024*page);
        while (i.hasNext())
        {
            Byte theval=(Byte) i.next();

            int thevalue=theval.intValue();
            thevalue=thevalue+128;
            //if (thevalue!=0) {System.out.println("Added "+theval+" "+thevalue);}
            String thehex=misc.toHex(thevalue);
            Integer theaddr=new Integer(addr);
            String theaddress=theaddr.toString();
            theaddress=sortsize(theaddress);
            thedata.add(theaddress+" - "+thehex+"("+thevalue+")");
            ++addr;
        }
        list.setListData(thedata);   
   }
   
    public String sortsize(String thestring)
   {
        int len=thestring.length();
        if (len==7){thestring=("0"+thestring);}
        if (len==6){thestring=("00"+thestring);}
        if (len==5){thestring=("000"+thestring);}
        if (len==4){thestring=("0000"+thestring);}
        if (len==3){thestring=("00000"+thestring);}
        if (len==2){thestring=("000000"+thestring);}
        if (len==1){thestring=("0000000"+thestring);}
        return thestring;
   }
}