import java.util.*;

public class highlevel
{
    protected ArrayList commands;
    protected ArrayList absolute;
    protected ArrayList[] trace;
    protected ArrayList[] tracecycle;
    protected ArrayList thevariables;
    protected ArrayList thearrays;
    protected String[] me;
    protected int startaddr;
    protected int arraycounter;
    protected boolean inuse;
    protected int sizeofarray;
    protected ArrayList slicelist;
    protected memorymanager m;
    
    public highlevel(memorymanager am)
    {
           m=am;
           commands=new ArrayList();
           thevariables=new ArrayList();
           absolute=new ArrayList();    
           thearrays=new ArrayList();
           slicelist=new ArrayList();
           startaddr=0;
           sizeofarray=0;
           arraycounter=0;
           inuse=false;
    }
    
    public void reset()
    {
        for (int j=0;j<startaddr;++j)   // populate the trace arraylist with arraylist objects
        {
            trace[j].clear();   
        }  
        
        Iterator i=slicelist.iterator();
        while (i.hasNext())
        {
            slice me=(slice) i.next();
            me.reset();
        }
    }
    
    public void resetall()
    {
        reset();
        commands.clear();
        thevariables.clear();
        absolute.clear();    
        thearrays.clear();
        slicelist.clear();
        startaddr=0;
        sizeofarray=0;
        arraycounter=0;
        inuse=false;
    }
    
    public void add(ArrayList datatoadd)
    {
        inuse=true;     // highlevel is there
        Iterator i=datatoadd.iterator();
        int maxsize=0;
        while(i.hasNext())
        {
            String thecommand=((String) i.next());
            boolean overwritestart=true;
            //val=val*4;
            int val=0;
            if (thecommand.equals("variable"))  
            {
                String thevar=((String) i.next());              // variable name
                if (isarray(thevar))                            // is this an array?
                {
                    String arrayname=(String) i.next();         // get name of array 
                    addvariable(thevar,startaddr,arrayname);    // add it to the list
                    overwritestart=false;                       // so we dont overwrite the startvalue (as no address for array)
                } else {
                val=(new Integer((String) i.next())).intValue();  // length of variable
                val=val+startaddr;      // end value of variable
                addvariable(thevar,startaddr,"");   // add variable
                }
            } else {                // its a command
                commands.add(thecommand);   
                val=(new Integer((String) i.next())).intValue(); // length of command
                val=val+startaddr;  // end of command
                absolute.add(new Integer(startaddr));   // add start of command
                absolute.add(new Integer(val));         // add end of command
                int thediff=val-startaddr;  // size of command
                if (thediff > maxsize) {maxsize=thediff;}   // is it the largest command?
            }                        
            
            if (overwritestart) {startaddr=val;}    // if val updated, update startaddress
        }
        trace=new ArrayList[startaddr];     // set size of the trace (its as large as the program)
        for (int j=0;j<startaddr;++j)   // populate the trace arraylist with arraylist objects
        {
            trace[j]=new ArrayList();   
        }     
        
        tracecycle=new ArrayList[startaddr];     // set size of the trace (its as large as the program)
        for (int j=0;j<startaddr;++j)   // populate the trace arraylist with arraylist objects
        {
            tracecycle[j]=new ArrayList();   
        }     
    }
    
    public void addvariable(String variable, int address,String arrayname)
    {
        
        if (isarray(variable))  // is this an array?
        {           
            sizeofarray=(new Integer(variable.substring(6,variable.length()))).intValue();  // the number of variables in the array
            thearrays.add("array");
            thearrays.add(arrayname);
            arraycounter=0;
        } else {        
            if (arraycounter >= sizeofarray)    // if the variable is part of an array or not
            {
                thevariables.add(variable);
                thevariables.add(new Integer(address));
            } else {
                thearrays.add(variable);
                thearrays.add(new Integer(address));
                arraycounter++;
            }
        }
    }
    
    public ArrayList[] getvariables()
    {
        ArrayList[] toreturn=new ArrayList[2];
        toreturn[0]=thevariables;   //single variables
        toreturn[1]=thearrays;  // array variables
        return toreturn;                   
    }
    
    public boolean isarray(String variable)
    {
        if (variable.length() <6) {return false;}
        if ((variable.substring(0,5)).equals("array")) 
        {
            return true;
        } else {
            return false;
        }
    }
    
    public int findvar(String varname)
    {
        Iterator i=thevariables.iterator(); // search single variables
        while (i.hasNext())
        {            
            String thevar=(String) i.next();            
            int thevaraddy=((Integer) i.next()).intValue();
            if (thevar.equals(varname)) {return thevaraddy;}
        }
        
        i=thearrays.iterator(); // search arrays
        while (i.hasNext())
        {            
            String thevar=(String) i.next();
            if (thevar.equals("array"))
            {   
                Object blankobj=i.next();
            } else {
                int thevaraddy=((Integer) i.next()).intValue();
                if (thevar.equals(varname)) {return thevaraddy;}
            }
        }
        
        return -1;  // no
    }
    
    public ArrayList[] getall()
    {
        ArrayList[] toreturn=new ArrayList[2];
        toreturn[0]=commands;
        toreturn[1]=absolute;
        return toreturn;
    }
    
    public int getnum()
    {
        return commands.size();   
    }
    
    public boolean getinuse()
    {
        return inuse;
    }
    
    public void addtrace(processor p, int pc,int nocycle)
    {
        if (!inuse) {return;}   // not in use
        //System.out.println("TRACE "+p.getid()+" "+pc);
        if (pc <trace.length)
        {
            trace[pc].add(new Integer(p.getid()));  // add processor ID
            tracecycle[pc].add(new Integer(nocycle));  // add processor cycle
        }
        if (slicelist.size()>0)
        {
            if (isatstartofinstruction(pc))
            {
                Iterator i=slicelist.iterator();
                while (i.hasNext())
                {
                    slice theslice=(slice) i.next();
                    theslice.trace(pc,p.getid(),nocycle);
                }
            }
        }
    }  
    
    public boolean isatstartofinstruction(int pc)
    {
        Iterator i=absolute.iterator();
        while (i.hasNext())
        {
            if (pc==((Integer) i.next()).intValue()) {return true;}
            i.next();
        }
        return false;
    }
    
    public int[] getaddress(int instructionindex)
    {
        int toreturn[]=new int[2];
        toreturn[0]=((Integer) absolute.get(instructionindex*2)).intValue();
        toreturn[1]=((Integer) absolute.get((instructionindex*2) + 1)).intValue();
        return toreturn;
    }
    
    public int getinstructionnumber(int theaddress)
    {
        int instructionnum=1;
        Iterator i=absolute.iterator();
        while (i.hasNext())
        {
            int thestartaddr=((Integer) i.next()).intValue();   
            int theendaddr=((Integer) i.next()).intValue();   
            if ((theaddress >= thestartaddr) && (theaddress <= theendaddr))
            {
                return instructionnum;   
            }
            ++instructionnum;
        }
        return 0;
    }
    
    public ArrayList[] gettrace(int instructionindex)
    {
        
        ArrayList toreturn[]=new ArrayList[2];
        if (!inuse) {return toreturn;}
        int therange[]=getaddress(instructionindex);    // get the pc range of this instruction
        int maxsize=0;       
        //System.out.println(trace[therange[0]].size());
        toreturn[0]=trace[therange[0]];
        toreturn[1]=tracecycle[therange[0]];
                                
        return toreturn;
    }
    
    public void addslice(String varname,int varaddress)
    {
        slice thenewslice=new slice(this,m,varname,varaddress);
        slicelist.add(thenewslice);
    }
    
    public int makeslice(String varname,int varaddress,int addresstosliceat)
    {
        Iterator i=slicelist.iterator();
        while (i.hasNext())
        {
            slice me=(slice) i.next();
            if (me.getname().equals(varname))
            {
                if (me.isslice(addresstosliceat))
                {
                    me.removeslice(addresstosliceat);
                    return 0;
                } else {
                    me.addslice(addresstosliceat);
                    return 1;
                }   
            }            
        }
        addslice(varname,varaddress);
        makeslice(varname,varaddress,addresstosliceat);
        return 1;
    }
    
    public boolean isslice(String varname)
    {
        Iterator i=slicelist.iterator();
        while (i.hasNext())
        {
            slice me=(slice) i.next();
            if (me.getname().equals(varname))
            {
                return true;   
            }
        }
        return false;
    }
    
    public ArrayList[] getslice(String slicename)
    {
        ArrayList toreturn[]=new ArrayList[4];
        Iterator i=slicelist.iterator();
        while (i.hasNext())
        {
            slice me=(slice) i.next();
            if (me.getname().equals(slicename))
            {
                toreturn=me.getslice();  
            }
        }
        return toreturn;
    }
}