import javax.swing.*;
import javax.swing.tree.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.event. ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowEvent;
import javax.swing.event.MenuKeyListener;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class gui extends JPanel implements ActionListener, WindowListener, MouseListener
{
   
  protected JScrollPane jScrollPane1;
  protected  JTree jTree1;
  protected JPopupMenu popup;
    protected JScrollPane jScrollPane12;
  protected JList list;
    private DefaultMutableTreeNode top;
    private long starttime;
    private JMenuItem emulItem;
    private JMenuItem reportItem;
    private JMenuItem traceItem;
    private JMenuItem logItem;
    private JMenuItem resetItem;
    private JMenuItem openItem;
    private JMenuItem exitItem;
    private JMenuItem nextItem;
    private JMenuItem setprocmenu;
    private JMenuItem viewtraceItem;
    private JRadioButtonMenuItem erewmenu;
    private JRadioButtonMenuItem crewmenu;
    private JRadioButtonMenuItem ercwmenu;
    private JRadioButtonMenuItem weakmenu;
    private JRadioButtonMenuItem commonmenu;
    private JRadioButtonMenuItem tollerantmenu;
    private JRadioButtonMenuItem collisionmenu;
    private JRadioButtonMenuItem collisionpmenu;
    private JRadioButtonMenuItem arbitrarymenu;
    private JRadioButtonMenuItem prioritymenu;
    private JRadioButtonMenuItem logerrormenu;
    private JRadioButtonMenuItem fatalerrormenu;
    protected DefaultTreeModel treeModel;
    private memorymanager m;
    private highlevel h;
    private clock c;
    private processorlist plist;
    private executionreport exrep;
    private output o;
    private input in;
    private DefaultMutableTreeNode pcategory;
    private DefaultMutableTreeNode progNode;
    private boolean alreadyopen;
    
    public static void main(String args[])
    {
     //gui me=new gui();
    }
    
    public gui(memorymanager am, output ao,clock ac, processorlist aplist, highlevel ah,input ain)
    {
        m=am;
        in=ain;
        alreadyopen=false;
        h=ah;
        c=ac;
        c.setgui(this);
        o=ao;
        o.setgui(this);
        plist=aplist;
        try 
        {
            UIManager.setLookAndFeel(UIManager.
                                             getSystemLookAndFeelClassName());
        } catch (Exception exception) {
            exception.printStackTrace();
        }
                
        JMenuBar menuBar = new JMenuBar();
        
        JMenu menu = new JMenu("File");
        menuBar.add(menu);  
        openItem = new JMenuItem("Open");
        openItem.addActionListener(this);
        menu.add(openItem);
        menu.addSeparator();
        exitItem = new JMenuItem("Exit");
        exitItem.addActionListener(this);
        menu.add(exitItem);
        
        menu = new JMenu("Emulation");   
        menu.setMnemonic(KeyEvent.VK_ALT);
        menuBar.add(menu);        
        emulItem = new JMenuItem("Start");
        emulItem.addActionListener(this);
        menu.add(emulItem);
        nextItem = new JMenuItem("Cycle");
        nextItem.setMnemonic(KeyEvent.VK_C);
        nextItem.addActionListener(this);
        menu.add(nextItem);
        resetItem=new JMenuItem("Reset");
        resetItem.addActionListener(this);
        menu.add(resetItem);
        
         menu = new JMenu("Options");
        menuBar.add(menu);        
        JMenu submenu = new JMenu("Memory");
        menu.add(submenu);
        
        
         ButtonGroup group = new ButtonGroup();

        erewmenu = new JRadioButtonMenuItem("EREW");
        erewmenu.setSelected(true);
        
        group.add(erewmenu);
        erewmenu.addActionListener(this);
        submenu.add(erewmenu);

        crewmenu = new JRadioButtonMenuItem("CREW");
        
        group.add(crewmenu);
        crewmenu.addActionListener(this);
        submenu.add(crewmenu);
        
        ercwmenu = new JRadioButtonMenuItem("ERCW");
        
        group.add(ercwmenu);
        ercwmenu.addActionListener(this);
        submenu.add(ercwmenu);
        
        JMenu crcwmenu = new JMenu("CRCW");
        submenu.add(crcwmenu);
        
        weakmenu = new JRadioButtonMenuItem("Weak");        
        group.add(weakmenu);
        weakmenu.addActionListener(this);
        crcwmenu.add(weakmenu);
        
        commonmenu = new JRadioButtonMenuItem("Common");        
        group.add(commonmenu);
        commonmenu.addActionListener(this);
        crcwmenu.add(commonmenu);
        
        tollerantmenu = new JRadioButtonMenuItem("Tollerant");        
        group.add(tollerantmenu);
        tollerantmenu.addActionListener(this);
        crcwmenu.add(tollerantmenu);
        
        collisionmenu = new JRadioButtonMenuItem("Collision");        
        group.add(collisionmenu);
        collisionmenu.addActionListener(this);
        crcwmenu.add(collisionmenu);
        
        collisionpmenu = new JRadioButtonMenuItem("Collision+");        
        group.add(collisionpmenu);
        collisionpmenu.addActionListener(this);
        crcwmenu.add(collisionpmenu);
        
        arbitrarymenu = new JRadioButtonMenuItem("Arbitrary");        
        group.add(arbitrarymenu);
        arbitrarymenu.addActionListener(this);
        crcwmenu.add(arbitrarymenu);
        
        prioritymenu = new JRadioButtonMenuItem("Priority");        
        group.add(prioritymenu);
        prioritymenu.addActionListener(this);
        crcwmenu.add(prioritymenu);
        
        
         submenu = new JMenu("Memory Error");
        menu.add(submenu);
        
        
         ButtonGroup group2 = new ButtonGroup();

        logerrormenu = new JRadioButtonMenuItem("Log");
        logerrormenu.setSelected(true);
        
        group2.add(logerrormenu);
        logerrormenu.addActionListener(this);
        submenu.add(logerrormenu);

        fatalerrormenu = new JRadioButtonMenuItem("Fatal");
        
        group2.add(fatalerrormenu);
        fatalerrormenu.addActionListener(this);
        submenu.add(fatalerrormenu);
        
        menu.addSeparator();
        setprocmenu = new JMenuItem("Change Processors");
        setprocmenu.addActionListener(this);
        menu.add(setprocmenu);
        
        
         menu = new JMenu("Report");
        menuBar.add(menu);        
        reportItem = new JMenuItem("View Report");
        reportItem.setEnabled(false);
        reportItem.addActionListener(this);
        menu.add(reportItem);
        
        
        logItem = new JMenuItem("Memory Error Log");
        logItem.setEnabled(false);
        logItem.addActionListener(this);
        menu.add(logItem);
        
        popup = new JPopupMenu();
        traceItem = new JMenuItem("Add Trace");
        traceItem.addActionListener(this);
        popup.add(traceItem);

        viewtraceItem = new JMenuItem("View Trace");
        viewtraceItem.addActionListener(this);
        viewtraceItem.setEnabled(false);
        popup.add(viewtraceItem);
        
        JFrame theframe=new JFrame("PRAM Simulator");
        final Container cpane=theframe.getContentPane();
        cpane.setLayout(new BorderLayout());
        
        top =
            new DefaultMutableTreeNode("Simulator");
        createNodes(top);
        treeModel = new DefaultTreeModel(top);

        jTree1 = new JTree(treeModel);
        
        jTree1.getSelectionModel().setSelectionMode
            (TreeSelectionModel.SINGLE_TREE_SELECTION);
            jTree1.addMouseListener(this);        
        jTree1.putClientProperty("JTree.lineStyle", "None");
        jScrollPane1 = new JScrollPane(jTree1);
        
        String data[]={ };
        list=new JList(data);

        jScrollPane12 = new JScrollPane(list);
        
         JSplitPane splitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
         Dimension minimumSize = new Dimension(100, 50);
        jScrollPane1.setMinimumSize(minimumSize);
        jScrollPane12.setMinimumSize(minimumSize);
        
        splitPane.setTopComponent(jScrollPane1);
        splitPane.setBottomComponent(jScrollPane12);
        splitPane.setDividerLocation(250);
       splitPane.setPreferredSize(new Dimension(500, 300));
       splitPane.setResizeWeight(0.9d);
        cpane.add(splitPane,BorderLayout.CENTER);  
        
        //cpane.add(jScrollPane1,BorderLayout.CENTER);  
        //cpane.add(jScrollPane12,BorderLayout.SOUTH);  
        
        theframe.setJMenuBar(menuBar);
        theframe.addWindowListener(this);
        theframe.pack();
        theframe.setSize(600,400);
 
        theframe.setVisible(true);
    }
    
    public void mouseClicked(MouseEvent e)
    {
        JComponent cl = (JComponent) e.getSource();  
        
         if (e.isPopupTrigger()) {
                popup.show(e.getComponent(),
                           e.getX(), e.getY());
            }
        if (cl==jTree1 && e.getClickCount() == 2)
        {
            TreePath selPath = jTree1.getPathForLocation(e.getX(), e.getY());
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)
                       jTree1.getLastSelectedPathComponent();
            if (node == null) return;

            Object nodeInfo = node.getUserObject();
            if (node.isLeaf()) 
            {
                String name=((String) nodeInfo);     
                String selectiontype=new String("");
                boolean sofar=false;
                if (name.length() >=6)
                {
                    selectiontype=name.substring(0,6);
                }
            
                if (selectiontype.equals("Output"))
                {
                    sofar=true;
                    guioutput ogui=new guioutput(o); 
                   // updateoutput();
                }
                
                if (name.equals("High Level Code"))
                {
                    sofar=true;
                    guihighlevel hl=new guihighlevel(h,m);
                }
            
                if (name.length() >=9)
                {
                    selectiontype=name.substring(0,9);
                }
          
                    if (selectiontype.equals("Processor"))
                    {
                        String processornum=name.substring(10,name.length());

                        int pindex=(new Integer(processornum)).intValue();
                        pindex--;
                        processorgui pview=new processorgui(plist.get(pindex));
                     }
                    
                    DefaultMutableTreeNode thenode = (DefaultMutableTreeNode) selPath.getPathComponent(1);
                    
                    if (((String) thenode.getUserObject()).equals("Shared Memory"))
                    {
                        String memindex=getmemindex(name);
                
                        int mindex=(new Integer(memindex)).intValue();
                        memorygui mview=new memorygui(m,mindex);
                    }
                    
                                                                                
                    if (isinpath("Variables",selPath))
                    {
                        int theaddrofvar=h.findvar(name);
                        guival thevarview=new guival(name,m,theaddrofvar);
                    }                
           }
        }
    }
    
    public boolean isinpath(String totest,TreePath selPath)
    {
        for (int i=0;i<selPath.getPathCount();++i)
        {
            DefaultMutableTreeNode thenode = (DefaultMutableTreeNode) selPath.getPathComponent(i);                       
            String textofnode=(String) thenode.getUserObject();
            if (textofnode.equals(totest))
            {
                return true;   
            }
        }
        return false;
    }
    
    
    public void actionPerformed(ActionEvent e)
    {    
        JMenuItem cl = (JMenuItem) e.getSource(); 
        String st=cl.getText();
        //System.out.println (cl);
        
        if (cl==erewmenu)
        {
            m.setmodel(1);        
        }
        
        if (cl==crewmenu)
        {
            m.setmodel(2);        
        }
        
        if (cl==ercwmenu)
        {
            m.setmodel(3);        
        }
        
        if (cl==weakmenu)
        {
            m.setmodel(4);
            m.setcrcwmodel(0);
        }
        
        if (cl==commonmenu)
        {
            m.setmodel(4);  
            m.setcrcwmodel(1);
        }
        
        if (cl==tollerantmenu)
        {
            m.setmodel(4); 
            m.setcrcwmodel(2);
        }
        
        if (cl==collisionmenu)
        {
            m.setmodel(4); 
            m.setcrcwmodel(3);
        }
        
        if (cl==collisionpmenu)
        {
            m.setmodel(4);    
            m.setcrcwmodel(4);
        }
        
        if (cl==arbitrarymenu)
        {
            m.setmodel(4);    
            m.setcrcwmodel(5);
        }
        
        if (cl==prioritymenu)
        {
            m.setmodel(4);    
            m.setcrcwmodel(6);
        }
                                          
        if (cl==openItem)
        {
            
            
            
            JFileChooser chooser = new JFileChooser();        
            int returnVal = chooser.showOpenDialog(gui.this);
            if(returnVal == JFileChooser.APPROVE_OPTION) 
            {
                
                if (alreadyopen)
                {
                    hardreset();
                    MutableTreeNode parent = (MutableTreeNode)(progNode.getParent());
                    if (parent != null) 
                    {
                        treeModel.removeNodeFromParent(progNode);                
                    }              
                } else {
                    alreadyopen=true;   
                }
                                
                String filename=(chooser.getSelectedFile().getName());                
                String path=(chooser.getSelectedFile().getPath());
                if ((misc.getEnd(filename)).equals("pr"))
                {
                    int numberproc=plist.size();
                    h=misc.usetoloadmem(path,m,h,plist,o,in);
                    int nownumberproc=plist.size();
                    if (numberproc!=nownumberproc)
                    {
                        updateproclist();
                    }
                    
                    changememmodelselection();  
                    
                } else {
                    misc.loadMemory(path,m);
                }
                
                progNode = new DefaultMutableTreeNode(filename);
                
                
                if (h.getinuse())
                {                                        
                    ArrayList thevars[]=h.getvariables();
                    if ((thevars[0].size() >0) || (thevars[1].size() >0))
                    {
                        DefaultMutableTreeNode varbox = new DefaultMutableTreeNode("Variables");
                        progNode.add(varbox);
                        
                        Iterator j=thevars[1].iterator();   // add arrays to list first
                        if (thevars[1].size()>0)
                        {
                            Object blankobj=j.next();   // to get rid of the initial array string
                        }
                        while (j.hasNext())
                        {                            
                            String variable=new String("");   
                            DefaultMutableTreeNode arrayvar = new DefaultMutableTreeNode(j.next());
                            varbox.add(arrayvar);
                            
                            while (!variable.equals("array"))
                            {
                                if (!j.hasNext()) 
                                {
                                    variable="array";
                                } else {
                                    variable=(String) j.next();                                    
                                }
                                if (!variable.equals("array"))
                                {
                                       Integer addr=(Integer) j.next();
                                       DefaultMutableTreeNode inarrayvar = new DefaultMutableTreeNode(variable);
                                       arrayvar.add(inarrayvar);
                                }
                            }
                        }
                        
                        j=thevars[0].iterator();    // now add single variables
                        while (j.hasNext())
                        {
                               DefaultMutableTreeNode thevar = new DefaultMutableTreeNode((String) j.next());                               
                               varbox.add(thevar);
                               
                               Integer addr=(Integer) j.next();
                        }                    
                    }
                    
                    DefaultMutableTreeNode hlcode = new DefaultMutableTreeNode("High Level Code");
                    progNode.add(hlcode);
                }
                
                DefaultMutableTreeNode filesize = new DefaultMutableTreeNode(
                    "Size: "+(new Integer(misc.numberinstructions()*4)).toString()+" bytes");
                progNode.add(filesize);
                
                treeModel.insertNodeInto(progNode, top, 
                                 top.getChildCount());
            }
        }
        
        if (cl==resetItem)        
        {
            softreset();
        }
        
        if (cl==exitItem)
        {
            System.exit(0);   
        }
        
        if (cl==traceItem)
        {
            TreePath selPath = jTree1.getSelectionPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)
                       jTree1.getLastSelectedPathComponent();
            if (node == null) return;

            Object nodeInfo = node.getUserObject();
            if (node.isLeaf()) 
            {
                String name=((String) nodeInfo);     
                if (isinpath("Variables",selPath))
                {
                        int theaddrofvar=h.findvar(name);
                        guihighlevel thetraceview=new guihighlevel(h,m,theaddrofvar,name);
                }
            }
        }
        
        if (cl==viewtraceItem)
        {
            TreePath selPath = jTree1.getSelectionPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)
                       jTree1.getLastSelectedPathComponent();
            if (node == null) return;

            Object nodeInfo = node.getUserObject();
            if (node.isLeaf()) 
            {
                String name=((String) nodeInfo);     
                if (isinpath("Variables",selPath))
                {                        
                        slicegui thesliceview=new slicegui(h,name);
                }
            }
        }
        
        if (cl==logItem)
        {
            memerrorgui mer=new memerrorgui(m);   
        }
        
        if (cl==reportItem)
        {
            guireport repgui=new guireport(exrep);
        }
        
        if (cl==setprocmenu)
        {                        
            guival proclistings=new guival(this,plist,m,o,in,h);
        }
        
        if (cl==fatalerrormenu)
        {
            c.seterrormemstate(true);   
        }
        
         if (cl==logerrormenu)
        {
            c.seterrormemstate(false);   
        }

        
        if (cl==emulItem)        
        {
            if (c.getrunning())
            {
                JOptionPane.showMessageDialog(this, "A program is currently being executed");   
            } else {
                if (!alreadyopen)
                {
                    JOptionPane.showMessageDialog(this, "There is no program loaded to execute");
                } else {                    
                    o.resetupdate();
                    exrep=new executionreport(plist,m);
                    Date starttimer=new Date();            
                    starttime=starttimer.getTime();            
                    c.setreport(exrep);
                    c.setmemmanager(m);
                    new Thread(c).start();        
                
                    reportItem.setEnabled(true);                                                
                }
            }           
        }
   }
   
   public void updateoutput()
   {

        Vector thedata=new Vector();
               synchronized(thedata){
        ArrayList display=o.getdisplay();
        Iterator i =display.iterator();
        while(i.hasNext())
        {
            thedata.add((String) i.next());    
        }
    
        list.setListData(thedata);         
    }
   }
   
   public void windowActivated(final WindowEvent pWindowEvent)
   {
   }

   public void windowClosed(final WindowEvent pWindowEvent)
   {
   }

   public void windowClosing(final WindowEvent pWindowEvent)
   {
      final Window tWindow = pWindowEvent.getWindow();
      tWindow.setVisible(false);
      tWindow.dispose();
      System.exit(0);
   }

   public void windowDeactivated(final WindowEvent pWindowEvent)
   {
   }

   public void windowDeiconified(final WindowEvent pWindowEvent)
   {
   }

   public void windowIconified(final WindowEvent pWindowEvent)
   {
   }

   public void windowOpened(final WindowEvent pWindowEvent)
   {
   }
   
   public void mousePressed(MouseEvent e)
   {
       
        if (e.isPopupTrigger()) {
            viewtraceItem.setEnabled(false); 
            TreePath selPath = jTree1.getSelectionPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)
                       jTree1.getLastSelectedPathComponent();
            if (node == null) return;

            Object nodeInfo = node.getUserObject();
            if (node.isLeaf()) 
            {
                String name=((String) nodeInfo);     
                if (isinpath("Variables",selPath))
                {
                    if (h.isslice(name))
                    {
                        viewtraceItem.setEnabled(true);   
                    }                     
                }
            }
                popup.show(e.getComponent(),
                           e.getX(), e.getY());
            }
   }
   
   public void mouseReleased(MouseEvent e)
   {
       
        if (e.isPopupTrigger()) {
            viewtraceItem.setEnabled(false); 
            TreePath selPath = jTree1.getSelectionPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)
                       jTree1.getLastSelectedPathComponent();
            if (node == null) return;

            Object nodeInfo = node.getUserObject();
            if (node.isLeaf()) 
            {
                String name=((String) nodeInfo);     
                if (isinpath("Variables",selPath))
                {
                    if (h.isslice(name))
                    {
                        viewtraceItem.setEnabled(true);   
                    }                     
                }
            }
            
                popup.show(e.getComponent(),
                           e.getX(), e.getY());
            }
   }
   
   public void mouseEntered(MouseEvent e)
   {
   }
   
   public void mouseExited(MouseEvent e)
   {
   }

 
 private void createNodes(DefaultMutableTreeNode top) {
        DefaultMutableTreeNode category = null;
        DefaultMutableTreeNode memory = null;
        DefaultMutableTreeNode thep = null;
        DefaultMutableTreeNode book = null;
        pcategory = new DefaultMutableTreeNode("Processors");
        top.add(pcategory);
      

        ArrayList theprocessors=plist.get();
        Iterator i=theprocessors.iterator();
        int j=1;
        while (i.hasNext())
        {
            i.next();
             thep = new DefaultMutableTreeNode(new String             
            ("Processor "+j));
        pcategory.add(thep); 
        j++;
        }
        
        if (plist.size()==0)
        {
            thep = new DefaultMutableTreeNode(new String             
            ("None"));
            pcategory.add(thep); 
        }
        
        memory = new DefaultMutableTreeNode("Shared Memory");
        top.add(memory);

        int memsize=m.getsize();
        
        int thenumber=0;
        memsize=memsize/1024; 
        int dividesize=memsize/100;
        dividesize++;
        for (int p=0;p<dividesize;++p)
        {
           // System.out.println(p);
            category = new DefaultMutableTreeNode((p*100)+" - "+((p+1)*100)+" Kb");
            memory.add(category);
            for (int tencount=0;tencount<10;++tencount)
            {              
                DefaultMutableTreeNode tencategory = new DefaultMutableTreeNode(((p*10+tencount)*10)+" - "+((p*10+tencount+1)*10)+" Kb");
                category.add(tencategory);
                for (j=0;j<10;++j)
                {
                    if (thenumber >= memsize) {j=101; tencount=11; p=dividesize+1;}
                    book = new DefaultMutableTreeNode(new String            
                    (thenumber+" - "+(thenumber+1)+" Kb"));
                    tencategory.add(book);
                    ++thenumber;
                }
            }
        }
        
        DefaultMutableTreeNode clocknode = new DefaultMutableTreeNode("Clock");
        top.add(clocknode);
        DefaultMutableTreeNode viewclocknode = new DefaultMutableTreeNode("View");
        clocknode.add(viewclocknode);
        
        DefaultMutableTreeNode exservicenode = new DefaultMutableTreeNode("External Services");
        top.add(exservicenode);
        DefaultMutableTreeNode outputnode = new DefaultMutableTreeNode("Output");
        exservicenode.add(outputnode);
    }
    
    public String getmemindex(String theselection)
    {
        String toreturn=theselection.substring(0,1);
        for (int i=1;i<theselection.length();++i)
        {
            String thecharacter=theselection.substring(i,i+1);
            if (thecharacter.equals(" "))
            {
                i=theselection.length();   
            } else {
                toreturn=toreturn+thecharacter;   
            }            
        }
        return toreturn;
    }
    
    public void clockdone()
    {
        
                Date endtimer=new Date();            
                long endtime=endtimer.getTime();
                exrep.settime(endtime-starttime);
                if (m.geterrors()!=0)
                {
                    logItem.setEnabled(true);
                }
    }
    
    public void fatalmemerror(int thecycle)
    {      
        JOptionPane.showMessageDialog(this, "Execution Terminated Due To Memory Error At Cycle "+thecycle);
    }

    public void softreset()
    {
        o.reset();
        if (exrep!=null) {exrep.reset();}
        c.resetall();
        ArrayList proclist=plist.get();
        Iterator i=proclist.iterator();
        while(i.hasNext())
        {
            processor ptouse=(processor) i.next();
            ptouse.resetall();
        }
        in.reset();
        h.reset();
        m.reset();
        updateoutput();   
        reportItem.setEnabled(false);
        logItem.setEnabled(false);
    }
    
    public void hardreset()
    {
        softreset();
        m.resetall();
        h.resetall();
        changememmodelselection();
    }
    
    public void changememmodelselection()
    {
        int memmode=m.getmodel();
        int crcwmode=m.getcrcwmodel();
                    
        if (memmode==1) {erewmenu.setSelected(true);}
        if (memmode==2) {crewmenu.setSelected(true);}
        if (memmode==3) {ercwmenu.setSelected(true);}
        if (memmode==4) 
        {
            if (crcwmode==0) {weakmenu.setSelected(true);}
            if (crcwmode==1) {commonmenu.setSelected(true);}
            if (crcwmode==2) {tollerantmenu.setSelected(true);}
            if (crcwmode==3) {collisionmenu.setSelected(true);}
            if (crcwmode==4) {collisionpmenu.setSelected(true);}
            if (crcwmode==5) {arbitrarymenu.setSelected(true);}
            if (crcwmode==6) {prioritymenu.setSelected(true);}
        }                  
    }
    
    public void updateproclist()
    {
       // pcategory.removeAllChildren();
        
        MutableTreeNode parent = (MutableTreeNode)(pcategory.getParent());
                if (parent != null) 
                {
                    treeModel.removeNodeFromParent(pcategory);                
                }          
        pcategory=new DefaultMutableTreeNode("Processors");
        int numberprocessors=plist.size();
        for (int pcount=1;pcount<=numberprocessors;++pcount)
        {
            DefaultMutableTreeNode proccy = new DefaultMutableTreeNode("Processor "+pcount);
            pcategory.add(proccy);
        }   
        treeModel.insertNodeInto(pcategory, top,0);
    }
}