/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Iterator;

public class processor
implements instructions {
    private ArrayList registers;
    private ArrayList registerindex;
    private register r0;
    private register at;
    private register v0;
    private register v1;
    private register a0;
    private register a1;
    private register a2;
    private register a3;
    private register t0;
    private register t1;
    private register t2;
    private register t3;
    private register t4;
    private register t5;
    private register t6;
    private register t7;
    private register s0;
    private register s1;
    private register s2;
    private register s3;
    private register s4;
    private register s5;
    private register s6;
    private register s7;
    private register t8;
    private register t9;
    private register k0;
    private register k1;
    private register gp;
    private register sp;
    private register s8;
    private register ra;
    private register pc;
    private memorymanager mem;
    private processorlist plist;
    private int one;
    private int two;
    private int three;
    private int four;
    private boolean halt;
    private int nocycle;
    private int procid;
    private int opcode;
    private output o;
    private input input;
    private highlevel h;
    private int memwrite = 0;
    private int memread;
    private int registeraccess;
    private int arithmetic;
    private int conditionals;
    private int jumps;
    private boolean suspended;
    private boolean waitforinput;
    private clock caller;

    public processor(memorymanager amem, output outp, input ainput, int pid, processorlist aplist) {
        this.input = ainput;
        this.memread = 0;
        this.registeraccess = 0;
        this.arithmetic = 0;
        this.conditionals = 0;
        this.jumps = 0;
        this.suspended = false;
        this.waitforinput = false;
        this.procid = pid;
        this.plist = aplist;
        this.o = outp;
        this.mem = amem;
        this.registerindex = new ArrayList();
        this.registers = new ArrayList();
        this.r0 = new register();
        this.registers.add(this.r0);
        this.at = new register();
        this.registers.add(this.at);
        this.v0 = new register();
        this.registers.add(this.v0);
        this.v1 = new register();
        this.registers.add(this.v1);
        this.a0 = new register();
        this.registers.add(this.a0);
        this.a1 = new register();
        this.registers.add(this.a1);
        this.a2 = new register();
        this.registers.add(this.a2);
        this.a3 = new register();
        this.registers.add(this.a3);
        this.t0 = new register();
        this.registers.add(this.t0);
        this.t1 = new register();
        this.registers.add(this.t1);
        this.t2 = new register();
        this.registers.add(this.t2);
        this.t3 = new register();
        this.registers.add(this.t3);
        this.t4 = new register();
        this.registers.add(this.t4);
        this.t5 = new register();
        this.registers.add(this.t5);
        this.t6 = new register();
        this.registers.add(this.t6);
        this.t7 = new register();
        this.registers.add(this.t7);
        this.s0 = new register();
        this.registers.add(this.s0);
        this.s1 = new register();
        this.registers.add(this.s1);
        this.s2 = new register();
        this.registers.add(this.s2);
        this.s3 = new register();
        this.registers.add(this.s3);
        this.s4 = new register();
        this.registers.add(this.s4);
        this.s5 = new register();
        this.registers.add(this.s5);
        this.s6 = new register();
        this.registers.add(this.s6);
        this.s7 = new register();
        this.registers.add(this.s7);
        this.t8 = new register();
        this.registers.add(this.t8);
        this.t9 = new register();
        this.registers.add(this.t9);
        this.k0 = new register();
        this.registers.add(this.k0);
        this.k1 = new register();
        this.registers.add(this.k1);
        this.gp = new register();
        this.registers.add(this.gp);
        this.sp = new register();
        this.registers.add(this.sp);
        this.s8 = new register();
        this.registers.add(this.s8);
        this.ra = new register();
        this.registers.add(this.ra);
        this.pc = new register();
        this.pc.put(0);
        this.at.put(pid);
        for (int i = 0; i < 32; ++i) {
            this.registerindex.add(new Integer(i));
        }
        this.halt = false;
        this.nocycle = 0;
    }

    public void resetall() {
        this.memwrite = 0;
        this.memread = 0;
        this.registeraccess = 0;
        this.arithmetic = 0;
        this.conditionals = 0;
        this.jumps = 0;
        this.suspended = false;
        this.waitforinput = false;
        this.nocycle = 0;
        this.halt = false;
        this.pc.reset();
        Iterator i = this.registers.iterator();
        while (i.hasNext()) {
            register r = (register)i.next();
            r.reset();
        }
        this.at.put(this.procid);
    }

    public void sethlevel(highlevel ah) {
        this.h = ah;
    }

    public void updatecycle() {
        ++this.nocycle;
    }

    public boolean signal(int cycle, int phase, clock acaller) {
        this.caller = acaller;
        if (this.halt) {
            return false;
        }
        if (this.suspended) {
            return true;
        }
        if (this.waitforinput) {
            return true;
        }
        if (phase == 1) {
            ++this.nocycle;
            int count = this.pc.get();
            if (!this.mem.checkinstruction(count)) {
                return false;
            }
            this.one = this.mem.get(count);
            this.two = this.mem.get(++count);
            this.three = this.mem.get(++count);
            this.four = this.mem.get(++count);
            this.pc.put(++count);
            Integer ione = new Integer(this.one);
            String thebinstring = misc.toBinary(ione);
            this.opcode = misc.fromBinary(thebinstring.substring(0, 6));
            this.h.addtrace(this, count - 4);
            return true;
        }
        if (phase == 2) {
            switch (this.opcode) {
                case 9: {
                    this.addiu();
                    break;
                }
                case 0: {
                    this.special();
                    break;
                }
                case 4: {
                    this.beq();
                    break;
                }
                case 5: {
                    this.bne();
                    break;
                }
                case 7: {
                    this.bgtz();
                    break;
                }
                case 2: {
                    this.j();
                    break;
                }
                case 15: {
                    this.lui();
                    break;
                }
                case 3: {
                    this.jal();
                    break;
                }
                case 6: {
                    this.blez();
                    break;
                }
                case 28: {
                    this.special2();
                    break;
                }
            }
            return !this.halt;
        }
        if (phase == 3) {
            switch (this.opcode) {
                case 35: {
                    this.lw(cycle);
                    break;
                }
                case 36: {
                    this.lbu(cycle);
                    break;
                }
            }
            return true;
        }
        if (phase == 4) {
            switch (this.opcode) {
                case 43: {
                    this.sw(cycle);
                    break;
                }
                case 40: {
                    this.sb(cycle);
                    break;
                }
            }
            return true;
        }
        return false;
    }

    private void special() {
        Integer ifour = new Integer(this.four);
        String thebinstring = misc.toBinary(ifour);
        int funct = misc.fromBinary(thebinstring.substring(2, 8));
        switch (funct) {
            case 37: {
                this.or();
                break;
            }
            case 33: {
                this.addu();
                break;
            }
            case 35: {
                this.subu();
                break;
            }
            case 12: {
                this.syscall();
                break;
            }
            case 8: {
                this.jr();
                break;
            }
            case 27: {
                this.divu();
                break;
            }
            case 13: {
                this.breakinst();
                break;
            }
        }
    }

    private void special2() {
        Integer ifour = new Integer(this.four);
        String thebinstring = misc.toBinary(ifour);
        int funct = misc.fromBinary(thebinstring.substring(2, 8));
        switch (funct) {
            case 2: {
                this.mul();
                break;
            }
        }
    }

    public void syscall() {
        Integer thein;
        register touse = (register)this.registers.get(2);
        if (touse.get() == 1) {
            this.halt = true;
        }
        if (touse.get() == 2) {
            thein = new Integer(this.a0.get());
            this.o.display(thein.toString());
        }
        if (touse.get() == 3) {
            this.o.displayline();
        }
        if (touse.get() == 4) {
            int theint = this.a0.get();
            char c = (char)theint;
            Character thechar = new Character(c);
            this.o.display(thechar.toString());
        }
        if (touse.get() == 5) {
            thein = new Integer(this.a0.get());
            this.o.display(thein.toString());
            this.o.displayline();
        }
        if (touse.get() == 6) {
            touse.put(this.plist.size());
        }
        if (touse.get() == 7) {
            this.input.getinput(false);
            this.waitforinput = true;
        }
        if (touse.get() == 8) {
            System.out.println("INPUT " + this.procid);
            this.input.setproc(this);
            new Thread(this.input).start();
            this.waitforinput = true;
        }
        if (touse.get() == 9) {
            int theinput = this.input.getnext();
            touse.put(theinput);
        }
        if (touse.get() == 10) {
            touse.put(this.input.getsize());
        }
        if (touse.get() == 11) {
            this.caller.setsyncmode(false);
            this.caller.sync(this.procid);
        }
        if (touse.get() == 12) {
            this.caller.setsyncmode(true);
            this.caller.sync(this.procid);
        }
    }

    private void or() {
        misc themisc = new misc();
        int[] thevalues = themisc.checkrtype(this.one, this.two, this.three, this.four);
        int rs = thevalues[1];
        int rt = thevalues[2];
        int rd = thevalues[3];
        register toput = (register)this.registers.get(rd);
        register oneor = (register)this.registers.get(rs);
        register twoor = (register)this.registers.get(rt);
        String orresult = misc.ortwostring(misc.toBinary(oneor.get()), misc.toBinary(twoor.get()));
        toput.put(misc.fromBinary(orresult));
    }

    private void divu() {
        ++this.arithmetic;
        misc themisc = new misc();
        int[] thevalues = themisc.checkitype(this.one, this.two, this.three, this.four);
        register regone = (register)this.registers.get(thevalues[1]);
        register regtwo = (register)this.registers.get(thevalues[2]);
        int regoneval = regone.get();
        int regtwoval = regtwo.get();
        int result = regoneval / regtwoval;
        double r = (double)regoneval / (double)regtwoval;
        double thepoint = r - (double)result;
        double quotent = thepoint * 10.0;
        int qtoput = (int)quotent;
        regtwo.put(qtoput);
        regone.put(result);
    }

    private void mul() {
        ++this.arithmetic;
        misc themisc = new misc();
        int[] thevalues = themisc.checkrtype(this.one, this.two, this.three, this.four);
        int rs = thevalues[1];
        int rt = thevalues[2];
        int rd = thevalues[3];
        register toput = (register)this.registers.get(rd);
        register onemul = (register)this.registers.get(rs);
        register twomul = (register)this.registers.get(rt);
        int onemulval = onemul.get();
        int twomulval = twomul.get();
        int mulresult = onemulval * twomulval;
        toput.put(mulresult);
    }

    private void jal() {
        ++this.jumps;
        this.ra.put(this.pc.get() + 4);
        this.j();
    }

    private void breakinst() {
        this.ra.put(this.pc.get() + 4);
        this.pc.put(1047552);
    }

    private void jr() {
        ++this.jumps;
        misc themisc = new misc();
        int[] thevalues = themisc.checkitype(this.one, this.two, this.three, this.four);
        register toget = (register)this.registers.get(thevalues[1]);
        this.pc.put(toget.get());
    }

    private void lbu(int acycle) {
        ++this.memread;
        misc themisc = new misc();
        int[] thevalues = themisc.checkitype(this.one, this.two, this.three, this.four);
        register touse = (register)this.registers.get(thevalues[2]);
        int addrtouse = thevalues[3];
        touse.put(this.mem.get(addrtouse += ((register)this.registers.get(thevalues[1])).get(), this.procid, acycle));
    }

    private void lw(int acycle) {
        ++this.memread;
        misc themisc = new misc();
        int[] thevalues = themisc.checkitype(this.one, this.two, this.three, this.four);
        register touse = (register)this.registers.get(thevalues[2]);
        int addrtouse = thevalues[3];
        int bone = this.mem.get(addrtouse += ((register)this.registers.get(thevalues[1])).get(), this.procid, acycle);
        int btwo = this.mem.get(addrtouse + 1, this.procid, acycle);
        int bthree = this.mem.get(addrtouse + 2, this.procid, acycle);
        int bfour = this.mem.get(addrtouse + 3, this.procid, acycle);
        String thebinst = misc.toBinary(bone) + misc.toBinary(btwo) + misc.toBinary(bthree) + misc.toBinary(bfour);
        touse.put(misc.fromBinary(thebinst));
    }

    private void sb(int acycle) {
        ++this.memwrite;
        misc themisc = new misc();
        int[] thevalues = themisc.checkitype(this.one, this.two, this.three, this.four);
        register touse = (register)this.registers.get(thevalues[2]);
        int addrtouse = thevalues[3];
        this.mem.put(touse.get(), addrtouse += ((register)this.registers.get(thevalues[1])).get(), this.procid, acycle);
    }

    private void sw(int acycle) {
        ++this.memwrite;
        misc themisc = new misc();
        int[] thevalues = themisc.checkitype(this.one, this.two, this.three, this.four);
        register touse = (register)this.registers.get(thevalues[2]);
        int addrtouse = thevalues[3];
        addrtouse += ((register)this.registers.get(thevalues[1])).get();
        int regint = touse.get();
        String thebinst = misc.toBinary(regint);
        int lenofst = thebinst.length();
        if (32 - lenofst > 0) {
            thebinst = misc.addzero(thebinst, 32 - lenofst);
        }
        String tpone = thebinst.substring(0, 8);
        String tptwo = thebinst.substring(8, 16);
        String tpthree = thebinst.substring(16, 24);
        String tpfour = thebinst.substring(24, 32);
        this.mem.put(misc.fromBinary(tpone), addrtouse, this.procid, acycle);
        this.mem.put(misc.fromBinary(tptwo), addrtouse + 1, this.procid, acycle);
        this.mem.put(misc.fromBinary(tpthree), addrtouse + 2, this.procid, acycle);
        this.mem.put(misc.fromBinary(tpfour), addrtouse + 3, this.procid, acycle);
    }

    private void j() {
        ++this.jumps;
        misc themisc = new misc();
        int[] thevalues = themisc.checkjtype(this.one, this.two, this.three, this.four);
        int valofjump = thevalues[1];
        this.pc.put(valofjump *= 4);
    }

    private void lui() {
        ++this.registeraccess;
        misc themisc = new misc();
        int[] thevalues = themisc.checkitype(this.one, this.two, this.three, this.four);
        register thereg = (register)this.registers.get(thevalues[2]);
        String thetopbit = misc.toBinary(thevalues[3]);
        thetopbit = thetopbit + "0000000000000000";
        thereg.put(misc.fromBinary(thetopbit));
    }

    private void beq() {
        ++this.conditionals;
        misc themisc = new misc();
        int[] thevalues = themisc.checkitype(this.one, this.two, this.three, this.four);
        int regone = thevalues[1];
        int regtwo = thevalues[2];
        int addr = thevalues[3];
        register theregone = (register)this.registers.get(regone);
        register theregtwo = (register)this.registers.get(regtwo);
        int valofone = theregone.get();
        int valoftwo = theregtwo.get();
        if (regtwo == 0) {
            valoftwo = 0;
        }
        if (valofone == valoftwo) {
            int[] addrt = themisc.twoscomp(this.three, this.four);
            if (addrt[0] == 0) {
                this.branch(addrt[1], false);
            } else {
                this.branch(addrt[1], true);
            }
        }
    }

    private void bgtz() {
        ++this.conditionals;
        misc themisc = new misc();
        int[] thevalues = themisc.checkitype(this.one, this.two, this.three, this.four);
        int regone = thevalues[1];
        int addr = thevalues[3];
        register theregone = (register)this.registers.get(regone);
        int valofone = theregone.get();
        if (valofone > 0) {
            int[] addrt = themisc.twoscomp(this.three, this.four);
            if (addrt[0] == 0) {
                this.branch(addrt[1], false);
            } else {
                this.branch(addrt[1], true);
            }
        }
    }

    private void blez() {
        ++this.conditionals;
        misc themisc = new misc();
        int[] thevalues = themisc.checkitype(this.one, this.two, this.three, this.four);
        int regone = thevalues[1];
        int addr = thevalues[3];
        register theregone = (register)this.registers.get(regone);
        int valofone = theregone.get();
        if (valofone <= 0) {
            int[] addrt = themisc.twoscomp(this.three, this.four);
            if (addrt[0] == 0) {
                this.branch(addrt[1], false);
            } else {
                this.branch(addrt[1], true);
            }
        }
    }

    private void bne() {
        ++this.conditionals;
        misc themisc = new misc();
        int[] thevalues = themisc.checkitype(this.one, this.two, this.three, this.four);
        int regone = thevalues[1];
        int regtwo = thevalues[2];
        int addr = thevalues[3];
        register theregone = (register)this.registers.get(regone);
        register theregtwo = (register)this.registers.get(regtwo);
        int valofone = theregone.get();
        int valoftwo = theregtwo.get();
        if (regtwo == 0) {
            valoftwo = 0;
        }
        if (valofone != valoftwo) {
            int[] addrt = themisc.twoscomp(this.three, this.four);
            if (addrt[0] == 0) {
                this.branch(addrt[1], false);
            } else {
                this.branch(addrt[1], true);
            }
        }
    }

    private void addu() {
        ++this.arithmetic;
        misc themisc = new misc();
        int[] thevalues = themisc.checkrtype(this.one, this.two, this.three, this.four);
        int rs = thevalues[1];
        int rt = thevalues[2];
        int rd = thevalues[3];
        register toput = (register)this.registers.get(rd);
        register oneadd = (register)this.registers.get(rs);
        register twoadd = (register)this.registers.get(rt);
        toput.put(oneadd.get() + twoadd.get());
    }

    private void subu() {
        ++this.arithmetic;
        misc themisc = new misc();
        int[] thevalues = themisc.checkrtype(this.one, this.two, this.three, this.four);
        int rs = thevalues[1];
        int rt = thevalues[2];
        int rd = thevalues[3];
        register toput = (register)this.registers.get(rd);
        register oneadd = (register)this.registers.get(rs);
        register twoadd = (register)this.registers.get(rt);
        toput.put(oneadd.get() - twoadd.get());
    }

    private void addiu() {
        ++this.registeraccess;
        misc themisc = new misc();
        int[] thevalues = themisc.checkitype(this.one, this.two, this.three, this.four);
        register rs = (register)this.registers.get(thevalues[1]);
        register rt = (register)this.registers.get(thevalues[2]);
        int val = this.three * 256;
        val += this.four;
        if (thevalues[1] != 0) {
            val += rs.get();
        }
        rt.put(val);
    }

    private void branch(int addr, boolean negative) {
        addr *= 4;
        addr = !negative ? (addr += this.pc.get()) : this.pc.get() - addr;
        this.pc.put(addr);
    }

    public void setsuspended(boolean issuspended) {
        this.suspended = issuspended;
    }

    public boolean getsuspended() {
        return this.suspended;
    }

    public ArrayList getregisters() {
        return this.registers;
    }

    public ArrayList getregindex() {
        return this.registerindex;
    }

    public int getpc() {
        return this.pc.get();
    }

    public void setpc(int theval) {
        this.pc.put(theval);
    }

    public void reset() {
        this.nocycle = 0;
        this.halt = false;
    }

    public int getcycle() {
        return this.nocycle;
    }

    public int getid() {
        return this.procid;
    }

    public void setwait(boolean toset) {
        this.waitforinput = toset;
    }

    public int[] getinstuse() {
        int[] toreturn = new int[]{this.memwrite, this.memread, this.registeraccess, this.arithmetic, this.conditionals, this.jumps};
        return toreturn;
    }
}

