/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Iterator;

public class memorymanager {
    memory thememory;
    private int rmode = 1;
    private int wmode = 1;
    private int cwmode = 1;
    private int errors = 0;
    private ArrayList errorlist = new ArrayList();
    private ArrayList[] readhistory;
    private ArrayList[] writehistory;

    public memorymanager() {
        this.thememory = new memory(0x100000);
        this.readhistory = new ArrayList[this.getsize()];
        this.writehistory = new ArrayList[this.getsize()];
    }

    public void setmodel(int mode) {
        if (mode == 1) {
            this.rmode = 0;
            this.wmode = 0;
        }
        if (mode == 2) {
            this.rmode = 1;
            this.wmode = 0;
        }
        if (mode == 3) {
            this.rmode = 0;
            this.wmode = 1;
        }
        if (mode == 4) {
            this.rmode = 1;
            this.wmode = 1;
        }
    }

    public void setcrcwmodel(int mode) {
        this.cwmode = mode;
    }

    public int getcrcwmodel() {
        return this.cwmode;
    }

    public int getmodel() {
        if (this.rmode == 0 && this.wmode == 0) {
            return 1;
        }
        if (this.rmode == 1 && this.wmode == 0) {
            return 2;
        }
        if (this.rmode == 0 && this.wmode == 1) {
            return 3;
        }
        if (this.rmode == 1 && this.wmode == 1) {
            return 4;
        }
        return 0;
    }

    public void put(byte toput, int address) {
        this.thememory.put(toput, address);
    }

    public void clear() {
        this.thememory.clear();
    }

    public void put(int toput, int address, int pid, int cycleid) {
        boolean isconflict = this.conflicttest(address, cycleid, 1);
        if (isconflict) {
            if (this.wmode == 0) {
                this.errorlist.add("Processor " + pid + " write conflict. Cycle " + cycleid + " write to address " + address);
                ++this.errors;
            } else {
                boolean concconflict = this.writeconflict(toput, address, pid, cycleid);
                if (concconflict) {
                    this.errorlist.add("Processor " + pid + " write conflict. Cycle " + cycleid + " write to address " + address);
                    ++this.errors;
                }
            }
        } else {
            this.writehistory[address].add(new Integer(cycleid));
            this.put(toput, address);
        }
    }

    public int get(int address, int pid, int cycleid) {
        if (this.rmode == 0) {
            boolean isconflict = this.conflicttest(address, cycleid, 0);
            if (isconflict) {
                this.errorlist.add("Processor " + pid + "read conflict. Cycle " + cycleid + " read from address " + address);
                ++this.errors;
            } else {
                this.readhistory[address].add(new Integer(cycleid));
            }
        }
        return this.get(address);
    }

    public void put(int toput, int address) {
        Integer pbyte = new Integer(toput -= 128);
        byte tput = pbyte.byteValue();
        this.thememory.put(tput, address);
    }

    public void change(int toput, int address) {
        Integer pbyte = new Integer(toput -= 128);
        byte tput = pbyte.byteValue();
        this.thememory.change(tput, address);
    }

    public int get(int address) {
        byte ag = this.thememory.get(address);
        int g = ag + 128;
        return g;
    }

    public boolean checkinstruction(int check) {
        return this.thememory.listsize() + 3 >= check;
    }

    public ArrayList getpage(int page) {
        return this.thememory.getpage(page);
    }

    public int getsize() {
        return this.thememory.listsize();
    }

    public void testifexist(int indextotest, int whichone) {
        if (whichone == 0) {
            if (this.readhistory[indextotest] == null) {
                this.readhistory[indextotest] = new ArrayList();
            }
        } else if (this.writehistory[indextotest] == null) {
            this.writehistory[indextotest] = new ArrayList();
        }
    }

    public boolean conflicttest(int addrtotest, int cycle, int whichone) {
        this.testifexist(addrtotest, whichone);
        Iterator i = whichone == 0 ? this.readhistory[addrtotest].iterator() : this.writehistory[addrtotest].iterator();
        while (i.hasNext()) {
            int individualcycle = (Integer)i.next();
            if (individualcycle != cycle) continue;
            return true;
        }
        return false;
    }

    public boolean writeconflict(int toput, int addrtouse, int pid, int acycle) {
        if (this.cwmode == 0) {
            return this.get(addrtouse) != 0 || toput != 0;
        }
        if (this.cwmode == 1) {
            return this.get(addrtouse) != toput;
        }
        if (this.cwmode == 2) {
            return false;
        }
        if (this.cwmode == 3) {
            this.put(0, addrtouse);
            return false;
        }
        if (this.cwmode == 4) {
            if (this.get(addrtouse) != toput) {
                this.put(0, addrtouse);
            }
            return false;
        }
        if (this.cwmode == 5) {
            return false;
        }
        return this.cwmode != 6;
    }

    public int geterrors() {
        return this.errors;
    }

    public ArrayList geterrorlist() {
        return this.errorlist;
    }

    public void reset() {
        int i;
        this.errors = 0;
        this.errorlist.clear();
        int g = this.readhistory.length;
        for (i = 0; i < g; ++i) {
            if (this.readhistory[i] == null) continue;
            this.readhistory[i].clear();
        }
        g = this.writehistory.length;
        for (i = 0; i < g; ++i) {
            if (this.writehistory[i] == null) continue;
            this.writehistory[i].clear();
        }
    }

    public void resetall() {
        this.reset();
        this.rmode = 1;
        this.wmode = 1;
        this.cwmode = 1;
        this.thememory.reset();
    }
}

