/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class memorygui
extends JPanel
implements ActionListener,
WindowListener,
MouseListener {
    protected JScrollPane jScrollPane1;
    protected JButton buttonprev;
    protected JButton buttonnext;
    protected JList list;
    protected memorymanager m;
    protected int page;

    public static void main(String[] args) {
    }

    public memorygui(memorymanager am, int apage) {
        this.m = am;
        this.page = apage;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Container container1 = new Container();
        container1.setLayout(new BorderLayout());
        JFrame theframe = new JFrame("Memory");
        Container cpane = theframe.getContentPane();
        cpane.setLayout(new BorderLayout());
        String[] data = new String[]{};
        this.list = new JList<String>(data);
        this.list.addMouseListener(this);
        this.jScrollPane1 = new JScrollPane(this.list);
        this.updatemem();
        cpane.add((Component)this.jScrollPane1, "Center");
        this.buttonprev = new JButton("Prev");
        this.buttonnext = new JButton("Next");
        this.buttonprev.addMouseListener(this);
        this.buttonnext.addMouseListener(this);
        if (this.page == 0) {
            this.buttonprev.setEnabled(false);
        }
        container1.add((Component)this.buttonprev, "West");
        container1.add((Component)this.buttonnext, "East");
        cpane.add((Component)container1, "South");
        theframe.addWindowListener(this);
        theframe.pack();
        theframe.setSize(200, 300);
        theframe.setVisible(true);
    }

    public void mouseClicked(MouseEvent e) {
        JComponent cl = (JComponent)e.getSource();
        if (cl == this.list) {
            String thestr = (String)this.list.getSelectedValue();
            String data = thestr.substring(0, 8);
            Integer thed = new Integer(data);
            int theintdata = thed;
            int dataval = this.m.get(theintdata);
            guival editor = new guival("Memory Address " + data, dataval, this.m, theintdata, this);
        }
        if (cl == this.buttonnext) {
            ++this.page;
            this.updatemem();
            this.buttonprev.setEnabled(true);
        }
        if (cl == this.buttonprev) {
            if (this.page != 0) {
                --this.page;
                this.updatemem();
            }
            if (this.page == 0) {
                this.buttonprev.setEnabled(false);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void windowActivated(WindowEvent pWindowEvent) {
    }

    public void windowClosed(WindowEvent pWindowEvent) {
    }

    public void windowClosing(WindowEvent pWindowEvent) {
        Window tWindow = pWindowEvent.getWindow();
        tWindow.setVisible(false);
        tWindow.dispose();
    }

    public void windowDeactivated(WindowEvent pWindowEvent) {
    }

    public void windowDeiconified(WindowEvent pWindowEvent) {
    }

    public void windowIconified(WindowEvent pWindowEvent) {
    }

    public void windowOpened(WindowEvent pWindowEvent) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void updatemem() {
        ArrayList memcontents = this.m.getpage(this.page);
        Vector<String> thedata = new Vector<String>();
        Iterator i = memcontents.iterator();
        int addr = 1024 * this.page;
        while (i.hasNext()) {
            Byte theval = (Byte)i.next();
            int thevalue = theval.intValue();
            String thehex = misc.toHex(thevalue += 128);
            Integer theaddr = new Integer(addr);
            String theaddress = theaddr.toString();
            theaddress = this.sortsize(theaddress);
            thedata.add(theaddress + " - " + thehex + "(" + thevalue + ")");
            ++addr;
        }
        this.list.setListData(thedata);
    }

    public String sortsize(String thestring) {
        int len = thestring.length();
        if (len == 7) {
            thestring = "0" + thestring;
        }
        if (len == 6) {
            thestring = "00" + thestring;
        }
        if (len == 5) {
            thestring = "000" + thestring;
        }
        if (len == 4) {
            thestring = "0000" + thestring;
        }
        if (len == 3) {
            thestring = "00000" + thestring;
        }
        if (len == 2) {
            thestring = "000000" + thestring;
        }
        if (len == 1) {
            thestring = "0000000" + thestring;
        }
        return thestring;
    }
}

