/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Iterator;

public class highlevel {
    protected ArrayList commands;
    protected ArrayList absolute;
    protected ArrayList[] trace;
    protected ArrayList thevariables;
    protected ArrayList thearrays;
    protected String[] me;
    protected int startaddr;
    protected int arraycounter;
    protected boolean inuse;
    protected int sizeofarray;
    protected ArrayList slicelist;
    protected memorymanager m;

    public highlevel(memorymanager am) {
        this.m = am;
        this.commands = new ArrayList();
        this.thevariables = new ArrayList();
        this.absolute = new ArrayList();
        this.thearrays = new ArrayList();
        this.slicelist = new ArrayList();
        this.startaddr = 0;
        this.sizeofarray = 0;
        this.arraycounter = 0;
        this.inuse = false;
    }

    public void reset() {
        for (int j = 0; j < this.startaddr; ++j) {
            this.trace[j].clear();
        }
        Iterator i = this.slicelist.iterator();
        while (i.hasNext()) {
            slice me = (slice)i.next();
            me.reset();
        }
    }

    public void resetall() {
        this.reset();
        this.commands.clear();
        this.thevariables.clear();
        this.absolute.clear();
        this.thearrays.clear();
        this.slicelist.clear();
        this.startaddr = 0;
        this.sizeofarray = 0;
        this.arraycounter = 0;
        this.inuse = false;
    }

    public void add(ArrayList datatoadd) {
        this.inuse = true;
        Iterator i = datatoadd.iterator();
        int maxsize = 0;
        while (i.hasNext()) {
            String thecommand = (String)i.next();
            boolean overwritestart = true;
            int val = 0;
            if (thecommand.equals("variable")) {
                String thevar = (String)i.next();
                if (this.isarray(thevar)) {
                    String arrayname = (String)i.next();
                    this.addvariable(thevar, this.startaddr, arrayname);
                    overwritestart = false;
                } else {
                    val = new Integer((String)i.next());
                    val += this.startaddr;
                    this.addvariable(thevar, this.startaddr, "");
                }
            } else {
                this.commands.add(thecommand);
                val = new Integer((String)i.next());
                this.absolute.add(new Integer(this.startaddr));
                this.absolute.add(new Integer(val += this.startaddr));
                int thediff = val - this.startaddr;
                if (thediff > maxsize) {
                    maxsize = thediff;
                }
            }
            if (!overwritestart) continue;
            this.startaddr = val;
        }
        this.trace = new ArrayList[this.startaddr];
        for (int j = 0; j < this.startaddr; ++j) {
            this.trace[j] = new ArrayList();
        }
    }

    public void addvariable(String variable, int address, String arrayname) {
        if (this.isarray(variable)) {
            this.sizeofarray = new Integer(variable.substring(6, variable.length()));
            this.thearrays.add("array");
            this.thearrays.add(arrayname);
            this.arraycounter = 0;
        } else if (this.arraycounter >= this.sizeofarray) {
            this.thevariables.add(variable);
            this.thevariables.add(new Integer(address));
        } else {
            this.thearrays.add(variable);
            this.thearrays.add(new Integer(address));
            ++this.arraycounter;
        }
    }

    public ArrayList[] getvariables() {
        ArrayList[] toreturn = new ArrayList[]{this.thevariables, this.thearrays};
        return toreturn;
    }

    public boolean isarray(String variable) {
        if (variable.length() < 6) {
            return false;
        }
        return variable.substring(0, 5).equals("array");
    }

    public int findvar(String varname) {
        String thevar;
        Iterator i = this.thevariables.iterator();
        while (i.hasNext()) {
            thevar = (String)i.next();
            int thevaraddy = (Integer)i.next();
            if (!thevar.equals(varname)) continue;
            return thevaraddy;
        }
        i = this.thearrays.iterator();
        while (i.hasNext()) {
            thevar = (String)i.next();
            if (thevar.equals("array")) {
                Object blankobj = i.next();
                continue;
            }
            int thevaraddy = (Integer)i.next();
            if (!thevar.equals(varname)) continue;
            return thevaraddy;
        }
        return -1;
    }

    public ArrayList[] getall() {
        ArrayList[] toreturn = new ArrayList[]{this.commands, this.absolute};
        return toreturn;
    }

    public int getnum() {
        return this.commands.size();
    }

    public boolean getinuse() {
        return this.inuse;
    }

    public void addtrace(processor p, int pc) {
        if (!this.inuse) {
            return;
        }
        if (pc < this.trace.length) {
            this.trace[pc].add(new Integer(p.getid()));
        }
        if (this.slicelist.size() > 0 && this.isatstartofinstruction(pc)) {
            Iterator i = this.slicelist.iterator();
            while (i.hasNext()) {
                slice theslice = (slice)i.next();
                theslice.trace(pc);
            }
        }
    }

    public boolean isatstartofinstruction(int pc) {
        Iterator i = this.absolute.iterator();
        while (i.hasNext()) {
            if (pc == (Integer)i.next()) {
                return true;
            }
            i.next();
        }
        return false;
    }

    public int[] getaddress(int instructionindex) {
        int[] toreturn = new int[]{(Integer)this.absolute.get(instructionindex * 2), (Integer)this.absolute.get(instructionindex * 2 + 1)};
        return toreturn;
    }

    public int getinstructionnumber(int theaddress) {
        int instructionnum = 1;
        Iterator i = this.absolute.iterator();
        while (i.hasNext()) {
            int thestartaddr = (Integer)i.next();
            int theendaddr = (Integer)i.next();
            if (theaddress >= thestartaddr && theaddress <= theendaddr) {
                return instructionnum;
            }
            ++instructionnum;
        }
        return 0;
    }

    public ArrayList gettrace(int instructionindex) {
        ArrayList<Integer> theprocessors = new ArrayList<Integer>();
        if (!this.inuse) {
            return theprocessors;
        }
        int[] therange = this.getaddress(instructionindex);
        boolean maxsize = false;
        ArrayList currentone = this.trace[therange[0]];
        Iterator i = currentone.iterator();
        while (i.hasNext()) {
            theprocessors.add((Integer)i.next());
        }
        return theprocessors;
    }

    public void addslice(String varname, int varaddress) {
        slice thenewslice = new slice(this, this.m, varname, varaddress);
        this.slicelist.add(thenewslice);
    }

    public void makeslice(String varname, int varaddress, int addresstosliceat) {
        Iterator i = this.slicelist.iterator();
        while (i.hasNext()) {
            slice me = (slice)i.next();
            if (!me.getname().equals(varname)) continue;
            me.addslice(addresstosliceat);
            return;
        }
        this.addslice(varname, varaddress);
        this.makeslice(varname, varaddress, addresstosliceat);
    }

    public boolean isslice(String varname) {
        Iterator i = this.slicelist.iterator();
        while (i.hasNext()) {
            slice me = (slice)i.next();
            if (!me.getname().equals(varname)) continue;
            return true;
        }
        return false;
    }

    public ArrayList[] getslice(String slicename) {
        ArrayList[] toreturn = new ArrayList[2];
        Iterator i = this.slicelist.iterator();
        while (i.hasNext()) {
            slice me = (slice)i.next();
            if (!me.getname().equals(slicename)) continue;
            toreturn = me.getslice();
        }
        return toreturn;
    }
}

