/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class gui
extends JPanel
implements ActionListener,
WindowListener,
MouseListener {
    protected JScrollPane jScrollPane1;
    protected JTree jTree1;
    protected JPopupMenu popup;
    protected JScrollPane jScrollPane12;
    protected JList list;
    private DefaultMutableTreeNode top;
    private long starttime;
    private JMenuItem emulItem;
    private JMenuItem reportItem;
    private JMenuItem traceItem;
    private JMenuItem logItem;
    private JMenuItem resetItem;
    private JMenuItem openItem;
    private JMenuItem exitItem;
    private JMenuItem nextItem;
    private JMenuItem setprocmenu;
    private JMenuItem viewtraceItem;
    private JRadioButtonMenuItem erewmenu;
    private JRadioButtonMenuItem crewmenu;
    private JRadioButtonMenuItem ercwmenu;
    private JRadioButtonMenuItem weakmenu;
    private JRadioButtonMenuItem commonmenu;
    private JRadioButtonMenuItem tollerantmenu;
    private JRadioButtonMenuItem collisionmenu;
    private JRadioButtonMenuItem collisionpmenu;
    private JRadioButtonMenuItem arbitrarymenu;
    private JRadioButtonMenuItem prioritymenu;
    private JRadioButtonMenuItem logerrormenu;
    private JRadioButtonMenuItem fatalerrormenu;
    protected DefaultTreeModel treeModel;
    private memorymanager m;
    private highlevel h;
    private clock c;
    private processorlist plist;
    private executionreport exrep;
    private output o;
    private input in;
    private DefaultMutableTreeNode pcategory;
    private DefaultMutableTreeNode progNode;
    private boolean alreadyopen;

    public static void main(String[] args) {
    }

    public gui(memorymanager am, output ao, clock ac, processorlist aplist, highlevel ah, input ain) {
        this.m = am;
        this.in = ain;
        this.alreadyopen = false;
        this.h = ah;
        this.c = ac;
        this.c.setgui(this);
        this.o = ao;
        this.o.setgui(this);
        this.plist = aplist;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menuBar.add(menu);
        this.openItem = new JMenuItem("Open");
        this.openItem.addActionListener(this);
        menu.add(this.openItem);
        menu.addSeparator();
        this.exitItem = new JMenuItem("Exit");
        this.exitItem.addActionListener(this);
        menu.add(this.exitItem);
        menu = new JMenu("Emulation");
        menu.setMnemonic(18);
        menuBar.add(menu);
        this.emulItem = new JMenuItem("Start");
        this.emulItem.addActionListener(this);
        menu.add(this.emulItem);
        this.nextItem = new JMenuItem("Cycle");
        this.nextItem.setMnemonic(67);
        this.nextItem.addActionListener(this);
        menu.add(this.nextItem);
        this.resetItem = new JMenuItem("Reset");
        this.resetItem.addActionListener(this);
        menu.add(this.resetItem);
        menu = new JMenu("Options");
        menuBar.add(menu);
        JMenu submenu = new JMenu("Memory");
        menu.add(submenu);
        ButtonGroup group = new ButtonGroup();
        this.erewmenu = new JRadioButtonMenuItem("EREW");
        this.erewmenu.setSelected(true);
        group.add(this.erewmenu);
        this.erewmenu.addActionListener(this);
        submenu.add(this.erewmenu);
        this.crewmenu = new JRadioButtonMenuItem("CREW");
        group.add(this.crewmenu);
        this.crewmenu.addActionListener(this);
        submenu.add(this.crewmenu);
        this.ercwmenu = new JRadioButtonMenuItem("ERCW");
        group.add(this.ercwmenu);
        this.ercwmenu.addActionListener(this);
        submenu.add(this.ercwmenu);
        JMenu crcwmenu = new JMenu("CRCW");
        submenu.add(crcwmenu);
        this.weakmenu = new JRadioButtonMenuItem("Weak");
        group.add(this.weakmenu);
        this.weakmenu.addActionListener(this);
        crcwmenu.add(this.weakmenu);
        this.commonmenu = new JRadioButtonMenuItem("Common");
        group.add(this.commonmenu);
        this.commonmenu.addActionListener(this);
        crcwmenu.add(this.commonmenu);
        this.tollerantmenu = new JRadioButtonMenuItem("Tollerant");
        group.add(this.tollerantmenu);
        this.tollerantmenu.addActionListener(this);
        crcwmenu.add(this.tollerantmenu);
        this.collisionmenu = new JRadioButtonMenuItem("Collision");
        group.add(this.collisionmenu);
        this.collisionmenu.addActionListener(this);
        crcwmenu.add(this.collisionmenu);
        this.collisionpmenu = new JRadioButtonMenuItem("Collision+");
        group.add(this.collisionpmenu);
        this.collisionpmenu.addActionListener(this);
        crcwmenu.add(this.collisionpmenu);
        this.arbitrarymenu = new JRadioButtonMenuItem("Arbitrary");
        group.add(this.arbitrarymenu);
        this.arbitrarymenu.addActionListener(this);
        crcwmenu.add(this.arbitrarymenu);
        this.prioritymenu = new JRadioButtonMenuItem("Priority");
        group.add(this.prioritymenu);
        this.prioritymenu.addActionListener(this);
        crcwmenu.add(this.prioritymenu);
        submenu = new JMenu("Memory Error");
        menu.add(submenu);
        ButtonGroup group2 = new ButtonGroup();
        this.logerrormenu = new JRadioButtonMenuItem("Log");
        this.logerrormenu.setSelected(true);
        group2.add(this.logerrormenu);
        this.logerrormenu.addActionListener(this);
        submenu.add(this.logerrormenu);
        this.fatalerrormenu = new JRadioButtonMenuItem("Fatal");
        group2.add(this.fatalerrormenu);
        this.fatalerrormenu.addActionListener(this);
        submenu.add(this.fatalerrormenu);
        menu.addSeparator();
        this.setprocmenu = new JMenuItem("Change Processors");
        this.setprocmenu.addActionListener(this);
        menu.add(this.setprocmenu);
        menu = new JMenu("Report");
        menuBar.add(menu);
        this.reportItem = new JMenuItem("View Report");
        this.reportItem.setEnabled(false);
        this.reportItem.addActionListener(this);
        menu.add(this.reportItem);
        this.logItem = new JMenuItem("Memory Error Log");
        this.logItem.setEnabled(false);
        this.logItem.addActionListener(this);
        menu.add(this.logItem);
        this.popup = new JPopupMenu();
        this.traceItem = new JMenuItem("Add Trace");
        this.traceItem.addActionListener(this);
        this.popup.add(this.traceItem);
        this.viewtraceItem = new JMenuItem("View Trace");
        this.viewtraceItem.addActionListener(this);
        this.viewtraceItem.setEnabled(false);
        this.popup.add(this.viewtraceItem);
        JFrame theframe = new JFrame("PRAM Simulator");
        Container cpane = theframe.getContentPane();
        cpane.setLayout(new BorderLayout());
        this.top = new DefaultMutableTreeNode("Simulator");
        this.createNodes(this.top);
        this.treeModel = new DefaultTreeModel(this.top);
        this.jTree1 = new JTree(this.treeModel);
        this.jTree1.getSelectionModel().setSelectionMode(1);
        this.jTree1.addMouseListener(this);
        this.jTree1.putClientProperty("JTree.lineStyle", "None");
        this.jScrollPane1 = new JScrollPane(this.jTree1);
        String[] data = new String[]{};
        this.list = new JList<String>(data);
        this.jScrollPane12 = new JScrollPane(this.list);
        JSplitPane splitPane = new JSplitPane(0);
        Dimension minimumSize = new Dimension(100, 50);
        this.jScrollPane1.setMinimumSize(minimumSize);
        this.jScrollPane12.setMinimumSize(minimumSize);
        splitPane.setTopComponent(this.jScrollPane1);
        splitPane.setBottomComponent(this.jScrollPane12);
        splitPane.setDividerLocation(250);
        splitPane.setPreferredSize(new Dimension(500, 300));
        splitPane.setResizeWeight(0.9);
        cpane.add((Component)splitPane, "Center");
        theframe.setJMenuBar(menuBar);
        theframe.addWindowListener(this);
        theframe.pack();
        theframe.setSize(600, 400);
        theframe.setVisible(true);
    }

    public void mouseClicked(MouseEvent e) {
        JComponent cl = (JComponent)e.getSource();
        if (e.isPopupTrigger()) {
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
        if (cl == this.jTree1 && e.getClickCount() == 2) {
            TreePath selPath = this.jTree1.getPathForLocation(e.getX(), e.getY());
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.jTree1.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            Object nodeInfo = node.getUserObject();
            if (node.isLeaf()) {
                DefaultMutableTreeNode thenode;
                String name = (String)nodeInfo;
                String selectiontype = new String("");
                boolean sofar = false;
                if (name.length() >= 6) {
                    selectiontype = name.substring(0, 6);
                }
                if (selectiontype.equals("Output")) {
                    sofar = true;
                    guioutput ogui = new guioutput(this.o);
                }
                if (name.equals("High Level Code")) {
                    sofar = true;
                    guihighlevel hl = new guihighlevel(this.h, this.m);
                }
                if (name.length() >= 9) {
                    selectiontype = name.substring(0, 9);
                }
                if (selectiontype.equals("Processor")) {
                    String processornum = name.substring(10, name.length());
                    int pindex = new Integer(processornum);
                    processorgui pview = new processorgui(this.plist.get(--pindex));
                }
                if (((String)(thenode = (DefaultMutableTreeNode)selPath.getPathComponent(1)).getUserObject()).equals("Shared Memory")) {
                    String memindex = this.getmemindex(name);
                    int mindex = new Integer(memindex);
                    memorygui mview = new memorygui(this.m, mindex);
                }
                if (this.isinpath("Variables", selPath)) {
                    int theaddrofvar = this.h.findvar(name);
                    guival thevarview = new guival(name, this.m, theaddrofvar);
                }
            }
        }
    }

    public boolean isinpath(String totest, TreePath selPath) {
        for (int i = 0; i < selPath.getPathCount(); ++i) {
            DefaultMutableTreeNode thenode = (DefaultMutableTreeNode)selPath.getPathComponent(i);
            String textofnode = (String)thenode.getUserObject();
            if (!textofnode.equals(totest)) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(ActionEvent e) {
        String name;
        Object nodeInfo;
        TreePath selPath;
        JFileChooser chooser;
        int returnVal;
        JMenuItem cl = (JMenuItem)e.getSource();
        String st = cl.getText();
        if (cl == this.erewmenu) {
            this.m.setmodel(1);
        }
        if (cl == this.crewmenu) {
            this.m.setmodel(2);
        }
        if (cl == this.ercwmenu) {
            this.m.setmodel(3);
        }
        if (cl == this.weakmenu) {
            this.m.setmodel(4);
            this.m.setcrcwmodel(0);
        }
        if (cl == this.commonmenu) {
            this.m.setmodel(4);
            this.m.setcrcwmodel(1);
        }
        if (cl == this.tollerantmenu) {
            this.m.setmodel(4);
            this.m.setcrcwmodel(2);
        }
        if (cl == this.collisionmenu) {
            this.m.setmodel(4);
            this.m.setcrcwmodel(3);
        }
        if (cl == this.collisionpmenu) {
            this.m.setmodel(4);
            this.m.setcrcwmodel(4);
        }
        if (cl == this.arbitrarymenu) {
            this.m.setmodel(4);
            this.m.setcrcwmodel(5);
        }
        if (cl == this.prioritymenu) {
            this.m.setmodel(4);
            this.m.setcrcwmodel(6);
        }
        if (cl == this.openItem && (returnVal = (chooser = new JFileChooser()).showOpenDialog(this)) == 0) {
            if (this.alreadyopen) {
                this.hardreset();
                MutableTreeNode parent = (MutableTreeNode)this.progNode.getParent();
                if (parent != null) {
                    this.treeModel.removeNodeFromParent(this.progNode);
                }
            } else {
                this.alreadyopen = true;
            }
            String filename = chooser.getSelectedFile().getName();
            String path = chooser.getSelectedFile().getPath();
            if (misc.getEnd(filename).equals("pr")) {
                int numberproc = this.plist.size();
                this.h = misc.usetoloadmem(path, this.m, this.h, this.plist, this.o, this.in);
                int nownumberproc = this.plist.size();
                if (numberproc != nownumberproc) {
                    this.updateproclist();
                }
                this.changememmodelselection();
            } else {
                misc.loadMemory(path, this.m);
            }
            this.progNode = new DefaultMutableTreeNode(filename);
            if (this.h.getinuse()) {
                ArrayList[] thevars = this.h.getvariables();
                if (thevars[0].size() > 0 || thevars[1].size() > 0) {
                    DefaultMutableTreeNode varbox = new DefaultMutableTreeNode("Variables");
                    this.progNode.add(varbox);
                    Iterator j = thevars[1].iterator();
                    Object blankobj = j.next();
                    while (j.hasNext()) {
                        String variable = new String("");
                        DefaultMutableTreeNode arrayvar = new DefaultMutableTreeNode(j.next());
                        varbox.add(arrayvar);
                        while (!variable.equals("array")) {
                            variable = !j.hasNext() ? "array" : (String)j.next();
                            if (variable.equals("array")) continue;
                            Integer addr = (Integer)j.next();
                            DefaultMutableTreeNode inarrayvar = new DefaultMutableTreeNode(variable);
                            arrayvar.add(inarrayvar);
                        }
                    }
                    j = thevars[0].iterator();
                    while (j.hasNext()) {
                        DefaultMutableTreeNode thevar = new DefaultMutableTreeNode((String)j.next());
                        varbox.add(thevar);
                        Integer addr = (Integer)j.next();
                    }
                }
                DefaultMutableTreeNode hlcode = new DefaultMutableTreeNode("High Level Code");
                this.progNode.add(hlcode);
            }
            DefaultMutableTreeNode filesize = new DefaultMutableTreeNode("Size: " + new Integer(misc.numberinstructions() * 4).toString() + " bytes");
            this.progNode.add(filesize);
            this.treeModel.insertNodeInto(this.progNode, this.top, this.top.getChildCount());
        }
        if (cl == this.resetItem) {
            this.softreset();
        }
        if (cl == this.exitItem) {
            System.exit(0);
        }
        if (cl == this.traceItem) {
            selPath = this.jTree1.getSelectionPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.jTree1.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            nodeInfo = node.getUserObject();
            if (node.isLeaf()) {
                name = (String)nodeInfo;
                if (this.isinpath("Variables", selPath)) {
                    int theaddrofvar = this.h.findvar(name);
                    guihighlevel thetraceview = new guihighlevel(this.h, this.m, theaddrofvar, name);
                }
            }
        }
        if (cl == this.viewtraceItem) {
            selPath = this.jTree1.getSelectionPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.jTree1.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            nodeInfo = node.getUserObject();
            if (node.isLeaf()) {
                name = (String)nodeInfo;
                if (this.isinpath("Variables", selPath)) {
                    slicegui thesliceview = new slicegui(this.h, name);
                }
            }
        }
        if (cl == this.logItem) {
            memerrorgui mer = new memerrorgui(this.m);
        }
        if (cl == this.reportItem) {
            guireport repgui = new guireport(this.exrep);
        }
        if (cl == this.setprocmenu) {
            guival proclistings = new guival(this, this.plist, this.m, this.o, this.in, this.h);
        }
        if (cl == this.fatalerrormenu) {
            this.c.seterrormemstate(true);
        }
        if (cl == this.logerrormenu) {
            this.c.seterrormemstate(false);
        }
        if (cl == this.emulItem) {
            if (this.c.getrunning()) {
                JOptionPane.showMessageDialog(this, "A program is currently being executed");
            } else if (!this.alreadyopen) {
                JOptionPane.showMessageDialog(this, "There is no program loaded to execute");
            } else {
                this.o.resetupdate();
                this.exrep = new executionreport(this.plist, this.m);
                Date starttimer = new Date();
                this.starttime = starttimer.getTime();
                this.c.setreport(this.exrep);
                this.c.setmemmanager(this.m);
                new Thread(this.c).start();
                this.reportItem.setEnabled(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateoutput() {
        Vector<String> thedata;
        Vector<String> vector = thedata = new Vector<String>();
        synchronized (vector) {
            ArrayList display = this.o.getdisplay();
            Iterator i = display.iterator();
            while (i.hasNext()) {
                thedata.add((String)i.next());
            }
            this.list.setListData(thedata);
        }
    }

    public void windowActivated(WindowEvent pWindowEvent) {
    }

    public void windowClosed(WindowEvent pWindowEvent) {
    }

    public void windowClosing(WindowEvent pWindowEvent) {
        Window tWindow = pWindowEvent.getWindow();
        tWindow.setVisible(false);
        tWindow.dispose();
        System.exit(0);
    }

    public void windowDeactivated(WindowEvent pWindowEvent) {
    }

    public void windowDeiconified(WindowEvent pWindowEvent) {
    }

    public void windowIconified(WindowEvent pWindowEvent) {
    }

    public void windowOpened(WindowEvent pWindowEvent) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.viewtraceItem.setEnabled(false);
            TreePath selPath = this.jTree1.getSelectionPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.jTree1.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            Object nodeInfo = node.getUserObject();
            if (node.isLeaf()) {
                String name = (String)nodeInfo;
                if (this.isinpath("Variables", selPath) && this.h.isslice(name)) {
                    this.viewtraceItem.setEnabled(true);
                }
            }
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.viewtraceItem.setEnabled(false);
            TreePath selPath = this.jTree1.getSelectionPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.jTree1.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            Object nodeInfo = node.getUserObject();
            if (node.isLeaf()) {
                String name = (String)nodeInfo;
                if (this.isinpath("Variables", selPath) && this.h.isslice(name)) {
                    this.viewtraceItem.setEnabled(true);
                }
            }
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    private void createNodes(DefaultMutableTreeNode top) {
        DefaultMutableTreeNode category = null;
        DefaultMutableTreeNode memory2 = null;
        DefaultMutableTreeNode thep = null;
        DefaultMutableTreeNode book = null;
        this.pcategory = new DefaultMutableTreeNode("Processors");
        top.add(this.pcategory);
        ArrayList theprocessors = this.plist.get();
        Iterator i = theprocessors.iterator();
        int j = 1;
        while (i.hasNext()) {
            i.next();
            thep = new DefaultMutableTreeNode(new String("Processor " + j));
            this.pcategory.add(thep);
            ++j;
        }
        if (this.plist.size() == 0) {
            thep = new DefaultMutableTreeNode(new String("None"));
            this.pcategory.add(thep);
        }
        memory2 = new DefaultMutableTreeNode("Shared Memory");
        top.add(memory2);
        int memsize = this.m.getsize();
        int thenumber = 0;
        int dividesize = (memsize /= 1024) / 100;
        ++dividesize;
        for (int p = 0; p < dividesize; ++p) {
            category = new DefaultMutableTreeNode(p * 100 + " - " + (p + 1) * 100 + " Kb");
            memory2.add(category);
            for (int tencount = 0; tencount < 10; ++tencount) {
                DefaultMutableTreeNode tencategory = new DefaultMutableTreeNode((p * 10 + tencount) * 10 + " - " + (p * 10 + tencount + 1) * 10 + " Kb");
                category.add(tencategory);
                for (j = 0; j < 10; ++j) {
                    if (thenumber >= memsize) {
                        j = 101;
                        tencount = 11;
                        p = dividesize + 1;
                    }
                    book = new DefaultMutableTreeNode(new String(thenumber + " - " + (thenumber + 1) + " Kb"));
                    tencategory.add(book);
                    ++thenumber;
                }
            }
        }
        DefaultMutableTreeNode clocknode = new DefaultMutableTreeNode("Clock");
        top.add(clocknode);
        DefaultMutableTreeNode viewclocknode = new DefaultMutableTreeNode("View");
        clocknode.add(viewclocknode);
        DefaultMutableTreeNode exservicenode = new DefaultMutableTreeNode("External Services");
        top.add(exservicenode);
        DefaultMutableTreeNode outputnode = new DefaultMutableTreeNode("Output");
        exservicenode.add(outputnode);
    }

    public String getmemindex(String theselection) {
        String toreturn = theselection.substring(0, 1);
        for (int i = 1; i < theselection.length(); ++i) {
            String thecharacter = theselection.substring(i, i + 1);
            if (thecharacter.equals(" ")) {
                i = theselection.length();
                continue;
            }
            toreturn = toreturn + thecharacter;
        }
        return toreturn;
    }

    public void clockdone() {
        Date endtimer = new Date();
        long endtime = endtimer.getTime();
        this.exrep.settime(endtime - this.starttime);
        if (this.m.geterrors() != 0) {
            this.logItem.setEnabled(true);
        }
    }

    public void fatalmemerror(int thecycle) {
        JOptionPane.showMessageDialog(this, "Execution Terminated Due To Memory Error At Cycle " + thecycle);
    }

    public void softreset() {
        this.o.reset();
        if (this.exrep != null) {
            this.exrep.reset();
        }
        this.c.resetall();
        ArrayList proclist = this.plist.get();
        Iterator i = proclist.iterator();
        while (i.hasNext()) {
            processor ptouse = (processor)i.next();
            ptouse.resetall();
        }
        this.in.reset();
        this.h.reset();
        this.m.reset();
        this.updateoutput();
        this.reportItem.setEnabled(false);
        this.logItem.setEnabled(false);
    }

    public void hardreset() {
        this.softreset();
        this.m.resetall();
        this.h.resetall();
        this.changememmodelselection();
    }

    public void changememmodelselection() {
        int memmode = this.m.getmodel();
        int crcwmode = this.m.getcrcwmodel();
        if (memmode == 1) {
            this.erewmenu.setSelected(true);
        }
        if (memmode == 2) {
            this.crewmenu.setSelected(true);
        }
        if (memmode == 3) {
            this.ercwmenu.setSelected(true);
        }
        if (memmode == 4) {
            if (crcwmode == 0) {
                this.weakmenu.setSelected(true);
            }
            if (crcwmode == 1) {
                this.commonmenu.setSelected(true);
            }
            if (crcwmode == 2) {
                this.tollerantmenu.setSelected(true);
            }
            if (crcwmode == 3) {
                this.collisionmenu.setSelected(true);
            }
            if (crcwmode == 4) {
                this.collisionpmenu.setSelected(true);
            }
            if (crcwmode == 5) {
                this.arbitrarymenu.setSelected(true);
            }
            if (crcwmode == 6) {
                this.prioritymenu.setSelected(true);
            }
        }
    }

    public void updateproclist() {
        MutableTreeNode parent = (MutableTreeNode)this.pcategory.getParent();
        if (parent != null) {
            this.treeModel.removeNodeFromParent(this.pcategory);
        }
        this.pcategory = new DefaultMutableTreeNode("Processors");
        int numberprocessors = this.plist.size();
        for (int pcount = 1; pcount <= numberprocessors; ++pcount) {
            DefaultMutableTreeNode proccy = new DefaultMutableTreeNode("Processor " + pcount);
            this.pcategory.add(proccy);
        }
        this.treeModel.insertNodeInto(this.pcategory, this.top, 0);
    }
}

